/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib.version.manager;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.VersionManagerCache;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.VersionManagerClient;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.client.VersionManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionManagerRunner {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig installConfig;
    private final VersionManagerCache versionManagerCache;
    private final VersionManagerClient versionManagerClient;

    public VersionManagerRunner(InstallConfig installConfig, VersionManagerCache versionManagerCache) {
        this.installConfig = installConfig;
        this.versionManagerCache = versionManagerCache;
        VersionManagerFactory versionManagerFactory = new VersionManagerFactory(installConfig);
        this.versionManagerClient = versionManagerFactory.getClient(versionManagerCache.getVersionManagerType());
    }

    public void populateCacheForVersion(String nodeVersion) {
        this.logger.debug("Populating version manager cache for node: {}", (Object)nodeVersion);
        this.versionManagerCache.setNodeExecutable(this.versionManagerClient.getNodeExecutable(nodeVersion));
        this.versionManagerCache.setNpmExecutable(this.versionManagerClient.getNpmExecutable(nodeVersion));
        if (this.versionManagerCache.isNodeAvailable()) {
            this.logger.info("Using {} version manager", (Object)this.versionManagerCache.getVersionManagerType());
            this.logger.info("Requested node version {} is already installed", (Object)nodeVersion);
        } else {
            this.logger.warn("Requested node version {} is not installed in version manager", (Object)nodeVersion);
        }
    }
}

