/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.Architecture;
import com.github.eirslett.maven.plugins.frontend.lib.OS;
import java.io.File;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Platform {
    private static final int NODE_VERSION_THRESHOLD_MAC_ARM64 = 16;
    private final String nodeDownloadRoot;
    private final OS os;
    private final Architecture architecture;
    private final String classifier;

    public Platform() {
        this(OS.guess(), Architecture.guess());
    }

    public Platform(OS os, Architecture architecture) {
        this("https://nodejs.org/dist/", os, architecture, null);
    }

    public Platform(String nodeDownloadRoot, OS os, Architecture architecture, String classifier) {
        this.nodeDownloadRoot = nodeDownloadRoot;
        this.os = os;
        this.architecture = architecture;
        this.classifier = classifier;
    }

    public static Platform guess() {
        return Platform.guess(OS.guess(), Architecture.guess(), Platform::CHECK_FOR_ALPINE);
    }

    public static Boolean CHECK_FOR_ALPINE() {
        return new File("/etc/alpine-release").exists();
    }

    public static Platform guess(OS os, Architecture architecture, Supplier<Boolean> checkForAlpine) {
        if (os == OS.Linux && checkForAlpine.get().booleanValue()) {
            return new Platform("https://unofficial-builds.nodejs.org/download/release/", os, architecture, "musl");
        }
        return new Platform(os, architecture);
    }

    public String getNodeDownloadRoot() {
        return this.nodeDownloadRoot;
    }

    public String getArchiveExtension() {
        return this.os.getArchiveExtension();
    }

    public String getCodename() {
        return this.os.getCodename();
    }

    public boolean isWindows() {
        return this.os == OS.Windows;
    }

    public boolean isMac() {
        return this.os == OS.Mac;
    }

    public String getArchitectureName() {
        return this.architecture.name();
    }

    public String getLongNodeFilename(String nodeVersion, boolean archiveOnWindows) {
        if (this.isWindows() && !archiveOnWindows) {
            return "node.exe";
        }
        return "node-" + nodeVersion + "-" + this.getNodeClassifier(nodeVersion);
    }

    public String getNodeDownloadFilename(String nodeVersion, boolean archiveOnWindows) {
        if (this.isWindows() && !archiveOnWindows) {
            if (this.architecture == Architecture.x64) {
                if (nodeVersion.startsWith("v0.")) {
                    return nodeVersion + "/x64/node.exe";
                }
                return nodeVersion + "/win-x64/node.exe";
            }
            if (nodeVersion.startsWith("v0.")) {
                return nodeVersion + "/node.exe";
            }
            return nodeVersion + "/win-x86/node.exe";
        }
        return nodeVersion + "/" + this.getLongNodeFilename(nodeVersion, archiveOnWindows) + "." + this.os.getArchiveExtension();
    }

    public String getNodeClassifier(String nodeVersion) {
        String result = this.getCodename() + "-" + this.resolveArchitecture(nodeVersion).name();
        return this.classifier != null ? result + "-" + this.classifier : result;
    }

    private Architecture resolveArchitecture(String nodeVersion) {
        Integer nodeMajorVersion;
        if (this.isMac() && this.architecture == Architecture.arm64 && ((nodeMajorVersion = Platform.getNodeMajorVersion(nodeVersion)) == null || nodeMajorVersion < 16)) {
            return Architecture.x64;
        }
        return this.architecture;
    }

    static Integer getNodeMajorVersion(String nodeVersion) {
        Matcher matcher = Pattern.compile("^v(\\d+)\\..*$").matcher(nodeVersion);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return null;
    }
}

