/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsInstallationWork;
import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.VersionManagerCache;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInstaller {
    public static final String NODEJS_ORG = "nodejs.org";
    public static final String ATLASSIAN_NODE_DOWNLOAD_ROOT = "https://packages.atlassian.com/artifactory/nodejs-dist/";
    public static final String INSTALL_PATH = "/node";
    private static final Object LOCK = new Object();
    private String npmVersion;
    private String nodeVersion;
    private String nodeDownloadRoot;
    private String userName;
    private String password;
    private Map<String, String> httpHeaders;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig installConfig;
    private final VersionManagerCache versionManagerCache;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    NodeInstaller(InstallConfig config, VersionManagerCache versionManagerCache, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.installConfig = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
        this.versionManagerCache = versionManagerCache;
    }

    public NodeInstaller setNodeVersion(String nodeVersion) {
        this.nodeVersion = nodeVersion;
        return this;
    }

    public NodeInstaller setNodeDownloadRoot(String nodeDownloadRoot) {
        this.nodeDownloadRoot = nodeDownloadRoot;
        return this;
    }

    public NodeInstaller setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
        return this;
    }

    public NodeInstaller setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public NodeInstaller setPassword(String password) {
        this.password = password;
        return this;
    }

    public NodeInstaller setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    private boolean npmProvided() throws InstallationException {
        if (this.npmVersion != null) {
            if ("provided".equals(this.npmVersion)) {
                if (Integer.parseInt(this.nodeVersion.replace("v", "").split("[.]")[0]) < 4) {
                    throw new InstallationException("NPM version is '" + this.npmVersion + "' but Node didn't include NPM prior to v4.0.0");
                }
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtlassianDevMetricsInstallationWork install() throws InstallationException {
        AtlassianDevMetricsInstallationWork work = AtlassianDevMetricsInstallationWork.INSTALLED;
        Object object = LOCK;
        synchronized (object) {
            if (this.nodeDownloadRoot == null || this.nodeDownloadRoot.isEmpty()) {
                this.nodeDownloadRoot = this.installConfig.getPlatform().getNodeDownloadRoot();
            }
            if (!this.nodeIsAlreadyInstalled()) {
                this.logger.info("Installing node version {}", (Object)this.nodeVersion);
                if (!this.nodeVersion.startsWith("v")) {
                    this.logger.warn("Node version does not start with naming convention 'v'.");
                }
                work = this.installConfig.getPlatform().isWindows() ? (this.npmProvided() ? this.installNodeWithNpmForWindows() : this.installNodeForWindows()) : this.installNodeDefault();
            } else {
                work = AtlassianDevMetricsInstallationWork.INSTALLED;
            }
        }
        return work;
    }

    private boolean nodeIsAlreadyInstalled() {
        try {
            InstallNodeExecutorConfig executorConfig = new InstallNodeExecutorConfig(this.installConfig, this.versionManagerCache);
            File nodeFile = executorConfig.getNodePath();
            if (nodeFile.exists()) {
                String version = new NodeExecutor(executorConfig, Arrays.asList("--version"), null).executeAndGetResult(this.logger);
                if (version.equals(this.nodeVersion)) {
                    this.logger.info("Node {} is already installed.", (Object)version);
                    return true;
                }
                this.logger.info("Node {} was installed, but we need version {}", (Object)version, (Object)this.nodeVersion);
                return false;
            }
            return false;
        }
        catch (ProcessExecutionException e) {
            this.logger.warn("Unable to determine current node version: {}", (Object)e.getMessage());
            return false;
        }
    }

    private AtlassianDevMetricsInstallationWork installNodeDefault() throws InstallationException {
        try {
            String longNodeFilename = this.installConfig.getPlatform().getLongNodeFilename(this.nodeVersion, false);
            String downloadUrl = this.nodeDownloadRoot + this.installConfig.getPlatform().getNodeDownloadFilename(this.nodeVersion, false);
            String classifier = this.installConfig.getPlatform().getNodeClassifier(this.nodeVersion);
            File tmpDirectory = this.getTempDirectory();
            CacheDescriptor cacheDescriptor = new CacheDescriptor("node", this.nodeVersion, classifier, this.installConfig.getPlatform().getArchiveExtension());
            File archive = this.installConfig.getCacheResolver().resolve(cacheDescriptor);
            AtlassianDevMetricsInstallationWork work = this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password, this.httpHeaders);
            try {
                this.extractFile(archive, tmpDirectory);
            }
            catch (ArchiveExtractionException e) {
                if (e.getCause() instanceof EOFException) {
                    this.logger.error("The archive file {} is corrupted and will be deleted. Please try the build again.", (Object)archive.getPath());
                    archive.delete();
                    FileUtils.deleteDirectory((File)tmpDirectory);
                }
                throw e;
            }
            File nodeBinary = new File(tmpDirectory, longNodeFilename + File.separator + "bin" + File.separator + "node");
            if (!nodeBinary.exists()) {
                throw new FileNotFoundException("Could not find the downloaded Node.js binary in " + nodeBinary);
            }
            File destinationDirectory = this.getInstallDirectory();
            File destination = new File(destinationDirectory, "node");
            this.logger.info("Copying node binary from {} to {}", (Object)nodeBinary, (Object)destination);
            if (destination.exists() && !destination.delete()) {
                throw new InstallationException("Could not install Node: Was not allowed to delete " + destination);
            }
            try {
                Files.move(nodeBinary.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new InstallationException("Could not install Node: Was not allowed to rename " + nodeBinary + " to " + destination);
            }
            if (!destination.setExecutable(true, false)) {
                throw new InstallationException("Could not install Node: Was not allowed to make " + destination + " executable.");
            }
            if (this.npmProvided()) {
                File tmpNodeModulesDir = new File(tmpDirectory, longNodeFilename + File.separator + "lib" + File.separator + "node_modules");
                File nodeModulesDirectory = new File(destinationDirectory, "node_modules");
                File npmDirectory = new File(nodeModulesDirectory, "npm");
                FileUtils.copyDirectory((File)tmpNodeModulesDir, (File)nodeModulesDirectory);
                this.logger.info("Extracting NPM");
                for (String script : Arrays.asList("npm", "npm.cmd", "npx", "npx.cmd")) {
                    File copy;
                    File scriptFile = new File(npmDirectory, "bin" + File.separator + script);
                    if (!scriptFile.exists() || (copy = new File(destinationDirectory, script)).exists()) continue;
                    try {
                        FileUtils.copyFile((File)scriptFile, (File)copy);
                    }
                    catch (IOException e) {
                        throw new InstallationException("Could not copy npm", e);
                    }
                    copy.setExecutable(true);
                }
            }
            this.deleteTempDirectory(tmpDirectory);
            this.logger.info("Installed node locally.");
            return work;
        }
        catch (IOException e) {
            throw new InstallationException("Could not install Node", e);
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download Node.js", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the Node archive", e);
        }
    }

    private AtlassianDevMetricsInstallationWork installNodeWithNpmForWindows() throws InstallationException {
        try {
            String longNodeFilename = this.installConfig.getPlatform().getLongNodeFilename(this.nodeVersion, true);
            String downloadUrl = this.nodeDownloadRoot + this.installConfig.getPlatform().getNodeDownloadFilename(this.nodeVersion, true);
            String classifier = this.installConfig.getPlatform().getNodeClassifier(this.nodeVersion);
            File tmpDirectory = this.getTempDirectory();
            CacheDescriptor cacheDescriptor = new CacheDescriptor("node", this.nodeVersion, classifier, this.installConfig.getPlatform().getArchiveExtension());
            File archive = this.installConfig.getCacheResolver().resolve(cacheDescriptor);
            AtlassianDevMetricsInstallationWork work = this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password, this.httpHeaders);
            this.extractFile(archive, tmpDirectory);
            File nodeBinary = new File(tmpDirectory, longNodeFilename + File.separator + "node.exe");
            if (!nodeBinary.exists()) {
                throw new FileNotFoundException("Could not find the downloaded Node.js binary in " + nodeBinary);
            }
            File destinationDirectory = this.getInstallDirectory();
            File destination = new File(destinationDirectory, "node.exe");
            this.logger.info("Copying node binary from {} to {}", (Object)nodeBinary, (Object)destination);
            try {
                Files.move(nodeBinary.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new InstallationException("Could not install Node: Was not allowed to rename " + nodeBinary + " to " + destination);
            }
            if ("provided".equals(this.npmVersion)) {
                File tmpNodeModulesDir = new File(tmpDirectory, longNodeFilename + File.separator + "node_modules");
                File nodeModulesDirectory = new File(destinationDirectory, "node_modules");
                FileUtils.copyDirectory((File)tmpNodeModulesDir, (File)nodeModulesDirectory);
            }
            this.deleteTempDirectory(tmpDirectory);
            this.logger.info("Installed node locally.");
            return work;
        }
        catch (IOException e) {
            throw new InstallationException("Could not install Node", e);
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download Node.js", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the Node archive", e);
        }
    }

    private AtlassianDevMetricsInstallationWork installNodeForWindows() throws InstallationException {
        String downloadUrl = this.nodeDownloadRoot + this.installConfig.getPlatform().getNodeDownloadFilename(this.nodeVersion, false);
        try {
            File destinationDirectory = this.getInstallDirectory();
            File destination = new File(destinationDirectory, "node.exe");
            String classifier = this.installConfig.getPlatform().getNodeClassifier(this.nodeVersion);
            CacheDescriptor cacheDescriptor = new CacheDescriptor("node", this.nodeVersion, classifier, "exe");
            File binary = this.installConfig.getCacheResolver().resolve(cacheDescriptor);
            AtlassianDevMetricsInstallationWork work = this.downloadFileIfMissing(downloadUrl, binary, this.userName, this.password, this.httpHeaders);
            this.logger.info("Copying node binary from {} to {}", (Object)binary, (Object)destination);
            FileUtils.copyFile((File)binary, (File)destination);
            this.logger.info("Installed node locally.");
            return work;
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download Node.js from: " + downloadUrl, e);
        }
        catch (IOException e) {
            throw new InstallationException("Could not install Node.js", e);
        }
    }

    private File getTempDirectory() {
        File tmpDirectory = new File(this.getInstallDirectory(), "tmp");
        if (!tmpDirectory.exists()) {
            this.logger.debug("Creating temporary directory {}", (Object)tmpDirectory);
            tmpDirectory.mkdirs();
        }
        return tmpDirectory;
    }

    private File getInstallDirectory() {
        File installDirectory = new File(this.installConfig.getInstallDirectory(), INSTALL_PATH);
        if (!installDirectory.exists()) {
            this.logger.debug("Creating install directory {}", (Object)installDirectory);
            installDirectory.mkdirs();
        }
        return installDirectory;
    }

    private void deleteTempDirectory(File tmpDirectory) throws IOException {
        if (tmpDirectory != null && tmpDirectory.exists()) {
            this.logger.debug("Deleting temporary directory {}", (Object)tmpDirectory);
            FileUtils.deleteDirectory((File)tmpDirectory);
        }
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
        this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
    }

    private AtlassianDevMetricsInstallationWork downloadFileIfMissing(String downloadUrl, File destination, String userName, String password, Map<String, String> httpHeaders) throws DownloadException {
        if (!destination.exists()) {
            this.downloadFile(downloadUrl, destination, userName, password, httpHeaders);
            return AtlassianDevMetricsInstallationWork.DOWNLOADED;
        }
        return AtlassianDevMetricsInstallationWork.CACHED;
    }

    private void downloadFile(String downloadUrl, File destination, String userName, String password, Map<String, String> httpHeaders) throws DownloadException {
        this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
        this.fileDownloader.download(downloadUrl, destination.getPath(), userName, password, httpHeaders);
    }
}

