/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.VersionManagerCache;
import java.io.File;

final class InstallNodeExecutorConfig
implements NodeExecutorConfig {
    private static final String NODE_WINDOWS = "/node".replaceAll("/", "\\\\") + "\\node.exe";
    private static final String NODE_DEFAULT = "/node/node";
    private static final String NPM = "/node/node_modules/npm/bin/npm-cli.js";
    private static final String PNPM = "/node/node_modules/pnpm/bin/pnpm.js";
    private static final String PNPM_CJS = "/node/node_modules/pnpm/bin/pnpm.cjs";
    private static final String COREPACK = "/node/node_modules/corepack/dist/corepack.js";
    private static final String NPX = "/node/node_modules/npm/bin/npx-cli.js";
    private final InstallConfig installConfig;
    private final VersionManagerCache versionManagerCache;

    public InstallNodeExecutorConfig(InstallConfig installConfig) {
        this(installConfig, null);
    }

    public InstallNodeExecutorConfig(InstallConfig installConfig, VersionManagerCache versionManagerCache) {
        this.installConfig = installConfig;
        this.versionManagerCache = versionManagerCache;
    }

    @Override
    public File getNodePath() {
        if (this.versionManagerCache != null && this.versionManagerCache.isNodeAvailable()) {
            return this.versionManagerCache.getNodeExecutable();
        }
        String nodeExecutable = this.getPlatform().isWindows() ? NODE_WINDOWS : NODE_DEFAULT;
        return new File(this.installConfig.getInstallDirectory() + nodeExecutable);
    }

    @Override
    public File getNpmPath() {
        if (this.versionManagerCache != null && this.versionManagerCache.isNodeAvailable()) {
            return this.versionManagerCache.getNpmExecutable();
        }
        return new File(this.installConfig.getInstallDirectory() + Utils.normalize(NPM));
    }

    @Override
    public File getPnpmPath() {
        return new File(this.installConfig.getInstallDirectory() + Utils.normalize(PNPM));
    }

    @Override
    public File getPnpmCjsPath() {
        return new File(this.installConfig.getInstallDirectory() + Utils.normalize(PNPM_CJS));
    }

    @Override
    public File getCorepackPath() {
        return new File(this.installConfig.getInstallDirectory() + Utils.normalize(COREPACK));
    }

    @Override
    public File getNpxPath() {
        return new File(this.installConfig.getInstallDirectory() + Utils.normalize(NPX));
    }

    @Override
    public File getInstallDirectory() {
        return this.installConfig.getInstallDirectory();
    }

    @Override
    public File getWorkingDirectory() {
        return this.installConfig.getWorkingDirectory();
    }

    @Override
    public Platform getPlatform() {
        return this.installConfig.getPlatform();
    }
}

