/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.BowerRunner;
import com.github.eirslett.maven.plugins.frontend.lib.BunExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.BunInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.BunRunner;
import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.CorepackInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.CorepackRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultBowerRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultBunRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultCorepackRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultEmberRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultFileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultGruntRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultGulpRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultInstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultJspmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultKarmaRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultNpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultNpxRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultPnpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultWebpackRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultYarnRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DirectoryCacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.EmberRunner;
import com.github.eirslett.maven.plugins.frontend.lib.GlobalCache;
import com.github.eirslett.maven.plugins.frontend.lib.GruntRunner;
import com.github.eirslett.maven.plugins.frontend.lib.GulpRunner;
import com.github.eirslett.maven.plugins.frontend.lib.InstallBunExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallYarnExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.JspmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.KarmaRunner;
import com.github.eirslett.maven.plugins.frontend.lib.NPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NodeInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.NpxRunner;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.PnpmInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.PnpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.WebpackRunner;
import com.github.eirslett.maven.plugins.frontend.lib.YarnExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.YarnInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.YarnRunner;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.VersionManagerCache;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.VersionManagerLocator;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.VersionManagerRunner;
import com.github.eirslett.maven.plugins.frontend.lib.version.manager.VersionManagerType;
import java.io.File;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FrontendPluginFactory {
    private static final Logger logger = LoggerFactory.getLogger(FrontendPluginFactory.class);
    private static final Platform defaultPlatform = Platform.guess();
    private static final String DEFAULT_CACHE_PATH = "cache";
    private final File workingDirectory;
    private final File installDirectory;
    private final CacheResolver cacheResolver;
    private final boolean useNodeVersionManager;
    private String nodeVersion;

    public FrontendPluginFactory(File workingDirectory, File installDirectory) {
        this(workingDirectory, installDirectory, FrontendPluginFactory.getDefaultCacheResolver(installDirectory));
    }

    public FrontendPluginFactory(File workingDirectory, File installDirectory, CacheResolver cacheResolver) {
        this(workingDirectory, installDirectory, cacheResolver, false);
    }

    public FrontendPluginFactory(File workingDirectory, File installDirectory, CacheResolver cacheResolver, boolean useNodeVersionManager) {
        this.workingDirectory = workingDirectory;
        this.installDirectory = installDirectory;
        this.cacheResolver = cacheResolver;
        this.useNodeVersionManager = useNodeVersionManager;
        this.initializeGlobalCache();
    }

    public BunInstaller getBunInstaller(ProxyConfig proxy) {
        return new BunInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public NodeInstaller getNodeInstaller(ProxyConfig proxy) {
        return new NodeInstaller(this.getInstallConfig(), this.getVersionManagerCache(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public NPMInstaller getNPMInstaller(ProxyConfig proxy) {
        return new NPMInstaller(this.getInstallConfig(), this.getVersionManagerCache(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public CorepackInstaller getCorepackInstaller(ProxyConfig proxy) {
        return new CorepackInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public PnpmInstaller getPnpmInstaller(ProxyConfig proxy) {
        return new PnpmInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public YarnInstaller getYarnInstaller(ProxyConfig proxy) {
        return new YarnInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public BowerRunner getBowerRunner(ProxyConfig proxy) {
        return new DefaultBowerRunner(this.getExecutorConfig(), proxy);
    }

    public BunRunner getBunRunner(ProxyConfig proxy, String npmRegistryURL) {
        return new DefaultBunRunner((BunExecutorConfig)new InstallBunExecutorConfig(this.getInstallConfig()), proxy, npmRegistryURL);
    }

    public JspmRunner getJspmRunner() {
        return new DefaultJspmRunner(this.getExecutorConfig());
    }

    public NpmRunner getNpmRunner(ProxyConfig proxy, String npmRegistryURL) {
        return new DefaultNpmRunner(this.getExecutorConfig(), proxy, npmRegistryURL);
    }

    public CorepackRunner getCorepackRunner() {
        return new DefaultCorepackRunner(this.getExecutorConfig());
    }

    public PnpmRunner getPnpmRunner(ProxyConfig proxyConfig, String npmRegistryUrl) {
        return new DefaultPnpmRunner(this.getExecutorConfig(), proxyConfig, npmRegistryUrl);
    }

    public NpxRunner getNpxRunner(ProxyConfig proxy, String npmRegistryURL) {
        return new DefaultNpxRunner(this.getExecutorConfig(), proxy, npmRegistryURL);
    }

    public YarnRunner getYarnRunner(ProxyConfig proxy, String npmRegistryURL, boolean isYarnBerry) {
        return new DefaultYarnRunner((YarnExecutorConfig)new InstallYarnExecutorConfig(this.getInstallConfig(), isYarnBerry), proxy, npmRegistryURL);
    }

    public GruntRunner getGruntRunner() {
        return new DefaultGruntRunner(this.getExecutorConfig());
    }

    public EmberRunner getEmberRunner() {
        return new DefaultEmberRunner(this.getExecutorConfig());
    }

    public KarmaRunner getKarmaRunner() {
        return new DefaultKarmaRunner(this.getExecutorConfig());
    }

    public GulpRunner getGulpRunner() {
        return new DefaultGulpRunner(this.getExecutorConfig());
    }

    public WebpackRunner getWebpackRunner() {
        return new DefaultWebpackRunner(this.getExecutorConfig());
    }

    public VersionManagerRunner getVersionManagerRunner() {
        return new VersionManagerRunner(this.getInstallConfig(), this.getVersionManagerCache());
    }

    private NodeExecutorConfig getExecutorConfig() {
        return new InstallNodeExecutorConfig(this.getInstallConfig(), this.getVersionManagerCache());
    }

    private InstallConfig getInstallConfig() {
        return GlobalCache.getInstallConfig();
    }

    private VersionManagerCache getVersionManagerCache() {
        return GlobalCache.getVersionManagerCache();
    }

    private static CacheResolver getDefaultCacheResolver(File root) {
        return new DirectoryCacheResolver(new File(root, DEFAULT_CACHE_PATH));
    }

    private void initializeGlobalCache() {
        DefaultInstallConfig installConfig = new DefaultInstallConfig(this.installDirectory, this.workingDirectory, this.cacheResolver, defaultPlatform, this.useNodeVersionManager);
        GlobalCache.setInstallConfig(installConfig);
        if (installConfig.isUseNodeVersionManager()) {
            VersionManagerType versionManagerType = FrontendPluginFactory.getVersionManagerType(installConfig);
            GlobalCache.setVersionManagerCache(new VersionManagerCache(versionManagerType));
        } else {
            GlobalCache.setVersionManagerCache(new VersionManagerCache());
        }
    }

    private static VersionManagerType getVersionManagerType(InstallConfig installConfig) {
        VersionManagerLocator versionManagerLocator = new VersionManagerLocator(installConfig);
        VersionManagerType versionManagerType = versionManagerLocator.findAvailable();
        if (versionManagerType == null) {
            logger.warn("You have configured `useNodeVersionManager=true` but node version manager couldn't be identified. If you want to use node version manager, please install a supported manager " + Arrays.toString((Object[])VersionManagerType.values()) + " in your environment.");
        }
        return versionManagerType;
    }

    public void loadNodeVersionManager(String nodeVersion) {
        VersionManagerType versionManagerType;
        if (this.getInstallConfig().isUseNodeVersionManager() && (versionManagerType = FrontendPluginFactory.getVersionManagerType(this.getInstallConfig())) != null) {
            this.getVersionManagerRunner().populateCacheForVersion(nodeVersion);
        }
    }
}

