/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConfig.class);
    private final List<Proxy> proxies;

    public ProxyConfig(List<Proxy> proxies) {
        this.proxies = proxies;
    }

    public boolean isEmpty() {
        return this.proxies.isEmpty();
    }

    public Proxy getProxyForUrl(String requestUrl) {
        if (this.proxies.isEmpty()) {
            LOGGER.info("No proxies configured");
            return null;
        }
        URI uri = URI.create(requestUrl);
        for (Proxy proxy : this.proxies) {
            if (proxy.isNonProxyHost(uri.getHost())) continue;
            return proxy;
        }
        LOGGER.info("Could not find matching proxy for host: {}" + uri.getHost());
        return null;
    }

    public Proxy getSecureProxy() {
        for (Proxy proxy : this.proxies) {
            if (!proxy.isSecure()) continue;
            return proxy;
        }
        return null;
    }

    public Proxy getInsecureProxy() {
        for (Proxy proxy : this.proxies) {
            if (proxy.isSecure()) continue;
            return proxy;
        }
        return null;
    }

    static class ProxyConfigException
    extends RuntimeException {
        private ProxyConfigException(String message, Exception cause) {
            super(message, cause);
        }
    }

    public static class Proxy {
        public final String id;
        public final String protocol;
        public final String host;
        public final int port;
        public final String username;
        public final String password;
        public final String nonProxyHosts;

        public Proxy(String id, String protocol, String host, int port, String username, String password, String nonProxyHosts) {
            this.host = host;
            this.id = id;
            this.protocol = protocol;
            this.port = port;
            this.username = username;
            this.password = password;
            this.nonProxyHosts = nonProxyHosts;
        }

        public boolean useAuthentication() {
            return this.username != null && !this.username.isEmpty();
        }

        public URI getUri() {
            String authentication = this.useAuthentication() ? this.username + ":" + this.password : null;
            try {
                return new URI("http", authentication, this.host, this.port, null, null, null);
            }
            catch (URISyntaxException e) {
                throw new ProxyConfigException("Invalid proxy settings", e);
            }
        }

        public boolean isSecure() {
            return "https".equals(this.protocol);
        }

        public boolean isNonProxyHost(String host) {
            if (host != null && this.nonProxyHosts != null && this.nonProxyHosts.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(this.nonProxyHosts, "|");
                while (tokenizer.hasMoreTokens()) {
                    String pattern = tokenizer.nextToken();
                    if (!host.matches(pattern = pattern.replace(".", "\\.").replace("*", ".*"))) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.id + "{" + "protocol='" + this.protocol + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + (this.useAuthentication() ? ", with username/passport authentication" : "") + '}';
        }
    }
}

