/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NodeTaskExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.NpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.util.ArrayList;
import java.util.List;

final class DefaultNpmRunner
extends NodeTaskExecutor
implements NpmRunner {
    static final String TASK_NAME = "npm";

    public DefaultNpmRunner(NodeExecutorConfig config, ProxyConfig proxyConfig, String npmRegistryURL) {
        super(config, TASK_NAME, config.getNpmPath().getAbsolutePath(), DefaultNpmRunner.buildArguments(proxyConfig, npmRegistryURL));
    }

    private static List<String> buildArguments(ProxyConfig proxyConfig, String npmRegistryURL) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (npmRegistryURL != null) {
            arguments.add("--registry=" + npmRegistryURL);
        }
        if (!proxyConfig.isEmpty()) {
            ProxyConfig.Proxy insecureProxy;
            ProxyConfig.Proxy secureProxy = proxyConfig.getSecureProxy();
            if (secureProxy != null) {
                arguments.add("--https-proxy=" + secureProxy.getUri().toString());
            }
            if ((insecureProxy = proxyConfig.getInsecureProxy()) != null) {
                arguments.add("--proxy=" + insecureProxy.getUri().toString());
            }
        }
        return arguments;
    }
}

