/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NodeAndNPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultNodeAndNPMInstaller
implements NodeAndNPMInstaller {
    private static final String INSTALL_PATH = "node";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    DefaultNodeAndNPMInstaller(InstallConfig config, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    @Override
    public void install(String nodeVersion, String npmVersion, String nodeDownloadRoot, String npmDownloadRoot) throws InstallationException {
        if (nodeDownloadRoot == null || nodeDownloadRoot.isEmpty()) {
            nodeDownloadRoot = "https://nodejs.org/dist/";
        }
        if (npmDownloadRoot == null || npmDownloadRoot.isEmpty()) {
            npmDownloadRoot = "http://registry.npmjs.org/npm/-/";
        }
        new NodeAndNPMInstallAction(nodeVersion, npmVersion, nodeDownloadRoot, npmDownloadRoot).install();
    }

    private final class NodeAndNPMInstallAction {
        private static final String VERSION = "version";
        private final String nodeVersion;
        private final String npmVersion;
        private final String nodeDownloadRoot;
        private final String npmDownloadRoot;

        public NodeAndNPMInstallAction(String nodeVersion, String npmVersion, String nodeDownloadRoot, String npmDownloadRoot) {
            this.nodeVersion = nodeVersion;
            this.npmVersion = npmVersion;
            this.nodeDownloadRoot = nodeDownloadRoot;
            this.npmDownloadRoot = npmDownloadRoot;
        }

        public void install() throws InstallationException {
            if (!this.nodeIsAlreadyInstalled()) {
                DefaultNodeAndNPMInstaller.this.logger.info("Installing node version {}", (Object)this.nodeVersion);
                if (!this.nodeVersion.startsWith("v")) {
                    DefaultNodeAndNPMInstaller.this.logger.warn("Node version does not start with naming convention 'v'.");
                }
                if (DefaultNodeAndNPMInstaller.this.config.getPlatform().isWindows()) {
                    this.installNodeForWindows();
                } else {
                    this.installNodeDefault();
                }
            }
            if (!this.npmIsAlreadyInstalled()) {
                this.installNpm();
            }
        }

        private boolean nodeIsAlreadyInstalled() {
            try {
                InstallNodeExecutorConfig executorConfig = new InstallNodeExecutorConfig(DefaultNodeAndNPMInstaller.this.config);
                File nodeFile = executorConfig.getNodePath();
                if (nodeFile.exists()) {
                    String version = new NodeExecutor(executorConfig, Arrays.asList("--version"), null).executeAndGetResult();
                    if (version.equals(this.nodeVersion)) {
                        DefaultNodeAndNPMInstaller.this.logger.info("Node {} is already installed.", (Object)version);
                        return true;
                    }
                    DefaultNodeAndNPMInstaller.this.logger.info("Node {} was installed, but we need version {}", (Object)version, (Object)this.nodeVersion);
                    return false;
                }
                return false;
            }
            catch (ProcessExecutionException e) {
                return false;
            }
        }

        private boolean npmIsAlreadyInstalled() {
            try {
                File npmPackageJson = new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + Utils.normalize("/node/node_modules/npm/package.json"));
                if (npmPackageJson.exists()) {
                    HashMap data = (HashMap)new ObjectMapper().readValue(npmPackageJson, HashMap.class);
                    if (data.containsKey(VERSION)) {
                        String foundNpmVersion = data.get(VERSION).toString();
                        if (foundNpmVersion.equals(this.npmVersion)) {
                            DefaultNodeAndNPMInstaller.this.logger.info("NPM {} is already installed.", (Object)foundNpmVersion);
                            return true;
                        }
                        DefaultNodeAndNPMInstaller.this.logger.info("NPM {} was installed, but we need version {}", (Object)foundNpmVersion, (Object)this.npmVersion);
                        return false;
                    }
                    DefaultNodeAndNPMInstaller.this.logger.info("Could not read NPM version from package.json");
                    return false;
                }
                return false;
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not read package.json", ex);
            }
        }

        private void installNpm() throws InstallationException {
            try {
                DefaultNodeAndNPMInstaller.this.logger.info("Installing npm version {}", (Object)this.npmVersion);
                String downloadUrl = this.npmDownloadRoot + "npm-" + this.npmVersion + ".tgz";
                CacheDescriptor cacheDescriptor = new CacheDescriptor("npm", this.npmVersion, "tar.gz");
                File archive = DefaultNodeAndNPMInstaller.this.config.getCacheResolver().resolve(cacheDescriptor);
                this.downloadFileIfMissing(downloadUrl, archive);
                File installDirectory = this.getInstallDirectory();
                File nodeModulesDirectory = new File(installDirectory, "node_modules");
                File oldNpmDirectory = new File(installDirectory, "npm");
                File npmDirectory = new File(nodeModulesDirectory, "npm");
                try {
                    if (oldNpmDirectory.isDirectory()) {
                        FileUtils.deleteDirectory((File)oldNpmDirectory);
                    }
                    FileUtils.deleteDirectory((File)npmDirectory);
                }
                catch (IOException e) {
                    DefaultNodeAndNPMInstaller.this.logger.warn("Failed to delete existing NPM installation.");
                }
                this.extractFile(archive, nodeModulesDirectory);
                File packageDirectory = new File(nodeModulesDirectory, "package");
                if (packageDirectory.exists() && !npmDirectory.exists() && !packageDirectory.renameTo(npmDirectory)) {
                    DefaultNodeAndNPMInstaller.this.logger.warn("Cannot rename NPM directory, making a copy.");
                    FileUtils.copyDirectory((File)packageDirectory, (File)npmDirectory);
                }
                for (String script : Arrays.asList("npm", "npm.cmd")) {
                    File scriptFile = new File(npmDirectory, "bin" + File.separator + script);
                    if (!scriptFile.exists()) continue;
                    File copy = new File(installDirectory, script);
                    FileUtils.copyFile((File)scriptFile, (File)copy);
                    copy.setExecutable(true);
                }
                DefaultNodeAndNPMInstaller.this.logger.info("Installed npm locally.");
            }
            catch (DownloadException e) {
                throw new InstallationException("Could not download npm", e);
            }
            catch (ArchiveExtractionException e) {
                throw new InstallationException("Could not extract the npm archive", e);
            }
            catch (IOException e) {
                throw new InstallationException("Could not copy npm", e);
            }
        }

        private void installNodeDefault() throws InstallationException {
            try {
                String longNodeFilename = DefaultNodeAndNPMInstaller.this.config.getPlatform().getLongNodeFilename(this.nodeVersion);
                String downloadUrl = this.nodeDownloadRoot + DefaultNodeAndNPMInstaller.this.config.getPlatform().getNodeDownloadFilename(this.nodeVersion);
                String classifier = DefaultNodeAndNPMInstaller.this.config.getPlatform().getNodeClassifier();
                File tmpDirectory = this.getTempDirectory();
                CacheDescriptor cacheDescriptor = new CacheDescriptor(DefaultNodeAndNPMInstaller.INSTALL_PATH, this.nodeVersion, classifier, "tar.gz");
                File archive = DefaultNodeAndNPMInstaller.this.config.getCacheResolver().resolve(cacheDescriptor);
                this.downloadFileIfMissing(downloadUrl, archive);
                this.extractFile(archive, tmpDirectory);
                File nodeBinary = new File(tmpDirectory, longNodeFilename + File.separator + "bin" + File.separator + DefaultNodeAndNPMInstaller.INSTALL_PATH);
                if (!nodeBinary.exists()) {
                    throw new FileNotFoundException("Could not find the downloaded Node.js binary in " + nodeBinary);
                }
                File destinationDirectory = this.getInstallDirectory();
                File destination = new File(destinationDirectory, DefaultNodeAndNPMInstaller.INSTALL_PATH);
                DefaultNodeAndNPMInstaller.this.logger.info("Copying node binary from {} to {}", (Object)nodeBinary, (Object)destination);
                if (!nodeBinary.renameTo(destination)) {
                    throw new InstallationException("Could not install Node: Was not allowed to rename " + nodeBinary + " to " + destination);
                }
                if (!destination.setExecutable(true, false)) {
                    throw new InstallationException("Could not install Node: Was not allowed to make " + destination + " executable.");
                }
                this.deleteTempDirectory(tmpDirectory);
                DefaultNodeAndNPMInstaller.this.logger.info("Installed node locally.");
            }
            catch (IOException e) {
                throw new InstallationException("Could not install Node", e);
            }
            catch (DownloadException e) {
                throw new InstallationException("Could not download Node.js", e);
            }
            catch (ArchiveExtractionException e) {
                throw new InstallationException("Could not extract the Node archive", e);
            }
        }

        private void installNodeForWindows() throws InstallationException {
            String downloadUrl = this.nodeDownloadRoot + DefaultNodeAndNPMInstaller.this.config.getPlatform().getNodeDownloadFilename(this.nodeVersion);
            try {
                File destinationDirectory = this.getInstallDirectory();
                File destination = new File(destinationDirectory, "node.exe");
                String classifier = DefaultNodeAndNPMInstaller.this.config.getPlatform().getNodeClassifier();
                CacheDescriptor cacheDescriptor = new CacheDescriptor(DefaultNodeAndNPMInstaller.INSTALL_PATH, this.nodeVersion, classifier, "exe");
                File binary = DefaultNodeAndNPMInstaller.this.config.getCacheResolver().resolve(cacheDescriptor);
                this.downloadFileIfMissing(downloadUrl, binary);
                DefaultNodeAndNPMInstaller.this.logger.info("Copying node binary from {} to {}", (Object)binary, (Object)destination);
                FileUtils.copyFile((File)binary, (File)destination);
                DefaultNodeAndNPMInstaller.this.logger.info("Installed node locally.");
            }
            catch (DownloadException e) {
                throw new InstallationException("Could not download Node.js from: " + downloadUrl, e);
            }
            catch (IOException e) {
                throw new InstallationException("Could not install Node.js", e);
            }
        }

        private File getTempDirectory() {
            File tmpDirectory = new File(this.getInstallDirectory(), "tmp");
            if (!tmpDirectory.exists()) {
                DefaultNodeAndNPMInstaller.this.logger.debug("Creating temporary directory {}", (Object)tmpDirectory);
                tmpDirectory.mkdirs();
            }
            return tmpDirectory;
        }

        private File getInstallDirectory() {
            File installDirectory = new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory(), DefaultNodeAndNPMInstaller.INSTALL_PATH);
            if (!installDirectory.exists()) {
                DefaultNodeAndNPMInstaller.this.logger.debug("Creating install directory {}", (Object)installDirectory);
                installDirectory.mkdirs();
            }
            return installDirectory;
        }

        private void deleteTempDirectory(File tmpDirectory) throws IOException {
            if (tmpDirectory != null && tmpDirectory.exists()) {
                DefaultNodeAndNPMInstaller.this.logger.debug("Deleting temporary directory {}", (Object)tmpDirectory);
                FileUtils.deleteDirectory((File)tmpDirectory);
            }
        }

        private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
            DefaultNodeAndNPMInstaller.this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
            DefaultNodeAndNPMInstaller.this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
        }

        private void downloadFileIfMissing(String downloadUrl, File destination) throws DownloadException {
            if (!destination.exists()) {
                this.downloadFile(downloadUrl, destination);
            }
        }

        private void downloadFile(String downloadUrl, File destination) throws DownloadException {
            DefaultNodeAndNPMInstaller.this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
            DefaultNodeAndNPMInstaller.this.fileDownloader.download(downloadUrl, destination.getPath());
        }
    }
}

