/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.BowerRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultBowerRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultEmberRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultFileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultGruntRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultGulpRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultInstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultJspmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultKarmaRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultNodeAndNPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultNpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultWebpackRunner;
import com.github.eirslett.maven.plugins.frontend.lib.EmberRunner;
import com.github.eirslett.maven.plugins.frontend.lib.GruntRunner;
import com.github.eirslett.maven.plugins.frontend.lib.GulpRunner;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.JspmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.KarmaRunner;
import com.github.eirslett.maven.plugins.frontend.lib.NodeAndNPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.WebpackRunner;
import java.io.File;

public final class FrontendPluginFactory {
    private static final Platform defaultPlatform = Platform.guess();
    private final File workingDirectory;
    private final File installDirectory;

    public FrontendPluginFactory(File workingDirectory, File installDirectory) {
        this.workingDirectory = workingDirectory;
        this.installDirectory = installDirectory;
    }

    public NodeAndNPMInstaller getNodeAndNPMInstaller(ProxyConfig proxy) {
        return new DefaultNodeAndNPMInstaller(this.getInstallConfig(), new DefaultArchiveExtractor(), new DefaultFileDownloader(proxy));
    }

    public BowerRunner getBowerRunner(ProxyConfig proxy) {
        return new DefaultBowerRunner(this.getExecutorConfig(), proxy);
    }

    public JspmRunner getJspmRunner() {
        return new DefaultJspmRunner(this.getExecutorConfig());
    }

    public NpmRunner getNpmRunner(ProxyConfig proxy, String npmRegistryURL) {
        return new DefaultNpmRunner(this.getExecutorConfig(), proxy, npmRegistryURL);
    }

    public GruntRunner getGruntRunner() {
        return new DefaultGruntRunner(this.getExecutorConfig());
    }

    public EmberRunner getEmberRunner() {
        return new DefaultEmberRunner(this.getExecutorConfig());
    }

    public KarmaRunner getKarmaRunner() {
        return new DefaultKarmaRunner(this.getExecutorConfig());
    }

    public GulpRunner getGulpRunner() {
        return new DefaultGulpRunner(this.getExecutorConfig());
    }

    public WebpackRunner getWebpackRunner() {
        return new DefaultWebpackRunner(this.getExecutorConfig());
    }

    private NodeExecutorConfig getExecutorConfig() {
        return new InstallNodeExecutorConfig(this.getInstallConfig());
    }

    private InstallConfig getInstallConfig() {
        return new DefaultInstallConfig(this.installDirectory, this.workingDirectory, defaultPlatform);
    }
}

