/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.BowerRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultBowerRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultFileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultGruntRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultGulpRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultKarmaRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultNodeAndNPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultNpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.GruntRunner;
import com.github.eirslett.maven.plugins.frontend.lib.GulpRunner;
import com.github.eirslett.maven.plugins.frontend.lib.KarmaRunner;
import com.github.eirslett.maven.plugins.frontend.lib.NodeAndNPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.io.File;

public final class FrontendPluginFactory {
    private static final Platform defaultPlatform = Platform.guess();
    private final File workingDirectory;
    private final ProxyConfig proxy;

    public FrontendPluginFactory(File workingDirectory) {
        this(workingDirectory, null);
    }

    public FrontendPluginFactory(File workingDirectory, ProxyConfig proxy) {
        this.workingDirectory = workingDirectory;
        this.proxy = proxy;
    }

    public NodeAndNPMInstaller getNodeAndNPMInstaller() {
        return new DefaultNodeAndNPMInstaller(this.workingDirectory, defaultPlatform, new DefaultArchiveExtractor(), new DefaultFileDownloader(this.proxy));
    }

    public BowerRunner getBowerRunner() {
        return new DefaultBowerRunner(defaultPlatform, this.workingDirectory);
    }

    public NpmRunner getNpmRunner() {
        return new DefaultNpmRunner(defaultPlatform, this.workingDirectory, this.proxy);
    }

    public GruntRunner getGruntRunner() {
        return new DefaultGruntRunner(defaultPlatform, this.workingDirectory);
    }

    public KarmaRunner getKarmaRunner() {
        return new DefaultKarmaRunner(defaultPlatform, this.workingDirectory);
    }

    public GulpRunner getGulpRunner() {
        return new DefaultGulpRunner(defaultPlatform, this.workingDirectory);
    }
}

