/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import java.util.Collections;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="npm", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public final class NpmMojo
extends AbstractFrontendMojo {
    private static final String NPM_REGISTRY_URL = "npmRegistryURL";
    @Parameter(defaultValue="install", property="frontend.npm.arguments", required=false)
    private String arguments;
    @Parameter(property="frontend.npm.npmInheritsProxyConfigFromMaven", required=false, defaultValue="true")
    private boolean npmInheritsProxyConfigFromMaven;
    @Parameter(property="npmRegistryURL", required=false, defaultValue="")
    private String npmRegistryURL;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildContext buildContext;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Parameter(property="skip.npm", defaultValue="${skip.npm}")
    private boolean skip;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public void execute(FrontendPluginFactory factory) throws TaskRunnerException {
        File packageJson = new File(this.workingDirectory, "package.json");
        if (this.buildContext == null || this.buildContext.hasDelta(packageJson) || !this.buildContext.isIncremental()) {
            ProxyConfig proxyConfig = this.getProxyConfig();
            factory.getNpmRunner(proxyConfig, this.getRegistryUrl()).execute(this.arguments, this.environmentVariables);
        } else {
            this.getLog().info((CharSequence)"Skipping npm install as package.json unchanged");
        }
    }

    private ProxyConfig getProxyConfig() {
        if (this.npmInheritsProxyConfigFromMaven) {
            return MojoUtils.getProxyConfig(this.session, this.decrypter);
        }
        this.getLog().info((CharSequence)"npm not inheriting proxy config from Maven");
        return new ProxyConfig(Collections.emptyList());
    }

    private String getRegistryUrl() {
        return System.getProperty(NPM_REGISTRY_URL, this.npmRegistryURL);
    }
}

