/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsReporter;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.NodeVersionDetector;
import com.github.eirslett.maven.plugins.frontend.lib.NodeVersionHelper;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import java.io.File;
import java.util.Objects;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="karma", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public final class KarmaRunMojo
extends AbstractFrontendMojo {
    @Parameter(defaultValue="karma.conf.js", property="karmaConfPath")
    private String karmaConfPath;
    @Parameter(property="nodeVersion", defaultValue="", required=false)
    private String nodeVersion;
    @Parameter(property="nodeVersionFile", defaultValue="", required=false)
    private String nodeVersionFile;
    @Parameter(property="skip.karma", defaultValue="${skip.karma}")
    private boolean skip;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public synchronized void execute(FrontendPluginFactory factory) throws Exception {
        AtlassianDevMetricsReporter.incrementExecutionCount((String)this.project.getArtifactId(), (String)this.karmaConfPath, (AtlassianDevMetricsReporter.Goal)AtlassianDevMetricsReporter.Goal.KARMA, (String)this.getFrontendMavenPluginVersion(), (boolean)false, (boolean)false, () -> {
            String nodeVersion = NodeVersionDetector.getNodeVersion((File)this.workingDirectory, (String)this.nodeVersion, (String)this.nodeVersionFile, (String)this.project.getArtifactId(), (String)this.getFrontendMavenPluginVersion());
            if (Objects.isNull(nodeVersion)) {
                throw new LifecycleExecutionException("Node version could not be detected from a file and was not set");
            }
            if (!NodeVersionHelper.validateVersion((String)nodeVersion)) {
                throw new LifecycleExecutionException("Node version (" + nodeVersion + ") is not valid. If you think it actually is, raise an issue");
            }
            String validNodeVersion = NodeVersionHelper.getDownloadableVersion((String)nodeVersion);
            factory.loadNodeVersionManager(validNodeVersion);
            factory.getKarmaRunner().execute("start " + this.karmaConfPath, this.environmentVariables);
        });
    }
}

