/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.generator;

import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.jfinal.template.Engine;
import com.jfinal.template.source.ClassPathSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ModelGenerator {
    protected String template = "/com/jfinal/plugin/activerecord/generator/model_template.jf";
    protected String modelPackageName;
    protected String baseModelPackageName;
    protected String modelOutputDir;
    protected boolean generateDaoInModel = false;

    public ModelGenerator(String modelPackageName, String baseModelPackageName, String modelOutputDir) {
        if (StrKit.isBlank((String)modelPackageName)) {
            throw new IllegalArgumentException("modelPackageName can not be blank.");
        }
        if (modelPackageName.contains("/") || modelPackageName.contains("\\")) {
            throw new IllegalArgumentException("modelPackageName error : " + modelPackageName);
        }
        if (StrKit.isBlank((String)baseModelPackageName)) {
            throw new IllegalArgumentException("baseModelPackageName can not be blank.");
        }
        if (baseModelPackageName.contains("/") || baseModelPackageName.contains("\\")) {
            throw new IllegalArgumentException("baseModelPackageName error : " + baseModelPackageName);
        }
        if (StrKit.isBlank((String)modelOutputDir)) {
            throw new IllegalArgumentException("modelOutputDir can not be blank.");
        }
        this.modelPackageName = modelPackageName;
        this.baseModelPackageName = baseModelPackageName;
        this.modelOutputDir = modelOutputDir;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setGenerateDaoInModel(boolean generateDaoInModel) {
        this.generateDaoInModel = generateDaoInModel;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate model ...");
        System.out.println("Model Output Dir: " + this.modelOutputDir);
        Engine engine = Engine.create((String)"forModel");
        engine.setSourceFactory((ISourceFactory)new ClassPathSourceFactory());
        engine.addSharedMethod((Object)new StrKit());
        for (TableMeta tableMeta : tableMetas) {
            this.genModelContent(tableMeta);
        }
        this.writeToFile(tableMetas);
    }

    protected void genModelContent(TableMeta tableMeta) {
        String ret;
        Kv data = Kv.by((Object)"modelPackageName", (Object)this.modelPackageName);
        data.set((Object)"baseModelPackageName", (Object)this.baseModelPackageName);
        data.set((Object)"generateDaoInModel", (Object)this.generateDaoInModel);
        data.set((Object)"tableMeta", (Object)tableMeta);
        tableMeta.modelContent = ret = Engine.use((String)"forModel").getTemplate(this.template).renderToString((Map)data);
    }

    protected void writeToFile(List<TableMeta> tableMetas) {
        try {
            for (TableMeta tableMeta : tableMetas) {
                this.writeToFile(tableMeta);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToFile(TableMeta tableMeta) throws IOException {
        String target;
        File file;
        File dir = new File(this.modelOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((file = new File(target = this.modelOutputDir + File.separator + tableMeta.modelName + ".java")).exists()) {
            return;
        }
        FileWriter fw = new FileWriter(file);
        try {
            fw.write(tableMeta.modelContent);
        }
        finally {
            fw.close();
        }
    }
}

