/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.IContainerFactory;
import com.jfinal.plugin.activerecord.IDbProFactory;
import com.jfinal.plugin.activerecord.SqlReporter;
import com.jfinal.plugin.activerecord.cache.EhCache;
import com.jfinal.plugin.activerecord.cache.ICache;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.MysqlDialect;
import com.jfinal.plugin.activerecord.sql.SqlKit;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class Config {
    private final ThreadLocal<Connection> threadLocal = new ThreadLocal();
    String name;
    DataSource dataSource;
    Dialect dialect;
    boolean showSql;
    boolean devMode;
    int transactionLevel;
    IContainerFactory containerFactory;
    IDbProFactory dbProFactory = IDbProFactory.defaultDbProFactory;
    ICache cache;
    SqlKit sqlKit;

    Config(String name, DataSource dataSource, int transactionLevel) {
        this.init(name, dataSource, new MysqlDialect(), false, false, transactionLevel, IContainerFactory.defaultContainerFactory, new EhCache());
    }

    public Config(String name, DataSource dataSource, Dialect dialect, boolean showSql, boolean devMode, int transactionLevel, IContainerFactory containerFactory, ICache cache) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource can not be null");
        }
        this.init(name, dataSource, dialect, showSql, devMode, transactionLevel, containerFactory, cache);
    }

    private void init(String name, DataSource dataSource, Dialect dialect, boolean showSql, boolean devMode, int transactionLevel, IContainerFactory containerFactory, ICache cache) {
        if (StrKit.isBlank((String)name)) {
            throw new IllegalArgumentException("Config name can not be blank");
        }
        if (dialect == null) {
            throw new IllegalArgumentException("Dialect can not be null");
        }
        if (containerFactory == null) {
            throw new IllegalArgumentException("ContainerFactory can not be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("Cache can not be null");
        }
        this.name = name.trim();
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.showSql = showSql;
        this.devMode = devMode;
        this.setTransactionLevel(transactionLevel);
        this.containerFactory = containerFactory;
        this.cache = cache;
        this.sqlKit = new SqlKit(this.name, this.devMode);
    }

    public Config(String name, DataSource dataSource) {
        this(name, dataSource, new MysqlDialect());
    }

    public Config(String name, DataSource dataSource, Dialect dialect) {
        this(name, dataSource, dialect, false, false, 4, IContainerFactory.defaultContainerFactory, new EhCache());
    }

    private Config() {
    }

    void setDevMode(boolean devMode) {
        this.devMode = devMode;
        this.sqlKit.setDevMode(devMode);
    }

    void setTransactionLevel(int transactionLevel) {
        int t = transactionLevel;
        if (t != 0 && t != 1 && t != 2 && t != 4 && t != 8) {
            throw new IllegalArgumentException("The transactionLevel only be 0, 1, 2, 4, 8");
        }
        this.transactionLevel = transactionLevel;
    }

    static Config createBrokenConfig() {
        Config ret = new Config();
        ret.dialect = new MysqlDialect();
        ret.showSql = false;
        ret.devMode = false;
        ret.transactionLevel = 4;
        ret.containerFactory = IContainerFactory.defaultContainerFactory;
        ret.cache = new EhCache();
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public SqlKit getSqlKit() {
        return this.sqlKit;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public ICache getCache() {
        return this.cache;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public IContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public IDbProFactory getDbProFactory() {
        return this.dbProFactory;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public final void setThreadLocalConnection(Connection connection) {
        this.threadLocal.set(connection);
    }

    public final void removeThreadLocalConnection() {
        this.threadLocal.remove();
    }

    public final Connection getConnection() throws SQLException {
        Connection conn = this.threadLocal.get();
        if (conn != null) {
            return conn;
        }
        return this.showSql ? new SqlReporter(this.dataSource.getConnection()).getConnection() : this.dataSource.getConnection();
    }

    public final Connection getThreadLocalConnection() {
        return this.threadLocal.get();
    }

    public final boolean isInTransaction() {
        return this.threadLocal.get() != null;
    }

    public final void close(ResultSet rs, Statement st, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    public final void close(Statement st, Connection conn) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    public final void close(Connection conn) {
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }
}

