/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.IContainerFactory;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.IDbProFactory;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.NullDataSource;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableBuilder;
import com.jfinal.plugin.activerecord.cache.EhCache;
import com.jfinal.plugin.activerecord.cache.ICache;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.MysqlDialect;
import com.jfinal.plugin.activerecord.sql.SqlKit;
import com.jfinal.template.Engine;
import com.jfinal.template.source.ISource;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class ActiveRecordPlugin {
    private IDataSourceProvider dataSourceProvider = null;
    private Boolean devMode = null;
    private Config config = null;
    private volatile boolean isStarted = false;
    private List<Table> tableList = new ArrayList<Table>();

    public ActiveRecordPlugin(String configName, DataSource dataSource, int transactionLevel) {
        if (StrKit.isBlank((String)configName)) {
            throw new IllegalArgumentException("configName can not be blank");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null");
        }
        this.config = new Config(configName, dataSource, transactionLevel);
    }

    public ActiveRecordPlugin(DataSource dataSource) {
        this("main", dataSource);
    }

    public ActiveRecordPlugin(String configName, DataSource dataSource) {
        this(configName, dataSource, 4);
    }

    public ActiveRecordPlugin(DataSource dataSource, int transactionLevel) {
        this("main", dataSource, transactionLevel);
    }

    public ActiveRecordPlugin(String configName, IDataSourceProvider dataSourceProvider, int transactionLevel) {
        if (StrKit.isBlank((String)configName)) {
            throw new IllegalArgumentException("configName can not be blank");
        }
        if (dataSourceProvider == null) {
            throw new IllegalArgumentException("dataSourceProvider can not be null");
        }
        this.dataSourceProvider = dataSourceProvider;
        this.config = new Config(configName, null, transactionLevel);
    }

    public ActiveRecordPlugin(IDataSourceProvider dataSourceProvider) {
        this("main", dataSourceProvider);
    }

    public ActiveRecordPlugin(String configName, IDataSourceProvider dataSourceProvider) {
        this(configName, dataSourceProvider, 4);
    }

    public ActiveRecordPlugin(IDataSourceProvider dataSourceProvider, int transactionLevel) {
        this("main", dataSourceProvider, transactionLevel);
    }

    public ActiveRecordPlugin(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Config can not be null");
        }
        this.config = config;
    }

    public ActiveRecordPlugin addMapping(String tableName, String primaryKey, Class<? extends Model<?>> modelClass) {
        this.tableList.add(new Table(tableName, primaryKey, modelClass));
        return this;
    }

    public ActiveRecordPlugin addMapping(String tableName, Class<? extends Model<?>> modelClass) {
        this.tableList.add(new Table(tableName, modelClass));
        return this;
    }

    public ActiveRecordPlugin addSqlTemplate(String sqlTemplate) {
        this.config.sqlKit.addSqlTemplate(sqlTemplate);
        return this;
    }

    public ActiveRecordPlugin addSqlTemplate(ISource sqlTemplate) {
        this.config.sqlKit.addSqlTemplate(sqlTemplate);
        return this;
    }

    public ActiveRecordPlugin setBaseSqlTemplatePath(String baseSqlTemplatePath) {
        this.config.sqlKit.setBaseSqlTemplatePath(baseSqlTemplatePath);
        return this;
    }

    public SqlKit getSqlKit() {
        return this.config.sqlKit;
    }

    public Engine getEngine() {
        return this.getSqlKit().getEngine();
    }

    public ActiveRecordPlugin setTransactionLevel(int transactionLevel) {
        this.config.setTransactionLevel(transactionLevel);
        return this;
    }

    public ActiveRecordPlugin setCache(ICache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache can not be null");
        }
        this.config.cache = cache;
        return this;
    }

    public ActiveRecordPlugin setShowSql(boolean showSql) {
        this.config.showSql = showSql;
        return this;
    }

    public ActiveRecordPlugin setDevMode(boolean devMode) {
        this.devMode = devMode;
        this.config.setDevMode(devMode);
        return this;
    }

    public Boolean getDevMode() {
        return this.devMode;
    }

    public ActiveRecordPlugin setDialect(Dialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect can not be null");
        }
        this.config.dialect = dialect;
        if (this.config.transactionLevel == 4 && dialect.isOracle()) {
            this.config.transactionLevel = 2;
        }
        return this;
    }

    public ActiveRecordPlugin setContainerFactory(IContainerFactory containerFactory) {
        if (containerFactory == null) {
            throw new IllegalArgumentException("containerFactory can not be null");
        }
        this.config.containerFactory = containerFactory;
        return this;
    }

    public ActiveRecordPlugin setDbProFactory(IDbProFactory dbProFactory) {
        if (dbProFactory == null) {
            throw new IllegalArgumentException("dbProFactory can not be null");
        }
        this.config.dbProFactory = dbProFactory;
        return this;
    }

    public void setPrimaryKey(String tableName, String primaryKey) {
        for (Table table : this.tableList) {
            if (!table.getName().equalsIgnoreCase(tableName.trim())) continue;
            table.setPrimaryKey(primaryKey);
        }
    }

    public boolean start() {
        if (this.isStarted) {
            return true;
        }
        if (this.config.dataSource == null && this.dataSourceProvider != null) {
            this.config.dataSource = this.dataSourceProvider.getDataSource();
        }
        if (this.config.dataSource == null) {
            throw new RuntimeException("ActiveRecord start error: ActiveRecordPlugin need DataSource or DataSourceProvider");
        }
        this.config.sqlKit.parseSqlTemplate();
        new TableBuilder().build(this.tableList, this.config);
        DbKit.addConfig(this.config);
        this.isStarted = true;
        return true;
    }

    public boolean stop() {
        DbKit.removeConfig(this.config.getName());
        this.isStarted = false;
        return true;
    }

    public static void useAsDataTransfer(Dialect dialect, IContainerFactory containerFactory, ICache cache) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect can not be null");
        }
        if (containerFactory == null) {
            throw new IllegalArgumentException("containerFactory can not be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("cache can not be null");
        }
        ActiveRecordPlugin arp = new ActiveRecordPlugin(new NullDataSource());
        arp.setDialect(dialect);
        arp.setContainerFactory(containerFactory);
        arp.setCache(cache);
        arp.start();
        DbKit.brokenConfig = arp.config;
    }

    public static void useAsDataTransfer(IContainerFactory containerFactory) {
        ActiveRecordPlugin.useAsDataTransfer(new MysqlDialect(), containerFactory, new EhCache());
    }

    public static void useAsDataTransfer(Dialect dialect, IContainerFactory containerFactory) {
        ActiveRecordPlugin.useAsDataTransfer(dialect, containerFactory, new EhCache());
    }

    public static void useAsDataTransfer(Dialect dialect) {
        ActiveRecordPlugin.useAsDataTransfer(dialect, IContainerFactory.defaultContainerFactory, new EhCache());
    }

    public static void useAsDataTransfer() {
        ActiveRecordPlugin.useAsDataTransfer(new MysqlDialect(), IContainerFactory.defaultContainerFactory, new EhCache());
    }

    public Config getConfig() {
        return this.config;
    }
}

