/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.parser;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.Activity;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.composition.Instruction;
import com.nedap.archie.rm.composition.IsmTransition;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlTokenSource;
import org.ehrbase.aql.dto.path.AqlPath;
import org.ehrbase.terminology.client.terminology.TermDefinition;
import org.ehrbase.terminology.client.terminology.TerminologyProvider;
import org.ehrbase.terminology.client.terminology.ValueSet;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.model.WebTemplateAnnotation;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.model.WebTemplateValidation;
import org.ehrbase.webtemplate.model.WebtemplateCardinality;
import org.ehrbase.webtemplate.parser.InputHandler;
import org.ehrbase.webtemplate.util.WebTemplateUtils;
import org.openehr.schemas.v1.ANNOTATION;
import org.openehr.schemas.v1.ARCHETYPEONTOLOGY;
import org.openehr.schemas.v1.ARCHETYPESLOT;
import org.openehr.schemas.v1.ARCHETYPETERM;
import org.openehr.schemas.v1.CARCHETYPEROOT;
import org.openehr.schemas.v1.CARDINALITY;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCODEPHRASE;
import org.openehr.schemas.v1.CCODEREFERENCE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CDOMAINTYPE;
import org.openehr.schemas.v1.CDVORDINAL;
import org.openehr.schemas.v1.CDVQUANTITY;
import org.openehr.schemas.v1.CDVSTATE;
import org.openehr.schemas.v1.CMULTIPLEATTRIBUTE;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CODEPHRASE;
import org.openehr.schemas.v1.CPRIMITIVEOBJECT;
import org.openehr.schemas.v1.CSINGLEATTRIBUTE;
import org.openehr.schemas.v1.CodeDefinitionSet;
import org.openehr.schemas.v1.DVCODEDTEXT;
import org.openehr.schemas.v1.DVORDINAL;
import org.openehr.schemas.v1.DVQUANTITY;
import org.openehr.schemas.v1.Interval;
import org.openehr.schemas.v1.IntervalOfInteger;
import org.openehr.schemas.v1.OBJECTID;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.RESOURCEDESCRIPTIONITEM;
import org.openehr.schemas.v1.StringDictionaryItem;
import org.openehr.schemas.v1.TATTRIBUTE;
import org.openehr.schemas.v1.TCOMPLEXOBJECT;
import org.openehr.schemas.v1.TCONSTRAINT;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OPTParser {
    public static final String PATH_DIVIDER = "/";
    public static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    public static final String CAREFLOW_STEP = "careflow_step";
    public static final String DV_CODED_TEXT = "DV_CODED_TEXT";
    public static final String CODED_TEXT = "CODED_TEXT";
    public static final String OPENEHR = "openehr";
    public static final String CURRENT_STATE = "current_state";
    private final OPERATIONALTEMPLATE operationaltemplate;
    private final String defaultLanguage;
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private final InputHandler inputHandler = new InputHandler(this.defaultValues);
    private final Map<String, Map<String, String>> annotationMap = new HashMap<String, Map<String, String>>();
    private List<String> languages;
    private final Map<String, String> choiceIdCache = new HashMap<String, String>();

    private boolean updateChoiceId(WebTemplateNode node) {
        String rmType = node.getRmType();
        if (rmType.startsWith("DV_")) {
            node.setId(this.choiceIdCache.computeIfAbsent(rmType, t -> t.substring(3).toLowerCase() + "_value"));
            return true;
        }
        return false;
    }

    public OPTParser(OPERATIONALTEMPLATE operationaltemplate) {
        this.operationaltemplate = operationaltemplate;
        this.defaultLanguage = operationaltemplate.getLanguage().getCodeString();
        Optional.ofNullable(operationaltemplate.getConstraints()).map(TCONSTRAINT::getAttributesArray).stream().flatMap(Arrays::stream).map(this::extractDefault).flatMap(Collection::stream).forEach(p -> this.defaultValues.put((String)p.getKey(), (String)p.getValue()));
    }

    public WebTemplate parse() {
        WebTemplate webTemplate = new WebTemplate();
        webTemplate.setTemplateId(this.operationaltemplate.getTemplateId().getValue());
        webTemplate.setDefaultLanguage(this.defaultLanguage);
        webTemplate.setVersion("2.3");
        webTemplate.getLanguages().addAll(Arrays.stream(this.operationaltemplate.getDescription().getDetailsArray()).map(RESOURCEDESCRIPTIONITEM::getLanguage).map(CODEPHRASE::getCodeString).collect(Collectors.toSet()));
        this.languages = webTemplate.getLanguages();
        for (ANNOTATION annotation : this.operationaltemplate.getAnnotationsArray()) {
            HashMap<String, String> items = new HashMap<String, String>();
            for (StringDictionaryItem item : annotation.getItemsArray()) {
                items.put(item.getId(), item.getStringValue());
            }
            this.annotationMap.put(annotation.getPath().replaceAll("^[^/]+", ""), items);
        }
        webTemplate.setTree(this.parseCARCHETYPEROO(this.operationaltemplate.getDefinition(), AqlPath.EMPTY_PATH).get(0));
        return webTemplate;
    }

    static XmlObject[] extractChildren(XmlObject c, String attributes) {
        return c.selectChildren("http://schemas.openehr.org/v1", attributes);
    }

    private List<Pair<String, String>> extractDefault(TATTRIBUTE xmlObject) {
        ArrayList<Pair<String, String>> defaults = new ArrayList<Pair<String, String>>();
        String differentialPath = StringUtils.substringAfter((String)xmlObject.getDifferentialPath(), (String)PATH_DIVIDER);
        String rmAttributeName = xmlObject.getRmAttributeName();
        AqlPath aql = AqlPath.EMPTY_PATH.addEnd(new String[]{differentialPath, rmAttributeName});
        List<String> attributeNames = Arrays.stream(xmlObject.getChildrenArray()).map(TCOMPLEXOBJECT::getDefaultValue).map(XmlTokenSource::newDomNode).map(Node::getFirstChild).map(Node::getChildNodes).map(this::buildList).flatMap(Collection::stream).map(Node::getNodeName).collect(Collectors.toList());
        attributeNames.forEach(n -> {
            Optional any = Arrays.stream(xmlObject.getChildrenArray()).map(TCOMPLEXOBJECT::getDefaultValue).map(x -> OPTParser.extractChildren((XmlObject)x, n)).flatMap(Arrays::stream).findAny();
            if (any.isPresent()) {
                if (((XmlObject)any.get()).newDomNode().getFirstChild().getChildNodes().getLength() == 1) {
                    String defaultValue = ((XmlObject)any.get()).newCursor().getTextValue();
                    defaults.add((Pair<String, String>)new ImmutablePair((Object)(aql + "|" + n), (Object)defaultValue));
                } else {
                    String defaultValue = Arrays.stream(OPTParser.extractChildren((XmlObject)any.get(), "defining_code")).findAny().map(x -> OPTParser.extractChildren(x, "code_string")).stream().flatMap(Arrays::stream).map(XmlTokenSource::newCursor).map(XmlCursor::getTextValue).findAny().orElse("");
                    defaults.add((Pair<String, String>)new ImmutablePair((Object)(aql + "|defining_code"), (Object)defaultValue));
                }
            }
        });
        return defaults;
    }

    private List<Node> buildList(NodeList list) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 1) continue;
            nodes.add(item);
        }
        return nodes;
    }

    private List<WebTemplateNode> parseCARCHETYPEROO(CARCHETYPEROOT carchetyperoot, AqlPath aqlPath) {
        HashMap<String, Map<String, TermDefinition>> termDefinitionMap = new HashMap<String, Map<String, TermDefinition>>();
        for (ARCHETYPETERM term : carchetyperoot.getTermDefinitionsArray()) {
            String code = term.getCode();
            String value2 = null;
            String description = null;
            HashMap<String, String> otherMap = new HashMap<String, String>();
            for (StringDictionaryItem item : term.getItemsArray()) {
                if ("text".equals(item.getId())) {
                    value2 = item.getStringValue();
                    continue;
                }
                if ("description".equals(item.getId())) {
                    description = item.getStringValue();
                    continue;
                }
                otherMap.put(item.getId(), item.getStringValue());
            }
            termDefinitionMap.computeIfAbsent(code, c -> new HashMap()).put(this.defaultLanguage, new TermDefinition(code, value2, description, otherMap));
        }
        Map<String, Map<String, TermDefinition>> otherTermDefinitionMap = this.buildOtherTerms(carchetyperoot.getArchetypeId().getValue());
        otherTermDefinitionMap.forEach((key, value) -> termDefinitionMap.computeIfAbsent((String)key, c -> new HashMap()).putAll(value));
        List<WebTemplateNode> nodes = this.parseCCOMPLEXOBJECT((CCOMPLEXOBJECT)carchetyperoot, aqlPath, termDefinitionMap, null);
        nodes.forEach(node -> {
            node.setNodeId(carchetyperoot.getArchetypeId().getValue());
            this.addRMAttributes((WebTemplateNode)node, aqlPath, (Map<String, Map<String, TermDefinition>>)termDefinitionMap);
        });
        return nodes;
    }

    private Map<String, Map<String, TermDefinition>> buildOtherTerms(String archetypeId) {
        HashMap<String, Map<String, TermDefinition>> otherTermDefinitionMap = new HashMap<String, Map<String, TermDefinition>>();
        ArrayList ontologies = new ArrayList();
        ontologies.addAll(Optional.ofNullable(this.operationaltemplate.getOntology()).filter(x -> Objects.equals(x.getArchetypeId(), archetypeId)).map(ARCHETYPEONTOLOGY::getTermDefinitionsArray).stream().flatMap(Arrays::stream).collect(Collectors.toList()));
        ontologies.addAll(Arrays.stream(this.operationaltemplate.getComponentOntologiesArray()).filter(x -> Objects.equals(x.getArchetypeId(), archetypeId)).map(ARCHETYPEONTOLOGY::getTermDefinitionsArray).flatMap(Arrays::stream).collect(Collectors.toList()));
        for (CodeDefinitionSet term : ontologies) {
            String language = term.getLanguage();
            for (ARCHETYPETERM items : term.getItemsArray()) {
                String code = items.getCode();
                String text = "";
                String description = "";
                for (StringDictionaryItem item : items.getItemsArray()) {
                    String id = item.getId();
                    String value = item.getStringValue();
                    if (Objects.equals(id, "text")) {
                        text = value;
                        continue;
                    }
                    if (!Objects.equals(id, "description")) continue;
                    description = value;
                }
                Map termDefinitionMap = otherTermDefinitionMap.computeIfAbsent(code, c -> new HashMap());
                termDefinitionMap.put(language, new TermDefinition(code, text, description));
            }
        }
        return otherTermDefinitionMap;
    }

    private List<WebTemplateNode> parseCCOMPLEXOBJECT(CCOMPLEXOBJECT ccomplexobject, AqlPath aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap, String rmAttributeName) {
        Optional<WebTemplateNode> nameNode = this.buildNameNode(aqlPath, termDefinitionMap, ccomplexobject);
        List nameValues = nameNode.map(WebTemplateNode::getInputs).stream().flatMap(Collection::stream).filter(i -> i.getSuffix() == null || i.getSuffix().equals("code")).map(WebTemplateInput::getList).flatMap(Collection::stream).map(webTemplateInputValue -> {
            Name name = new Name();
            name.label = webTemplateInputValue.getLabel();
            name.localizedLabels = webTemplateInputValue.getLocalizedLabels();
            return name;
        }).collect(Collectors.toList());
        if (nameValues.size() > 1) {
            return nameValues.stream().map(e -> {
                WebTemplateNode node = this.buildNodeWithName(ccomplexobject, aqlPath, termDefinitionMap, rmAttributeName, (Name)e);
                Optional<WebTemplateNode> localNameNode = nameNode.map(WebTemplateNode::new);
                localNameNode.ifPresent(n -> this.setExplicitName((Name)e, node, (WebTemplateNode)n));
                this.addAnnotations(node, aqlPath.toString(), this.annotationMap);
                this.parseComplexObjectSingle(ccomplexobject, node.getAqlPathDto(), termDefinitionMap, localNameNode, node);
                return node;
            }).collect(Collectors.toList());
        }
        Optional explicitName = nameValues.stream().findAny();
        WebTemplateNode node = this.buildNodeWithName(ccomplexobject, aqlPath, termDefinitionMap, rmAttributeName, explicitName.orElse(null));
        nameNode.ifPresent(n -> this.setExplicitName(explicitName.orElse(null), node, (WebTemplateNode)n));
        this.addAnnotations(node, aqlPath.toString(), this.annotationMap);
        this.parseComplexObjectSingle(ccomplexobject, node.getAqlPathDto(), termDefinitionMap, nameNode, node);
        return Collections.singletonList(node);
    }

    private void addAnnotations(WebTemplateNode node, String aqlPath, Map<String, Map<String, String>> annotationMap) {
        Map<String, String> annotationItems = annotationMap.get(aqlPath);
        if (annotationItems != null) {
            WebTemplateAnnotation annotation = node.getAnnotations();
            if (annotation == null) {
                annotation = new WebTemplateAnnotation();
                node.setAnnotations(annotation);
            }
            annotation.getOther().putAll(annotationItems);
        }
    }

    private void setExplicitName(Name explicitName, WebTemplateNode node, WebTemplateNode n) {
        n.setAqlPath(node.getAqlPathDto().addEnd(new String[]{"name"}));
        Optional.ofNullable(explicitName).ifPresent(s -> {
            n.getInputs().stream().filter(i -> i.getSuffix() == null || i.getSuffix().equals("code")).findAny().ifPresent(i -> {
                ArrayList<WebTemplateInputValue> list = new ArrayList<WebTemplateInputValue>(i.getList());
                i.getList().clear();
                list.stream().filter(v -> s.label.equals(v.getLabel())).forEach(i.getList()::add);
            });
            n.findChildById("defining_code").ifPresent(d -> {
                d.getInputs().clear();
                n.getInputs().stream().map(WebTemplateInput::new).forEach(d.getInputs()::add);
            });
        });
    }

    private WebTemplateNode buildNodeWithName(CCOMPLEXOBJECT ccomplexobject, AqlPath aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap, String rmAttributeName, Name explicitName) {
        WebTemplateNode node = this.buildNode((COBJECT)ccomplexobject, rmAttributeName, termDefinitionMap, explicitName);
        node.setAqlPath(aqlPath);
        if (StringUtils.isNotBlank((CharSequence)ccomplexobject.getNodeId()) && explicitName != null) {
            String nameValue = explicitName.label;
            node.setAqlPath(node.getAqlPathDto().replaceLastNode(n -> n.withNameValue(nameValue)));
        }
        return node;
    }

    private void parseComplexObjectSingle(CCOMPLEXOBJECT ccomplexobject, AqlPath aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap, Optional<WebTemplateNode> nameNode, WebTemplateNode node) {
        HashMap<String, WebTemplateInput> inputMap = new HashMap<String, WebTemplateInput>();
        ArrayList<Pair> cardinaltyList = new ArrayList<Pair>();
        for (CATTRIBUTE cattribute : ccomplexobject.getAttributesArray()) {
            WebtemplateCardinality webtemplateCardinality;
            AqlPath pathLoop = aqlPath.addEnd(new String[]{cattribute.getRmAttributeName()});
            if (pathLoop.getLastNode().getName().equals("name")) continue;
            ArrayList<WebTemplateNode> newChildren = new ArrayList<WebTemplateNode>();
            for (COBJECT cobject : cattribute.getChildrenArray()) {
                if (cobject instanceof CPRIMITIVEOBJECT) {
                    inputMap.put(cattribute.getRmAttributeName(), this.inputHandler.extractInput((CPRIMITIVEOBJECT)cobject));
                } else {
                    List<WebTemplateNode> childNode = this.parseCOBJECT(cobject, pathLoop, termDefinitionMap, cattribute.getRmAttributeName());
                    if (childNode != null) {
                        newChildren.addAll(childNode);
                    }
                }
                if (!(cattribute instanceof CSINGLEATTRIBUTE) || cattribute.getExistence().getLower() != 0) continue;
                WebtemplateCardinality cardinality = new WebtemplateCardinality();
                cardinality.setMin(cattribute.getExistence().getLower());
                cardinality.setMax(cattribute.getExistence().getUpper());
                cardinality.setExcludeFromWebTemplate(Boolean.TRUE);
                newChildren.forEach(c -> cardinality.getIds().add(c.getId()));
                node.getCardinalities().add(cardinality);
            }
            List<WebTemplateNode> ismTransitionList = newChildren.stream().filter(n -> "ISM_TRANSITION".equals(n.getRmType())).collect(Collectors.toList());
            if (!ismTransitionList.isEmpty()) {
                WebTemplateNode firstChild = (WebTemplateNode)ismTransitionList.get(0);
                WebTemplateNode ismTransition = new WebTemplateNode();
                ismTransition.setName(cattribute.getRmAttributeName());
                ismTransition.setId(OPTParser.buildId(cattribute.getRmAttributeName()));
                ismTransition.setMin(firstChild.getMin());
                ismTransition.setMax(firstChild.getMax());
                ismTransition.setRmType("ISM_TRANSITION");
                ismTransition.setInContext(true);
                ismTransition.setAqlPath(aqlPath.addEnd(new String[]{cattribute.getRmAttributeName()}));
                WebTemplateNode careflowStep = new WebTemplateNode();
                WebTemplateNode careflowStepProto = firstChild.findChildById(CAREFLOW_STEP).orElseThrow(() -> new SdkException(String.format("Missing node: %s", CAREFLOW_STEP)));
                careflowStep.setMin(careflowStepProto.getMin());
                careflowStep.setMax(careflowStepProto.getMin());
                careflowStep.setName("Careflow_step");
                careflowStep.setId(CAREFLOW_STEP);
                careflowStep.setRmType(DV_CODED_TEXT);
                careflowStep.setInContext(true);
                careflowStep.setAqlPath(aqlPath.addEnd(new String[]{cattribute.getRmAttributeName(), CAREFLOW_STEP}));
                WebTemplateInput code = new WebTemplateInput();
                code.setSuffix("code");
                code.setType(CODED_TEXT);
                code.setTerminology("local");
                ismTransitionList.forEach(i -> {
                    WebTemplateInputValue value = i.findChildById(CAREFLOW_STEP).get().getInputs().get(0).getList().get(0);
                    value.getCurrentStates().addAll(i.findChildById(CURRENT_STATE).get().getInputs().get(0).getList().stream().map(WebTemplateInputValue::getValue).collect(Collectors.toList()));
                    code.getList().add(value);
                });
                careflowStep.getInputs().add(code);
                ismTransition.getChildren().add(careflowStep);
                WebTemplateNode currentState = new WebTemplateNode();
                WebTemplateNode currentStateProto = firstChild.findChildById(CURRENT_STATE).orElseThrow();
                currentState.setMin(currentStateProto.getMin());
                currentState.setMax(currentStateProto.getMin());
                currentState.setRmType(DV_CODED_TEXT);
                currentState.setName("Current_state");
                currentState.setId(CURRENT_STATE);
                currentState.setInContext(true);
                currentState.setAqlPath(aqlPath.addEnd(new String[]{cattribute.getRmAttributeName(), CURRENT_STATE}));
                WebTemplateInput code2 = new WebTemplateInput();
                code2.setSuffix("code");
                code2.setType(CODED_TEXT);
                code2.setTerminology(OPENEHR);
                code2.getList().addAll(ismTransitionList.stream().flatMap(n -> n.findChildById(CURRENT_STATE).stream()).map(WebTemplateNode::getInputs).flatMap(Collection::stream).map(WebTemplateInput::getList).flatMap(Collection::stream).collect(Collectors.toList()));
                currentState.getInputs().add(code2);
                ismTransition.getChildren().add(currentState);
                WebTemplateNode transition = firstChild.findChildById("transition").orElseThrow();
                transition.setAqlPath(aqlPath.addEnd(new String[]{cattribute.getRmAttributeName(), "transition"}));
                transition.setInContext(true);
                ismTransition.getChildren().add(transition);
                node.getChildren().add(ismTransition);
            }
            if (cattribute instanceof CMULTIPLEATTRIBUTE && (webtemplateCardinality = (WebtemplateCardinality)Optional.ofNullable(((CMULTIPLEATTRIBUTE)cattribute).getCardinality()).map(this::buildCardinality).orElse(null)) != null) {
                cardinaltyList.add(Pair.of((Object)webtemplateCardinality, newChildren.stream().map(WebTemplateNode::getAqlPathDto).collect(Collectors.toList())));
            }
            newChildren.stream().filter(c -> !node.isRelativePathNameDependent((WebTemplateNode)c)).filter(c -> newChildren.stream().filter(n -> !n.getAqlPathDto().equals((Object)c.getAqlPathDto())).anyMatch(n -> n.getAqlPathDto().equals((Object)c.getAqlPathDto(), false))).forEach(c -> {
                AqlPath path = AqlPath.parse((String)c.getAqlPath(true), (String)c.getName());
                c.getChildren().forEach(n -> this.replaceParentAql((WebTemplateNode)n, c.getAqlPathDto(), path));
                c.setAqlPath(path);
            });
            node.getChildren().addAll(newChildren);
        }
        Collection<List<WebTemplateNode>> values = node.getChoicesInChildren().values();
        values.stream().flatMap(Collection::stream).forEach(this::updateChoiceId);
        if (node.getRmType().equals("ELEMENT")) {
            if (node.getChildren().isEmpty()) {
                Stream.of("DV_TEXT", DV_CODED_TEXT, "DV_MULTIMEDIA", "DV_PARSABLE", "DV_STATE", "DV_BOOLEAN", "DV_IDENTIFIER", "DV_URI", "DV_EHR_URI", "DV_DURATION", "DV_QUANTITY", "DV_COUNT", "DV_PROPORTION", "DV_DATE_TIME", "DV_TIME", "DV_ORDINAL", "DV_DATE").forEach(t -> this.addAnyNode(node, (String)t, (Map<String, WebTemplateInput>)inputMap));
            } else {
                List<WebTemplateNode> trueChildren = WebTemplateUtils.getTrueChildrenElement(node);
                trueChildren.forEach(c -> this.pushProperties(node, (WebTemplateNode)c));
                if (trueChildren.size() != 1 && node.getChoicesInChildren().isEmpty()) {
                    WebTemplateUtils.getTrueChildrenElement(node).stream().filter(this::updateChoiceId).forEach(n -> {
                        n.getLocalizedDescriptions().putAll(node.getLocalizedDescriptions());
                        n.getLocalizedNames().putAll(node.getLocalizedNames());
                    });
                }
            }
        }
        if (node.getRmType().equals(DV_CODED_TEXT)) {
            List<WebTemplateNode> matching = node.findMatching(n -> n.getRmType().equals("CODE_PHRASE"));
            if (!matching.isEmpty()) {
                node.getInputs().addAll(matching.get(0).getInputs());
            } else {
                node.getInputs().add(InputHandler.buildWebTemplateInput("value", "TEXT"));
                node.getInputs().add(InputHandler.buildWebTemplateInput("code", "TEXT"));
            }
        }
        nameNode.ifPresent(node.getChildren()::add);
        this.addRMAttributes(node, aqlPath, termDefinitionMap);
        if (node.getInputs().isEmpty()) {
            this.inputHandler.addInputs(node, inputMap);
        }
        OPTParser.makeIdUnique(node);
        cardinaltyList.forEach(p -> {
            List nodeIds = ((List)p.getValue()).stream().map(s -> node.findMatching(n -> n.getAqlPathDto().equals(s))).flatMap(Collection::stream).map(WebTemplateNode::getId).collect(Collectors.toList());
            if (((WebtemplateCardinality)p.getKey()).getMax() != null && ((WebtemplateCardinality)p.getKey()).getMax() != -1 && ((WebtemplateCardinality)p.getKey()).getMax() < nodeIds.size() || ((WebtemplateCardinality)p.getKey()).getMin() != null && ((WebtemplateCardinality)p.getKey()).getMin() > 1) {
                ((WebtemplateCardinality)p.getKey()).getIds().addAll(nodeIds);
                node.getCardinalities().add((WebtemplateCardinality)p.getKey());
            }
        });
        node.getChildren().forEach(child -> this.addInContext(node, (WebTemplateNode)child));
    }

    private void replaceParentAql(WebTemplateNode node, AqlPath oldBase, AqlPath newBase) {
        AqlPath childAql = node.getAqlPathDto();
        AqlPath relativeAql = childAql.removeStart(oldBase);
        node.setAqlPath(newBase.addEnd(relativeAql));
        node.getChildren().forEach(n -> this.replaceParentAql((WebTemplateNode)n, childAql, node.getAqlPathDto()));
    }

    private Optional<WebTemplateNode> buildNameNode(AqlPath aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap, CCOMPLEXOBJECT ccomplexobject) {
        return Arrays.stream(ccomplexobject.getAttributesArray()).filter(c -> c.getRmAttributeName().equals("name")).filter(c -> c.getChildrenArray().length == 1).map(c -> this.parseCOBJECT(c.getChildrenArray(0), aqlPath, termDefinitionMap, c.getRmAttributeName())).filter(Objects::nonNull).flatMap(Collection::stream).findAny();
    }

    private void addAnyNode(WebTemplateNode node, String rmType, Map<String, WebTemplateInput> inputMap) {
        WebTemplateNode subNode = new WebTemplateNode();
        subNode.setRmType(rmType);
        this.updateChoiceId(subNode);
        subNode.setName(node.getName());
        subNode.setAqlPath(node.getAqlPathDto().addEnd(new String[]{"value"}));
        subNode.setInContext(true);
        subNode.setMax(1);
        subNode.setMin(0);
        subNode.setLocalizedName(node.getLocalizedName());
        subNode.getLocalizedDescriptions().putAll(node.getLocalizedDescriptions());
        subNode.getLocalizedNames().putAll(node.getLocalizedNames());
        this.inputHandler.addInputs(subNode, inputMap);
        node.getChildren().add(subNode);
    }

    private void addInContext(WebTemplateNode node, WebTemplateNode child) {
        Map<Class<Composition>, List<String>> contextAttributes = Map.of(Locatable.class, List.of("language"), Action.class, List.of("time"), Activity.class, List.of("timing", "action_archetype_id"), Instruction.class, List.of("narrative"), IsmTransition.class, List.of(CURRENT_STATE, CAREFLOW_STEP, "transition"), History.class, List.of("origin"), Event.class, List.of("time"), Entry.class, List.of("language", "provider", "other_participations", "subject", "encoding"), EventContext.class, List.of("start_time", "end_time", "location", "setting", "healthCareFacility", "participations"), Composition.class, List.of("language", "territory", "composer", "category"));
        RMTypeInfo typeInfo = ARCHIE_RM_INFO_LOOKUP.getTypeInfo(node.getRmType());
        if (typeInfo != null) {
            contextAttributes.forEach((k, v) -> {
                if (k.isAssignableFrom(typeInfo.getJavaClass()) && v.contains(child.getId())) {
                    child.setInContext(true);
                }
            });
        }
    }

    private WebtemplateCardinality buildCardinality(CARDINALITY xmlObject) {
        WebtemplateCardinality webtemplateCardinality = new WebtemplateCardinality();
        if (xmlObject.getInterval() != null) {
            if (!xmlObject.getInterval().getLowerUnbounded()) {
                Optional.of(xmlObject).map(CARDINALITY::getInterval).map(IntervalOfInteger::getLower).ifPresent(webtemplateCardinality::setMin);
            }
            if (!xmlObject.getInterval().getUpperUnbounded()) {
                Optional.of(xmlObject).map(CARDINALITY::getInterval).map(IntervalOfInteger::getUpper).ifPresent(webtemplateCardinality::setMax);
            } else {
                webtemplateCardinality.setMax(-1);
            }
        }
        return webtemplateCardinality;
    }

    private void pushProperties(WebTemplateNode node, WebTemplateNode value) {
        value.setNodeId(node.getNodeId());
        value.setAnnotations(node.getAnnotations());
        value.setName(node.getName());
        value.getLocalizedDescriptions().putAll(node.getLocalizedDescriptions());
        value.getLocalizedNames().putAll(node.getLocalizedNames());
        value.setLocalizedName(node.getLocalizedName());
    }

    public static void makeIdUnique(WebTemplateNode node) {
        node.getChildren().stream().collect(Collectors.groupingBy(node1 -> node1.getId(false))).values().forEach(l -> {
            if (l.size() > 1) {
                for (int i = 0; i < l.size(); ++i) {
                    if (i <= 0) continue;
                    WebTemplateNode n = (WebTemplateNode)l.get(i);
                    int optionalIdNumber = i + 1;
                    n.setOptionalIdNumber(optionalIdNumber);
                    if (!"ELEMENT".equals(n.getRmType())) continue;
                    n.getChildren().stream().filter(c -> c.getId().equals(n.getId(false))).forEach(c -> c.setOptionalIdNumber(optionalIdNumber));
                }
            } else {
                ((WebTemplateNode)l.get(0)).setOptionalIdNumber(null);
            }
        });
    }

    private void addRMAttributes(WebTemplateNode node, AqlPath aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap) {
        RMTypeInfo typeInfo = ARCHIE_RM_INFO_LOOKUP.getTypeInfo(node.getRmType());
        if (typeInfo != null && (Locatable.class.isAssignableFrom(typeInfo.getJavaClass()) || EventContext.class.isAssignableFrom(typeInfo.getJavaClass()) || DvInterval.class.isAssignableFrom(typeInfo.getJavaClass()) || IsmTransition.class.isAssignableFrom(typeInfo.getJavaClass()))) {
            node.getChildren().addAll(typeInfo.getAttributes().values().stream().filter(s -> !s.isComputed()).filter(s -> !Element.class.isAssignableFrom(typeInfo.getJavaClass()) || List.of("feeder_audit", "null_flavour").contains(s.getRmName())).filter(s -> !List.of("value").contains(s.getRmName())).filter(s -> !Locatable.class.isAssignableFrom(s.getTypeInCollection())).filter(s -> !DvInterval.class.isAssignableFrom(typeInfo.getJavaClass()) || !Objects.equals("interval", s.getRmName())).map(i -> this.buildNodeForAttribute((RMAttributeInfo)i, aqlPath, termDefinitionMap)).filter(n -> node.getChildren().stream().map(WebTemplateNode::getId).noneMatch(s -> s.equals(n.getId()))).collect(Collectors.toList()));
        }
    }

    private WebTemplateNode buildNodeForAttribute(RMAttributeInfo attributeInfo, AqlPath aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap) {
        WebTemplateNode node = new WebTemplateNode();
        node.setAqlPath(aqlPath.addEnd(new String[]{attributeInfo.getRmName()}));
        node.setName(attributeInfo.getRmName());
        node.setId(OPTParser.buildId(attributeInfo.getRmName()));
        node.setRmType(attributeInfo.getTypeNameInCollection());
        node.setMax(attributeInfo.isMultipleValued() ? -1 : 1);
        node.setMin(attributeInfo.isNullable() ? 0 : 1);
        if (List.of("action_archetype_id", "math_function").contains(attributeInfo.getRmName())) {
            node.setMin(1);
        }
        this.inputHandler.addInputs(node, Collections.emptyMap());
        this.addRMAttributes(node, node.getAqlPathDto(), termDefinitionMap);
        return node;
    }

    private List<WebTemplateNode> parseCOBJECT(COBJECT cobject, AqlPath aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap, String rmAttributeName) {
        if (cobject instanceof CARCHETYPEROOT) {
            String nodeId = ((CARCHETYPEROOT)cobject).getArchetypeId().getValue();
            AqlPath pathLoop = StringUtils.isNotBlank((CharSequence)nodeId) ? aqlPath.replaceLastNode(n -> n.withAtCode(nodeId)) : aqlPath;
            return this.parseCARCHETYPEROO((CARCHETYPEROOT)cobject, pathLoop);
        }
        if (cobject instanceof CCOMPLEXOBJECT) {
            String nodeId = cobject.getNodeId();
            AqlPath pathLoop = StringUtils.isNotBlank((CharSequence)nodeId) ? aqlPath.replaceLastNode(n -> n.withAtCode(nodeId)) : aqlPath;
            return this.parseCCOMPLEXOBJECT((CCOMPLEXOBJECT)cobject, pathLoop, termDefinitionMap, rmAttributeName);
        }
        if (cobject instanceof CDOMAINTYPE) {
            String nodeId = cobject.getNodeId();
            AqlPath pathLoop = StringUtils.isNotBlank((CharSequence)nodeId) ? aqlPath.replaceLastNode(n -> n.withAtCode(nodeId)) : aqlPath;
            return Collections.singletonList(this.parseCDOMAINTYPE((CDOMAINTYPE)cobject, pathLoop, termDefinitionMap, rmAttributeName));
        }
        if (cobject instanceof ARCHETYPESLOT) {
            String nodeId = cobject.getNodeId();
            AqlPath pathLoop = StringUtils.isNotBlank((CharSequence)nodeId) ? aqlPath.replaceLastNode(n -> n.withAtCode(nodeId)) : aqlPath;
            return Collections.singletonList(this.parseARCHETYPESLOT((ARCHETYPESLOT)cobject, pathLoop, termDefinitionMap, rmAttributeName));
        }
        return null;
    }

    private WebTemplateNode parseARCHETYPESLOT(ARCHETYPESLOT cobject, AqlPath pathLoop, Map<String, Map<String, TermDefinition>> termDefinitionMap, String rmAttributeName) {
        WebTemplateNode node = this.buildNode((COBJECT)cobject, rmAttributeName, termDefinitionMap, null);
        node.setAqlPath(pathLoop);
        return node;
    }

    private WebTemplateNode parseCDOMAINTYPE(CDOMAINTYPE cdomaintype, AqlPath aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap, String rmAttributeName) {
        WebTemplateNode node = this.buildNode((COBJECT)cdomaintype, rmAttributeName, termDefinitionMap, null);
        node.setAqlPath(aqlPath);
        if (cdomaintype instanceof CDVSTATE) {
            throw new SdkException(String.format("Unexpected class: %s", cdomaintype.getClass().getSimpleName()));
        }
        if (cdomaintype instanceof CDVQUANTITY) {
            WebTemplateInput magnitude = new WebTemplateInput();
            magnitude.setSuffix("magnitude");
            magnitude.setType("DECIMAL");
            Optional.of((CDVQUANTITY)cdomaintype).map(CDVQUANTITY::getAssumedValue).map(DVQUANTITY::getMagnitude).map(d -> Double.toString(d)).ifPresent(magnitude::setDefaultValue);
            this.inputHandler.findDefaultValue(node, "magnitude").ifPresent(magnitude::setDefaultValue);
            node.getInputs().add(magnitude);
            WebTemplateInput unit = new WebTemplateInput();
            unit.setSuffix("unit");
            unit.setType(CODED_TEXT);
            Optional.of((CDVQUANTITY)cdomaintype).map(CDVQUANTITY::getAssumedValue).map(DVQUANTITY::getUnits).ifPresent(unit::setDefaultValue);
            this.inputHandler.findDefaultValue(node, "units").ifPresent(unit::setDefaultValue);
            node.getInputs().add(unit);
            Arrays.stream(((CDVQUANTITY)cdomaintype).getListArray()).forEach(o -> {
                WebTemplateInputValue value = new WebTemplateInputValue();
                value.setLabel(o.getUnits());
                value.setValue(o.getUnits());
                WebTemplateValidation validation = new WebTemplateValidation();
                boolean addValidation = false;
                if (o.getMagnitude() != null) {
                    addValidation = true;
                    validation.setRange(this.inputHandler.extractInterval((Interval)o.getMagnitude()));
                }
                if (o.getPrecision() != null) {
                    addValidation = true;
                    validation.setPrecision(this.inputHandler.extractInterval((Interval)o.getPrecision()));
                }
                if (addValidation) {
                    value.setValidation(validation);
                }
                value.getLocalizedLabels().putAll(termDefinitionMap.getOrDefault(o.getUnits(), Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getValue())));
                unit.getList().add(value);
            });
            if (unit.getList().size() == 1) {
                magnitude.setValidation(unit.getList().get(0).getValidation());
            }
        } else if (cdomaintype instanceof CDVORDINAL) {
            WebTemplateInput code = new WebTemplateInput();
            this.inputHandler.findDefaultValue(node, "defining_code").ifPresent(code::setDefaultValue);
            code.setType(CODED_TEXT);
            node.getInputs().add(code);
            Optional.of((CDVORDINAL)cdomaintype).map(CDVORDINAL::getAssumedValue).map(DVORDINAL::getSymbol).map(DVCODEDTEXT::getDefiningCode).map(CODEPHRASE::getCodeString).ifPresent(code::setDefaultValue);
            Arrays.stream(((CDVORDINAL)cdomaintype).getListArray()).forEach(o -> {
                WebTemplateInputValue value = new WebTemplateInputValue();
                value.setOrdinal(o.getValue());
                value.setValue(o.getSymbol().getDefiningCode().getCodeString());
                value.getLocalizedLabels().putAll(Optional.ofNullable((Map)termDefinitionMap.get(value.getValue())).map(Map::entrySet).stream().flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getValue())));
                value.getLocalizedDescriptions().putAll(Optional.ofNullable((Map)termDefinitionMap.get(value.getValue())).map(Map::entrySet).stream().flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getDescription())));
                value.setLabel(value.getLocalizedLabels().get(this.defaultLanguage));
                if (!value.getLocalizedDescriptions().containsKey(this.defaultLanguage)) {
                    value.getLocalizedDescriptions().put(this.defaultLanguage, "");
                }
                code.getList().add(value);
            });
        } else if (cdomaintype instanceof CCODEPHRASE) {
            WebTemplateInput code = new WebTemplateInput();
            this.inputHandler.findDefaultValue(node, "defining_code").ifPresent(code::setDefaultValue);
            code.setSuffix("code");
            node.getInputs().add(code);
            Optional.of((CCODEPHRASE)cdomaintype).map(CCODEPHRASE::getAssumedValue).map(CODEPHRASE::getCodeString).ifPresent(code::setDefaultValue);
            if (cdomaintype instanceof CCODEREFERENCE) {
                code.setTerminology(Optional.of((CCODEREFERENCE)cdomaintype).map(CCODEREFERENCE::getReferenceSetUri).map(s -> StringUtils.removeStart((String)s, (String)"terminology:")).orElse(null));
            } else {
                code.setTerminology(Optional.of((CCODEPHRASE)cdomaintype).map(CCODEPHRASE::getTerminologyId).map(OBJECTID::getValue).orElse(null));
            }
            if (code.getTerminology().equals(OPENEHR)) {
                ValueSet valueSet = TerminologyProvider.findOpenEhrValueSet((String)code.getTerminology(), (String[])((CCODEPHRASE)cdomaintype).getCodeListArray(), (String)this.defaultLanguage);
                Map collect = this.languages.stream().collect(Collectors.toMap(Function.identity(), l -> TerminologyProvider.findOpenEhrValueSet((String)code.getTerminology(), (String[])((CCODEPHRASE)cdomaintype).getCodeListArray(), (String)l)));
                valueSet.getTherms().forEach(t -> {
                    WebTemplateInputValue value = new WebTemplateInputValue();
                    value.setValue(t.getCode());
                    value.setLabel(t.getValue());
                    value.getLocalizedLabels().putAll(collect.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ValueSet)e.getValue()).getTherms().stream().filter(x -> x.getCode().equals(t.getCode())).findAny().map(TermDefinition::getValue).orElse(""))));
                    code.getList().add(value);
                });
            } else {
                Arrays.stream(((CCODEPHRASE)cdomaintype).getCodeListArray()).map(o -> StringUtils.isBlank((CharSequence)code.getTerminology()) || "local".equals(code.getTerminology()) ? o : code.getTerminology() + "::" + o).forEach(o -> {
                    WebTemplateInputValue value = new WebTemplateInputValue();
                    Optional<TermDefinition> termDefinition = Optional.ofNullable((Map)termDefinitionMap.get(o)).map(e -> (TermDefinition)e.get(this.defaultLanguage));
                    if (termDefinition.isEmpty()) {
                        o = o.replace(code.getTerminology() + "::", "");
                        termDefinition = Optional.ofNullable((Map)termDefinitionMap.get(o)).map(e -> (TermDefinition)e.get(this.defaultLanguage));
                    }
                    if (termDefinition.isPresent()) {
                        value.setValue(termDefinition.get().getCode());
                        if (StringUtils.isNotBlank((CharSequence)code.getTerminology())) {
                            value.setValue(value.getValue().replace(code.getTerminology() + "::", ""));
                        }
                        value.setLabel(termDefinition.get().getValue());
                        value.getLocalizedLabels().putAll(termDefinitionMap.getOrDefault(o, Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getValue())));
                        value.getLocalizedDescriptions().putAll(termDefinitionMap.getOrDefault(o, Collections.emptyMap()).entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((TermDefinition)e.getValue()).getDescription())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getDescription())));
                        if (!value.getLocalizedDescriptions().containsKey(this.defaultLanguage)) {
                            value.getLocalizedDescriptions().put(this.defaultLanguage, "");
                        }
                        code.getList().add(value);
                    }
                });
            }
            if (code.getList().isEmpty()) {
                code.setType("TEXT");
                WebTemplateInput value = InputHandler.buildWebTemplateInput("value", "TEXT");
                value.setTerminology(code.getTerminology());
                node.getInputs().add(value);
            } else {
                code.setType(CODED_TEXT);
            }
        } else {
            throw new SdkException(String.format("Unexpected class: %s", cdomaintype.getClass().getSimpleName()));
        }
        return node;
    }

    private WebTemplateNode buildNode(COBJECT cobject, String rmAttributeName, Map<String, Map<String, TermDefinition>> termDefinitionMap, Name nameFromTemplate) {
        WebTemplateNode node = new WebTemplateNode();
        node.setRmType(cobject.getRmTypeName());
        IntervalOfInteger occurrences = cobject.getOccurrences();
        node.setMin(occurrences.getLowerUnbounded() ? -1 : occurrences.getLower());
        node.setMax(occurrences.getUpperUnbounded() ? -1 : occurrences.getUpper());
        String nodeId = cobject.getNodeId();
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            Optional<String> expliziteName = Optional.ofNullable(nameFromTemplate).map(n -> n.label);
            String name = expliziteName.orElse(termDefinitionMap.get(nodeId).get(this.defaultLanguage).getValue());
            node.setName(name);
            node.setId(OPTParser.buildId(name));
            node.setNodeId(nodeId);
            node.setLocalizedName(name);
            if (nameFromTemplate != null) {
                node.getLocalizedNames().putAll(nameFromTemplate.localizedLabels);
            } else {
                node.getLocalizedNames().putAll(termDefinitionMap.get(nodeId).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getValue())));
            }
            node.getLocalizedNames().put(this.defaultLanguage, name);
            node.getLocalizedDescriptions().putAll(termDefinitionMap.get(nodeId).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Optional.ofNullable(((TermDefinition)e.getValue()).getDescription()).orElse(((TermDefinition)e.getValue()).getValue()))));
            Optional.of(termDefinitionMap.get(nodeId)).map(m -> (TermDefinition)m.get(this.defaultLanguage)).map(TermDefinition::getOther).stream().map(Map::entrySet).flatMap(Collection::stream).forEach(e -> {
                if (node.getAnnotations() == null) {
                    node.setAnnotations(new WebTemplateAnnotation());
                }
                if (((String)e.getKey()).equals("comment")) {
                    node.getAnnotations().setComment((String)e.getValue());
                } else {
                    node.getAnnotations().getOther().put((String)e.getKey(), (String)e.getValue());
                }
            });
        } else {
            String name = StringUtils.isNotBlank((CharSequence)rmAttributeName) ? rmAttributeName : cobject.getRmTypeName();
            node.setId(OPTParser.buildId(name));
            node.setName(name);
            node.setLocalizedName(name);
        }
        return node;
    }

    public static String buildId(String term) {
        Object normalTerm = StringUtils.normalizeSpace((String)term.toLowerCase().replaceAll("[^\\p{IsAlphabetic}0-9._\\-]", " ").trim()).replace(" ", "_");
        if (StringUtils.isNumeric((CharSequence)((String)normalTerm).substring(0, 1))) {
            normalTerm = "a" + (String)normalTerm;
        }
        return normalTerm;
    }

    private static class Name {
        String label;
        Map<String, String> localizedLabels;

        private Name() {
        }
    }
}

