/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.parser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.ehrbase.webtemplate.model.ProportionType;
import org.ehrbase.webtemplate.model.WebTemplateComparisonSymbol;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.webtemplate.model.WebTemplateInterval;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.model.WebTemplateValidation;
import org.ehrbase.webtemplate.parser.OPTParser;
import org.openehr.schemas.v1.CBOOLEAN;
import org.openehr.schemas.v1.CDATE;
import org.openehr.schemas.v1.CDATETIME;
import org.openehr.schemas.v1.CDURATION;
import org.openehr.schemas.v1.CINTEGER;
import org.openehr.schemas.v1.CPRIMITIVE;
import org.openehr.schemas.v1.CPRIMITIVEOBJECT;
import org.openehr.schemas.v1.CREAL;
import org.openehr.schemas.v1.CSTRING;
import org.openehr.schemas.v1.CTIME;
import org.openehr.schemas.v1.Interval;
import org.openehr.schemas.v1.IntervalOfDuration;
import org.openehr.schemas.v1.IntervalOfInteger;
import org.openehr.schemas.v1.IntervalOfReal;

public class InputHandler {
    private final Map<String, String> defaultValues;

    public InputHandler(Map<String, String> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public WebTemplateInput extractInput(CPRIMITIVEOBJECT cprimitiveobject) {
        WebTemplateInput input = new WebTemplateInput();
        input.setType(cprimitiveobject.getRmTypeName().replace("_", ""));
        if (input.getType().equals("REAL")) {
            input.setType("DECIMAL");
        }
        if (input.getType().equals("STRING")) {
            input.setType("TEXT");
        }
        CPRIMITIVE item = cprimitiveobject.getItem();
        String pattern = null;
        WebTemplateInterval range = null;
        WebTemplateValidation validation = new WebTemplateValidation();
        Arrays.stream(OPTParser.extractChildren((XmlObject)item, "assumed_value")).findAny().map(a -> a.newCursor().getTextValue()).ifPresent(input::setDefaultValue);
        boolean addValidation = false;
        if (item instanceof CDATETIME) {
            pattern = ((CDATETIME)item).getPattern();
        } else if (item instanceof CTIME) {
            pattern = ((CTIME)item).getPattern();
        } else if (item instanceof CDATE) {
            pattern = ((CDATE)item).getPattern();
        } else if (item instanceof CSTRING) {
            pattern = ((CSTRING)item).getPattern();
            Arrays.stream(((CSTRING)item).getListArray()).forEach(i -> {
                WebTemplateInputValue value = new WebTemplateInputValue();
                value.setValue((String)i);
                value.setLabel((String)i);
                input.getList().add(value);
            });
            input.setListOpen(((CSTRING)item).getListOpen());
        }
        if (item instanceof CDURATION) {
            pattern = ((CDURATION)item).getPattern();
            range = this.extractInterval((Interval)((CDURATION)item).getRange());
        }
        if (item instanceof CINTEGER) {
            range = this.extractInterval((Interval)((CINTEGER)item).getRange());
            Arrays.stream(((CINTEGER)item).getListArray()).forEach(i -> {
                WebTemplateInputValue value = new WebTemplateInputValue();
                value.setValue(Integer.toString(i));
                input.getList().add(value);
            });
        } else if (item instanceof CREAL) {
            range = this.extractInterval((Interval)((CREAL)item).getRange());
        }
        if (item instanceof CBOOLEAN) {
            if (((CBOOLEAN)item).getFalseValid() && !((CBOOLEAN)item).getTrueValid()) {
                WebTemplateInputValue falseInputValue = new WebTemplateInputValue();
                falseInputValue.setLabel("false");
                falseInputValue.setValue("false");
                input.getList().add(falseInputValue);
            } else if (!((CBOOLEAN)item).getFalseValid() && ((CBOOLEAN)item).getTrueValid()) {
                WebTemplateInputValue falseInputValue = new WebTemplateInputValue();
                falseInputValue.setLabel("true");
                falseInputValue.setValue("true");
                input.getList().add(falseInputValue);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            validation.setPattern(pattern);
            addValidation = true;
        }
        if (range != null) {
            validation.setRange(range);
            addValidation = true;
        }
        if (addValidation) {
            input.setValidation(validation);
        }
        return input;
    }

    <T extends Serializable> WebTemplateInterval<T> extractInterval(Interval interval) {
        if (interval == null) {
            return null;
        }
        WebTemplateInterval<Integer> webTemplateInterval = new WebTemplateInterval<Integer>();
        if (!interval.getLowerUnbounded()) {
            webTemplateInterval.setMin((Integer)((Serializable)this.extractLower(interval)));
            if (interval.getLowerIncluded()) {
                webTemplateInterval.setMinOp(WebTemplateComparisonSymbol.GT_EQ);
            } else {
                webTemplateInterval.setMinOp(WebTemplateComparisonSymbol.GT);
            }
        }
        if (!interval.getUpperUnbounded()) {
            webTemplateInterval.setMax((Integer)((Serializable)this.extractUpper(interval)));
            if (interval.getUpperIncluded()) {
                webTemplateInterval.setMaxOp(WebTemplateComparisonSymbol.LT_EQ);
            } else {
                webTemplateInterval.setMaxOp(WebTemplateComparisonSymbol.LT);
            }
        }
        if (interval instanceof IntervalOfInteger) {
            webTemplateInterval = this.normalizeInterval(webTemplateInterval);
        }
        return webTemplateInterval;
    }

    WebTemplateInterval<Integer> normalizeInterval(WebTemplateInterval<Integer> interval) {
        if (Objects.equals((Object)interval.getMaxOp(), (Object)WebTemplateComparisonSymbol.LT)) {
            interval.setMaxOp(WebTemplateComparisonSymbol.LT_EQ);
            interval.setMax(interval.getMax() - 1);
        }
        if (Objects.equals((Object)interval.getMinOp(), (Object)WebTemplateComparisonSymbol.GT)) {
            interval.setMinOp(WebTemplateComparisonSymbol.GT_EQ);
            interval.setMin(interval.getMin() + 1);
        }
        return interval;
    }

    private <T> T extractLower(Interval interval) {
        if (interval instanceof IntervalOfReal) {
            return (T)Double.valueOf(((IntervalOfReal)interval).getLower());
        }
        if (interval instanceof IntervalOfInteger) {
            return (T)Integer.valueOf(((IntervalOfInteger)interval).getLower());
        }
        if (interval instanceof IntervalOfDuration) {
            return (T)((IntervalOfDuration)interval).getLower();
        }
        return null;
    }

    private <T> T extractUpper(Interval interval) {
        if (interval instanceof IntervalOfReal) {
            return (T)Double.valueOf(((IntervalOfReal)interval).getUpper());
        }
        if (interval instanceof IntervalOfInteger) {
            return (T)Integer.valueOf(((IntervalOfInteger)interval).getUpper());
        }
        if (interval instanceof IntervalOfDuration) {
            return (T)((IntervalOfDuration)interval).getUpper();
        }
        return null;
    }

    WebTemplateInterval<Integer> buildRange(Integer min, WebTemplateComparisonSymbol minOp, Integer max, WebTemplateComparisonSymbol maxOp) {
        WebTemplateInterval<Integer> range = new WebTemplateInterval<Integer>();
        range.setMax(max);
        range.setMaxOp(maxOp);
        range.setMin(min);
        range.setMinOp(minOp);
        return range;
    }

    public static WebTemplateInput buildWebTemplateInput(String suffix, String type) {
        WebTemplateInput date = new WebTemplateInput();
        date.setType(type);
        date.setSuffix(suffix);
        return date;
    }

    WebTemplateInput buildWebTemplateInput(String suffix, String type, WebTemplateInterval range) {
        WebTemplateInput date = InputHandler.buildWebTemplateInput(suffix, type);
        WebTemplateValidation validation = new WebTemplateValidation();
        validation.setRange(range);
        date.setValidation(validation);
        return date;
    }

    void addInputs(WebTemplateNode node, Map<String, WebTemplateInput> templateInputMap) {
        switch (node.getRmType()) {
            case "DV_DATE": {
                node.getInputs().add(templateInputMap.getOrDefault("value", InputHandler.buildWebTemplateInput(null, "DATE")));
                break;
            }
            case "DV_DATE_TIME": {
                node.getInputs().add(templateInputMap.getOrDefault("value", InputHandler.buildWebTemplateInput(null, "DATETIME")));
                break;
            }
            case "DV_TIME": {
                node.getInputs().add(templateInputMap.getOrDefault("value", InputHandler.buildWebTemplateInput(null, "TIME")));
                break;
            }
            case "DV_ORDINAL": {
                node.getInputs().add(templateInputMap.getOrDefault("value", InputHandler.buildWebTemplateInput(null, "CODED_TEXT")));
                break;
            }
            case "PARTY_PROXY": {
                node.getInputs().add(InputHandler.buildWebTemplateInput("id", "TEXT"));
                node.getInputs().add(InputHandler.buildWebTemplateInput("id_scheme", "TEXT"));
                node.getInputs().add(InputHandler.buildWebTemplateInput("id_namespace", "TEXT"));
                node.getInputs().add(InputHandler.buildWebTemplateInput("name", "TEXT"));
                break;
            }
            case "DV_PARSABLE": {
                node.getInputs().add(InputHandler.buildWebTemplateInput("value", "TEXT"));
                node.getInputs().add(InputHandler.buildWebTemplateInput("formalism", "TEXT"));
                break;
            }
            case "DV_TEXT": 
            case "DV_EHR_URI": 
            case "DV_URI": 
            case "DV_MULTIMEDIA": 
            case "UID_BASED_ID": 
            case "STRING": {
                node.getInputs().add(templateInputMap.getOrDefault("value", InputHandler.buildWebTemplateInput(null, "TEXT")));
                break;
            }
            case "DV_COUNT": {
                WebTemplateInput magnitude = templateInputMap.getOrDefault("magnitude", InputHandler.buildWebTemplateInput(null, "INTEGER"));
                this.findDefaultValue(node, "magnitude").ifPresent(magnitude::setDefaultValue);
                node.getInputs().add(magnitude);
                break;
            }
            case "DV_QUANTITY": {
                WebTemplateInput magnitude = templateInputMap.getOrDefault("magnitude", InputHandler.buildWebTemplateInput("magnitude", "DECIMAL"));
                this.findDefaultValue(node, "magnitude").ifPresent(magnitude::setDefaultValue);
                node.getInputs().add(magnitude);
                node.getInputs().add(InputHandler.buildWebTemplateInput("unit", "TEXT"));
                break;
            }
            case "DV_BOOLEAN": {
                node.getInputs().add(templateInputMap.getOrDefault("value", InputHandler.buildWebTemplateInput(null, "BOOLEAN")));
                break;
            }
            case "DV_STATE": 
            case "DV_CODED_TEXT": {
                node.getInputs().add(InputHandler.buildWebTemplateInput("code", "TEXT"));
                node.getInputs().add(InputHandler.buildWebTemplateInput("value", "TEXT"));
                break;
            }
            case "DV_PROPORTION": {
                WebTemplateInput numerator = templateInputMap.getOrDefault("numerator", InputHandler.buildWebTemplateInput("numerator", "DECIMAL"));
                numerator.setSuffix("numerator");
                node.getInputs().add(numerator);
                WebTemplateInput denominator = templateInputMap.getOrDefault("denominator", InputHandler.buildWebTemplateInput("denominator", "DECIMAL"));
                denominator.setSuffix("denominator");
                List<Object> proportionTypes = Optional.ofNullable(templateInputMap.get("type")).map(WebTemplateInput::getList).stream().flatMap(Collection::stream).map(WebTemplateInputValue::getValue).map(Integer::valueOf).map(ProportionType::findById).collect(Collectors.toList());
                if (proportionTypes.isEmpty()) {
                    proportionTypes = Arrays.asList(ProportionType.values());
                } else if (proportionTypes.size() == 1) {
                    ((ProportionType)((Object)proportionTypes.get(0))).getDenominatorValidator().ifPresent(denominator::setValidation);
                }
                node.getProportionTypes().addAll(proportionTypes);
                node.getInputs().add(denominator);
                break;
            }
            case "DV_IDENTIFIER": {
                node.getInputs().add(InputHandler.buildWebTemplateInput("id", "TEXT"));
                node.getInputs().add(InputHandler.buildWebTemplateInput("type", "TEXT"));
                node.getInputs().add(InputHandler.buildWebTemplateInput("issuer", "TEXT"));
                node.getInputs().add(InputHandler.buildWebTemplateInput("assigner", "TEXT"));
                break;
            }
            case "DV_DURATION": {
                String pattern = Optional.ofNullable(templateInputMap.get("value")).map(WebTemplateInput::getValidation).map(WebTemplateValidation::getPattern).orElse(null);
                Map<String, Integer> minConstrains = this.buildDurationConstrains(Optional.ofNullable(templateInputMap.get("value")).map(WebTemplateInput::getValidation).map(WebTemplateValidation::getRange).map(WebTemplateInterval::getMin).map(Object::toString).orElse(null));
                WebTemplateComparisonSymbol minOperator = Optional.ofNullable(templateInputMap.get("value")).map(WebTemplateInput::getValidation).map(WebTemplateValidation::getRange).map(WebTemplateInterval::getMinOp).orElse(null);
                Map<String, Integer> maxConstrains = this.buildDurationConstrains(Optional.ofNullable(templateInputMap.get("value")).map(WebTemplateInput::getValidation).map(WebTemplateValidation::getRange).map(WebTemplateInterval::getMax).map(Object::toString).orElse(null));
                Map<String, Integer> defaults = this.buildDurationConstrains(this.findDefaultValue(node, "value").orElse(null));
                Integer df = 0;
                if (defaults.isEmpty()) {
                    df = null;
                }
                WebTemplateComparisonSymbol maxOperator = Optional.ofNullable(templateInputMap.get("value")).map(WebTemplateInput::getValidation).map(WebTemplateValidation::getRange).map(WebTemplateInterval::getMaxOp).orElse(null);
                boolean blank = StringUtils.isBlank((CharSequence)pattern);
                this.buildDurationInput(node, "Y", "year", pattern, blank, minConstrains.get("Y"), minOperator, maxConstrains.get("Y"), maxOperator, defaults.getOrDefault("Y", df));
                this.buildDurationInput(node, "M", "month", StringUtils.removeEnd((String)pattern, (String)StringUtils.substringAfter((String)pattern, (String)"T")), blank, minConstrains.get("M"), minOperator, maxConstrains.get("M"), maxOperator, defaults.getOrDefault("M", df));
                this.buildDurationInput(node, "D", "day", pattern, blank, minConstrains.get("D"), minOperator, maxConstrains.get("D"), maxOperator, defaults.getOrDefault("D", df));
                this.buildDurationInput(node, "W", "week", pattern, blank, minConstrains.get("W"), minOperator, maxConstrains.get("W"), maxOperator, defaults.getOrDefault("W", df));
                this.buildDurationInput(node, "H", "hour", pattern, blank, minConstrains.get("H"), minOperator, maxConstrains.get("H"), maxOperator, defaults.getOrDefault("H", df));
                this.buildDurationInput(node, "M", "minute", StringUtils.substringAfter((String)pattern, (String)"D"), blank, minConstrains.get("MT"), minOperator, maxConstrains.get("MT"), maxOperator, defaults.getOrDefault("MT", df));
                this.buildDurationInput(node, "S", "second", pattern, blank, minConstrains.get("S"), minOperator, maxConstrains.get("S"), maxOperator, defaults.getOrDefault("S", df));
            }
        }
        node.getInputs().forEach(i -> Optional.ofNullable(this.defaultValues.get(node.getAqlPath(false) + "|" + (StringUtils.isBlank((CharSequence)i.getSuffix()) ? "value" : i.getSuffix()))).ifPresent(i::setDefaultValue));
    }

    public Optional<String> findDefaultValue(WebTemplateNode node, String inputSuffix) {
        return Optional.ofNullable(this.defaultValues.get(node.getAqlPath(true) + "|" + inputSuffix));
    }

    Map<String, Integer> buildDurationConstrains(String constrain) {
        if (StringUtils.isBlank((CharSequence)constrain)) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> constrainMap = new HashMap<String, Integer>();
        boolean isDatePath = true;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < constrain.length(); ++i) {
            char c = constrain.charAt(i);
            if (c == 'T') {
                isDatePath = false;
                continue;
            }
            if (CharUtils.isAsciiNumeric((char)c)) {
                sb.append(c);
                continue;
            }
            if (c == 'P') continue;
            Object key = String.valueOf(c);
            if (!isDatePath && ((String)key).equals("M")) {
                key = (String)key + "T";
            }
            constrainMap.put((String)key, Integer.parseInt(sb.toString()));
            sb.delete(0, sb.length());
        }
        return constrainMap;
    }

    private void buildDurationInput(WebTemplateNode node, String symbol, String suffix, String pattern, boolean emptyPattern, Integer minValue, WebTemplateComparisonSymbol minOperator, Integer maxValue, WebTemplateComparisonSymbol maxOperator, Integer defaultValue) {
        if (emptyPattern || pattern.contains(symbol)) {
            WebTemplateInterval<Integer> defaultRange = this.buildRange(0, WebTemplateComparisonSymbol.GT_EQ, null, null);
            if (minValue != null) {
                defaultRange.setMin(minValue);
                defaultRange.setMinOp(minOperator);
            }
            if (maxValue != null) {
                defaultRange.setMax(maxValue);
                defaultRange.setMaxOp(maxOperator);
            }
            WebTemplateInput input = this.buildWebTemplateInput(suffix, "INTEGER", defaultRange);
            if (defaultValue != null) {
                input.setDefaultValue(defaultValue.toString());
            }
            node.getInputs().add(input);
        }
    }
}

