/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.commons.lang3.math.NumberUtils;

public class StringToNumberSerializer
extends StdSerializer<String> {
    public StringToNumberSerializer() {
        this(null);
    }

    public StringToNumberSerializer(Class<String> t) {
        super(t);
    }

    public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (NumberUtils.isParsable((String)value)) {
            Number number = NumberUtils.createNumber((String)value);
            if (number instanceof Double) {
                gen.writeNumber(((Double)number).doubleValue());
            } else if (number instanceof Integer) {
                gen.writeNumber(((Integer)number).intValue());
            } else if (number instanceof Float) {
                gen.writeNumber(((Float)number).floatValue());
            } else if (number instanceof Long) {
                gen.writeNumber(((Long)number).longValue());
            } else {
                gen.writeString(value);
            }
        } else {
            gen.writeString(value);
        }
    }
}

