/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.interpreter;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.dto.condition.SimpleValue;
import org.ehrbase.aql.dto.containment.Containment;
import org.ehrbase.aql.dto.path.AqlPath;
import org.ehrbase.aql.dto.path.predicate.PredicateComparisonOperatorDto;
import org.ehrbase.aql.dto.path.predicate.PredicateDto;
import org.ehrbase.aql.dto.path.predicate.PredicateHelper;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public class MatcherUtil {
    private MatcherUtil() {
    }

    static boolean matches(AqlPath.AqlNode node, WebTemplateInput input) {
        return node.getName().equals(Optional.ofNullable(input.getSuffix()).orElse("value"));
    }

    static boolean matches(Containment contain, WebTemplateNode node) {
        boolean isJustType;
        boolean bl = isJustType = contain.getType() != null && (contain.getArchetypeId() == null || contain.getType().equals(contain.getArchetypeId()));
        if (isJustType ? !contain.getType().equals(MatcherUtil.findTypeName(node.getNodeId())) : !Objects.equals(contain.getArchetypeId(), node.getNodeId())) {
            return false;
        }
        Optional<Object> nameValue = PredicateHelper.find((PredicateDto)contain.getOtherPredicates(), (String)"name/value").map(PredicateComparisonOperatorDto::getValue).map(SimpleValue.class::cast).map(SimpleValue::getValue);
        return nameValue.isEmpty() || nameValue.get().equals(node.getName());
    }

    static boolean matches(AqlPath.AqlNode path, WebTemplateNode node) {
        AqlPath.AqlNode nodeAqlNode = node.getAqlPathDto().getLastNode();
        if (!Objects.equals(path.getName(), nodeAqlNode.getName())) {
            return false;
        }
        String atCode = path.getAtCode();
        if (atCode != null && !atCode.equals(nodeAqlNode.getAtCode())) {
            return false;
        }
        return path.findOtherPredicate("name/value") == null || path.findOtherPredicate("name/value").equals(node.getName());
    }

    static String findTypeName(String atCode) {
        Object typeName = null;
        typeName = atCode.contains("openEHR-EHR-") ? StringUtils.substringBetween((String)atCode, (String)"openEHR-EHR-", (String)".") : (atCode.startsWith("at") ? null : atCode);
        return typeName;
    }
}

