/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.base.Interval;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDate;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTime;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import org.ehrbase.validation.constraints.ConstraintOccurrences;
import org.ehrbase.validation.constraints.util.ZonedDateTimeUtil;
import org.openehr.schemas.v1.IntervalOfDate;
import org.openehr.schemas.v1.IntervalOfDateTime;
import org.openehr.schemas.v1.IntervalOfDuration;
import org.openehr.schemas.v1.IntervalOfInteger;
import org.openehr.schemas.v1.IntervalOfReal;
import org.openehr.schemas.v1.IntervalOfTime;

public class IntervalComparator {
    private static void isWithinLxUx(Comparable value, Comparable lower, Comparable upper) throws IllegalArgumentException {
        if (value.compareTo(lower) > 0 && value.compareTo(upper) < 0) {
            return;
        }
        throw new IllegalArgumentException("value is not within interval, expected:" + lower + " < " + value + " < " + upper);
    }

    private static void isWithinLiUx(Comparable value, Comparable lower, Comparable upper) throws IllegalArgumentException {
        if (value.compareTo(lower) >= 0 && value.compareTo(upper) < 0) {
            return;
        }
        throw new IllegalArgumentException("value is not within interval, expected:" + lower + " <= " + value + " < " + upper);
    }

    private static void isWithinLxUi(Comparable value, Comparable lower, Comparable upper) throws IllegalArgumentException {
        if (value.compareTo(lower) > 0 && value.compareTo(upper) <= 0) {
            return;
        }
        throw new IllegalArgumentException("value is not within interval, expected:" + lower + " < " + value + " <= " + upper);
    }

    private static void isWithinLiUi(Comparable value, Comparable lower, Comparable upper) throws IllegalArgumentException {
        if (value.compareTo(lower) >= 0 && value.compareTo(upper) <= 0) {
            return;
        }
        throw new IllegalArgumentException("value is not within interval, expected:" + lower + " <= " + value + " <= " + upper);
    }

    private static void compareWithinInterval(Comparable value, org.openehr.schemas.v1.Interval interval, Comparable lower, Comparable upper) throws IllegalArgumentException {
        boolean isUpperIncluded;
        boolean isLowerIncluded = interval.isSetLowerIncluded() ? interval.getLowerIncluded() : false;
        boolean bl = isUpperIncluded = interval.isSetUpperIncluded() ? interval.getUpperIncluded() : false;
        if (isLowerIncluded && isUpperIncluded) {
            IntervalComparator.isWithinLiUi(value, lower, upper);
        } else if (isLowerIncluded && !isUpperIncluded) {
            IntervalComparator.isWithinLiUx(value, lower, upper);
        } else if (!isLowerIncluded && isUpperIncluded) {
            IntervalComparator.isWithinLxUi(value, lower, upper);
        } else if (!isLowerIncluded && !isUpperIncluded) {
            IntervalComparator.isWithinLxUx(value, lower, upper);
        }
    }

    public static void isWithinBoundaries(Float real, IntervalOfReal intervalOfReal) throws IllegalArgumentException {
        Float lower = Float.valueOf(intervalOfReal.isSetLower() ? intervalOfReal.getLower() : Float.MIN_VALUE);
        Float upper = Float.valueOf(intervalOfReal.isSetUpper() ? intervalOfReal.getUpper() : Float.MAX_VALUE);
        IntervalComparator.compareWithinInterval(real, (org.openehr.schemas.v1.Interval)intervalOfReal, lower, upper);
    }

    public static void isWithinBoundaries(Integer integer, IntervalOfInteger intervalOfInteger) throws IllegalArgumentException {
        Integer lower = intervalOfInteger.isSetLower() ? intervalOfInteger.getLower() : Integer.MIN_VALUE;
        Integer upper = intervalOfInteger.isSetUpper() ? intervalOfInteger.getUpper() : Integer.MAX_VALUE;
        IntervalComparator.compareWithinInterval(integer, (org.openehr.schemas.v1.Interval)intervalOfInteger, lower, upper);
    }

    public static void isWithinBoundaries(Integer integer, ConstraintOccurrences occurrences) throws IllegalArgumentException {
        Integer lower = occurrences.getLower();
        Integer upper = occurrences.getUpper();
        IntervalComparator.compareWithinInterval(integer, (org.openehr.schemas.v1.Interval)IntervalComparator.makeOptInterval(occurrences.asInterval()), lower, upper);
    }

    static void isWithinPrecision(Integer integer, IntervalOfInteger intervalOfInteger) throws IllegalArgumentException {
        if (intervalOfInteger == null) {
            return;
        }
        Integer lower = intervalOfInteger.isSetLower() ? intervalOfInteger.getLower() : Integer.MIN_VALUE;
        Integer upper = intervalOfInteger.isSetUpper() ? intervalOfInteger.getUpper() : Integer.MAX_VALUE;
        try {
            IntervalComparator.compareWithinInterval(integer, (org.openehr.schemas.v1.Interval)intervalOfInteger, lower, upper);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Precision:" + e.getMessage());
        }
    }

    public static void isWithinBoundaries(String rawDate, IntervalOfDate intervalOfDate) throws IllegalArgumentException {
        ZonedDateTime valueDate = ZonedDateTime.parse(rawDate);
        IntervalComparator.isWithinBoundaries(valueDate, intervalOfDate);
    }

    public static void isWithinBoundaries(DvDate date, IntervalOfDate intervalOfDate) throws IllegalArgumentException {
        ZonedDateTime valueDate = ZonedDateTime.from(date.getValue());
        IntervalComparator.isWithinBoundaries(valueDate, intervalOfDate);
    }

    public static void isWithinBoundaries(DvDateTime dateTime, IntervalOfDateTime intervalOfDateTime) throws IllegalArgumentException {
        ZonedDateTime valueDate = ZonedDateTime.from(dateTime.getValue());
        IntervalComparator.isWithinBoundaries(valueDate, intervalOfDateTime);
    }

    public static void isWithinBoundaries(DvTime dateTime, IntervalOfTime intervalOfTime) throws IllegalArgumentException {
        ZonedDateTime valueDate = ZonedDateTime.from(dateTime.getValue());
        IntervalComparator.isWithinBoundaries(valueDate, intervalOfTime);
    }

    public static void isWithinBoundaries(ZonedDateTime valueDate, IntervalOfDate intervalOfDate) throws IllegalArgumentException {
        String lower = intervalOfDate.isSetLower() ? intervalOfDate.getLower() : null;
        String upper = intervalOfDate.isSetUpper() ? intervalOfDate.getUpper() : null;
        ZonedDateTime lowerDate = lower != null ? ZonedDateTime.parse(lower) : new ZonedDateTimeUtil().min();
        ZonedDateTime upperDate = upper != null ? ZonedDateTime.parse(upper) : new ZonedDateTimeUtil().max();
        IntervalComparator.compareWithinInterval(valueDate, (org.openehr.schemas.v1.Interval)intervalOfDate, lowerDate, upperDate);
    }

    public static void isWithinBoundaries(String rawDateTime, IntervalOfDateTime intervalOfDateTime) throws IllegalArgumentException {
        ZonedDateTime valueDateTime = ZonedDateTime.parse(rawDateTime);
        IntervalComparator.isWithinBoundaries(valueDateTime, intervalOfDateTime);
    }

    public static void isWithinBoundaries(ZonedDateTime valueDateTime, IntervalOfDateTime intervalOfDateTime) throws IllegalArgumentException {
        String lower = intervalOfDateTime.isSetLower() ? intervalOfDateTime.getLower() : null;
        String upper = intervalOfDateTime.isSetUpper() ? intervalOfDateTime.getUpper() : null;
        ZonedDateTime lowerDateTime = lower != null ? ZonedDateTime.parse(lower) : new ZonedDateTimeUtil().min();
        ZonedDateTime upperDateTime = upper != null ? ZonedDateTime.parse(upper) : new ZonedDateTimeUtil().max();
        IntervalComparator.compareWithinInterval(valueDateTime, (org.openehr.schemas.v1.Interval)intervalOfDateTime, lowerDateTime, upperDateTime);
    }

    public static void isWithinBoundaries(String rawTime, IntervalOfTime intervalOfTime) throws IllegalArgumentException {
        ZonedDateTime valueTime = ZonedDateTime.parse(rawTime);
        IntervalComparator.isWithinBoundaries(valueTime, intervalOfTime);
    }

    public static void isWithinBoundaries(ZonedDateTime valueTime, IntervalOfTime intervalOfTime) throws IllegalArgumentException {
        String lower = intervalOfTime.isSetLower() ? intervalOfTime.getLower() : null;
        String upper = intervalOfTime.isSetUpper() ? intervalOfTime.getUpper() : null;
        ZonedDateTime lowerTime = lower != null ? ZonedDateTime.parse(lower) : new ZonedDateTimeUtil().min();
        ZonedDateTime upperTime = upper != null ? ZonedDateTime.parse(upper) : new ZonedDateTimeUtil().min();
        IntervalComparator.compareWithinInterval(valueTime, (org.openehr.schemas.v1.Interval)intervalOfTime, lowerTime, upperTime);
    }

    public static void isWithinBoundaries(String rawDuration, IntervalOfDuration intervalOfDuration) throws IllegalArgumentException {
        DvDuration valueDuration = new DvDuration(rawDuration);
        IntervalComparator.isWithinBoundaries(valueDuration, intervalOfDuration);
    }

    public static void isWithinBoundaries(DvDuration valueDuration, IntervalOfDuration intervalOfDuration) throws IllegalArgumentException {
        String lower = intervalOfDuration.isSetLower() ? intervalOfDuration.getLower() : null;
        String upper = intervalOfDuration.isSetUpper() ? intervalOfDuration.getUpper() : null;
        try {
            if (lower != null) {
                DvDuration lowerDuration = new DvDuration(lower);
            } else {
                DvDuration lowerDuration = new DvDuration((TemporalAmount)Duration.ZERO);
            }
            if (upper != null) {
                DvDuration upperDuration = new DvDuration(upper);
            } else {
                DvDuration upperDuration = new DvDuration((TemporalAmount)Duration.of(Long.MAX_VALUE, ChronoUnit.FOREVER));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Boundaries are invalid, please make sure that only durations are specified. Found: lower:" + lower + ", upper:" + upper);
        }
    }

    public static boolean isOptional(IntervalOfInteger intervalOfInteger) {
        if (intervalOfInteger.isSetLower() && intervalOfInteger.getLower() == 1 && intervalOfInteger.isSetUpper() && intervalOfInteger.getUpper() == 1) {
            return false;
        }
        try {
            IntervalComparator.isWithinBoundaries((Integer)0, intervalOfInteger);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static IntervalOfInteger makeOptInterval(Interval<Integer> integerInterval) {
        IntervalOfInteger intervalOfInteger = IntervalOfInteger.Factory.newInstance();
        intervalOfInteger.setLower(((Integer)integerInterval.getLower()).intValue());
        intervalOfInteger.setUpper(((Integer)integerInterval.getUpper()).intValue());
        intervalOfInteger.setLowerIncluded(integerInterval.isLowerIncluded());
        intervalOfInteger.setUpperIncluded(integerInterval.isUpperIncluded());
        return intervalOfInteger;
    }

    public static String toString(IntervalOfInteger intervalOfInteger) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("[");
        if (intervalOfInteger.isSetLower()) {
            stringBuffer.append(intervalOfInteger.getLower());
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append("..");
        if (intervalOfInteger.isSetUpper()) {
            stringBuffer.append(intervalOfInteger.getUpper());
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toString(Interval<Integer> intervalOfInteger) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("[");
        if (intervalOfInteger.getLower() != null && (Integer)intervalOfInteger.getLower() != Integer.MIN_VALUE) {
            stringBuffer.append(intervalOfInteger.getLower());
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append("..");
        if (intervalOfInteger.getUpper() != null && (Integer)intervalOfInteger.getUpper() != Integer.MAX_VALUE) {
            stringBuffer.append(intervalOfInteger.getUpper());
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

