/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvTime;
import java.time.temporal.Temporal;
import java.util.Map;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.util.DateTimeSyntax;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CTypeValidate;
import org.ehrbase.validation.constraints.wrappers.IntervalComparator;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.CPRIMITIVE;
import org.openehr.schemas.v1.CTIME;

public class CTime
extends CConstraint
implements I_CTypeValidate {
    CTime(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, CPRIMITIVE cprimitive) throws IllegalArgumentException {
        if (!(aValue instanceof Temporal)) {
            ValidationException.raise(path, "INTERNAL: Time validation expects a java-date-time argument", "TIME_01");
        }
        CTIME ctime = (CTIME)cprimitive;
        String dvTimeStr = aValue.toString();
        new DateTimeSyntax(path, dvTimeStr, ctime.isSetPattern() ? ctime.getPattern() : null).validate();
        DvTime time = new DvTime(dvTimeStr);
        if (ctime.isSetRange()) {
            IntervalComparator.isWithinBoundaries(time, ctime.getRange());
        }
        this.validateTimeZone(path, time, ctime);
    }

    private void validateTimeZone(String path, DvTime dvTime, CTIME ctime) throws IllegalArgumentException {
    }
}

