/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.util.Map;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.CComplexObject;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.CDomainType;
import org.ehrbase.validation.constraints.wrappers.CPrimitive;
import org.ehrbase.validation.constraints.wrappers.I_CArchetypeConstraintValidate;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.ARCHETYPECONSTRAINT;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CDOMAINTYPE;
import org.openehr.schemas.v1.CPRIMITIVEOBJECT;

public class CObject
extends CConstraint
implements I_CArchetypeConstraintValidate {
    CObject(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, ARCHETYPECONSTRAINT archetypeconstraint) {
        SchemaType type = I_CArchetypeConstraintValidate.findSchemaType(I_CArchetypeConstraintValidate.getXmlType(archetypeconstraint));
        XmlObject constraint = archetypeconstraint.changeType(type);
        if (constraint instanceof CCOMPLEXOBJECT) {
            if (aValue.getClass().equals(this.valueRmType((CCOMPLEXOBJECT)constraint))) {
                new CComplexObject(this.localTerminologyLookup, this.externalTerminologyValidator).validate(path, aValue, (ARCHETYPECONSTRAINT)((CCOMPLEXOBJECT)constraint));
            }
        } else if (constraint instanceof CPRIMITIVEOBJECT) {
            new CPrimitive(this.localTerminologyLookup, this.externalTerminologyValidator).validate(path, aValue, (ARCHETYPECONSTRAINT)((CPRIMITIVEOBJECT)constraint));
        } else if (constraint instanceof CDOMAINTYPE) {
            new CDomainType(this.localTerminologyLookup, this.externalTerminologyValidator).validate(path, aValue, (ARCHETYPECONSTRAINT)((CDOMAINTYPE)constraint));
        } else {
            ValidationException.raise(path, "INTERNAL: unsupported COBJECT:" + archetypeconstraint, "COBJ01");
        }
    }

    private Class valueRmType(CCOMPLEXOBJECT ccomplexobject) {
        String rmTypeName = ccomplexobject.getRmTypeName();
        return ArchieRMInfoLookup.getInstance().getClass(rmTypeName);
    }
}

