/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.rm.datavalues.quantity.DvOrdinal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CArchetypeConstraintValidate;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.ARCHETYPECONSTRAINT;
import org.openehr.schemas.v1.CDVORDINAL;
import org.openehr.schemas.v1.DVORDINAL;

public class CDvOrdinal
extends CConstraint
implements I_CArchetypeConstraintValidate {
    CDvOrdinal(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, ARCHETYPECONSTRAINT archetypeconstraint) throws IllegalArgumentException {
        block6: {
            if (!(aValue instanceof DvOrdinal)) {
                ValidationException.raise(path, "INTERNAL: argument is not a DvOrdinal", "DV_ORDINAL_01");
            }
            DvOrdinal dvOrdinal = (DvOrdinal)aValue;
            CDVORDINAL cdvordinal = (CDVORDINAL)archetypeconstraint;
            if (dvOrdinal.getValue() == null) {
                ValidationException.raise(path, "DvOrdinal requires a non null value", "DV_ORDINAL_02");
            }
            if (dvOrdinal.getSymbol() == null) {
                ValidationException.raise(path, "DvOrdinal requires a non null symbol", "DV_ORDINAL_03");
            }
            if (cdvordinal.sizeOfListArray() > 0) {
                for (DVORDINAL ordinal : cdvordinal.getListArray()) {
                    if ((long)ordinal.getValue() != dvOrdinal.getValue() || StringUtils.isNotEmpty((CharSequence)ordinal.getSymbol().getValue()) && !ordinal.getSymbol().getValue().equals(dvOrdinal.getSymbol().getValue())) continue;
                    String codeString = dvOrdinal.getSymbol().getDefiningCode().getCodeString();
                    String terminology = dvOrdinal.getSymbol().getDefiningCode().getTerminologyId().getValue();
                    if ((!StringUtils.isNotEmpty((CharSequence)codeString) || !ordinal.getSymbol().getDefiningCode().getCodeString().equals(codeString)) && StringUtils.isNotEmpty((CharSequence)terminology) && ordinal.getSymbol().getDefiningCode().getTerminologyId().getValue().equals(terminology)) {
                        continue;
                    }
                    break block6;
                }
                ValidationException.raise(path, "DvOrdinal does not match any valid value, ordinal value:" + dvOrdinal.getValue() + ", code:'" + dvOrdinal.getSymbol() + "'", "DV_ORDINAL_01");
            }
        }
    }
}

