/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.util;

import com.nedap.archie.rm.archetyped.Locatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class LocatableHelper {
    public static final String AND_NAME_VALUE_TOKEN = "and name/value=";
    public static final String COMMA_TOKEN = ",";
    public static final String INDEX_PREFIX_TOKEN = "#";
    public static final String OPEN_BRACKET = "[";
    public static final String CLOSE_BRACKET = "]";
    public static final String FORWARD_SLASH = "/";
    public static final String PATH_SEPARATOR = "/";
    public static final String ROOT = "/";
    private Map<String, Integer> arrayItemPathMap = new HashMap<String, Integer>();

    public static String incrementPathNodeId(String fromPathId) {
        Integer id = Integer.parseInt(fromPathId.substring(2));
        Object[] objectArray = new Object[1];
        id = id + 1;
        objectArray[0] = id;
        String newNodeId = "at" + String.format("%04d", objectArray);
        return newNodeId;
    }

    private static void findLastNodeIdInSibblings(String lastNodeId, List<Locatable> siblings) {
        for (Locatable sibling : siblings) {
            if (!(sibling instanceof Locatable)) continue;
            String nodeId = sibling.getArchetypeNodeId();
            if (!nodeId.contains("openEHR")) {
                Integer last = Integer.parseInt(((String)lastNodeId).substring(2));
                Integer current = Integer.parseInt(nodeId.substring(2));
                if (current <= last) continue;
                lastNodeId = "at" + String.format("%04d", current);
                continue;
            }
            if (!nodeId.contains(INDEX_PREFIX_TOKEN)) continue;
        }
    }

    private static String extractLastAtPath(String itemPath) {
        if (itemPath.contains("[at")) {
            String path = LocatableHelper.simplifyPath(itemPath);
            return path.substring(path.lastIndexOf(OPEN_BRACKET) + 1, path.lastIndexOf(CLOSE_BRACKET));
        }
        return "at0000";
    }

    private static String identifyAttribute(String path) {
        List<String> segments = LocatableHelper.dividePathIntoSegments(path);
        String pathSegment = segments.get(segments.size() - 1);
        int index = pathSegment.indexOf(OPEN_BRACKET);
        String expression = null;
        String attributeName = null;
        if (index > 0) {
            assert (pathSegment.indexOf(CLOSE_BRACKET) > index);
            attributeName = pathSegment.substring(0, index);
            expression = pathSegment.substring(index + 1, pathSegment.indexOf(CLOSE_BRACKET));
        } else {
            attributeName = pathSegment;
        }
        return attributeName;
    }

    public static String indentifyName(String path) {
        List<String> segments = LocatableHelper.dividePathIntoSegments(path);
        String pathSegment = segments.get(segments.size() - 1);
        int index = pathSegment.indexOf(OPEN_BRACKET);
        if (index < 0) {
            return null;
        }
        String expression = pathSegment.substring(index + 1, pathSegment.indexOf(CLOSE_BRACKET));
        String name = null;
        if (expression.contains(" AND ") || expression.contains(" and ") || expression.contains(COMMA_TOKEN)) {
            index = expression.contains(" AND ") ? expression.indexOf(" AND ") : (expression.contains("and") ? expression.indexOf(" and ") : expression.indexOf(COMMA_TOKEN));
            String archetypeNodeId = expression.substring(0, index).trim();
            name = expression.substring(expression.indexOf("'") + 1, expression.lastIndexOf("'"));
        } else if (expression.startsWith("'") && expression.endsWith("'")) {
            name = expression.substring(1, expression.length() - 1);
        }
        return name;
    }

    public static String siblingPath(String unresolvedPath) {
        List<String> segments = LocatableHelper.dividePathIntoSegments(unresolvedPath);
        Object last = segments.get(segments.size() - 1);
        if (((String)last).contains(AND_NAME_VALUE_TOKEN) || ((String)last).contains(COMMA_TOKEN)) {
            last = ((String)last).contains(AND_NAME_VALUE_TOKEN) ? ((String)last).substring(0, ((String)last).indexOf(AND_NAME_VALUE_TOKEN)) + CLOSE_BRACKET : ((String)last).substring(0, ((String)last).indexOf(COMMA_TOKEN)) + CLOSE_BRACKET;
        }
        StringBuffer tentativePath = new StringBuffer();
        for (int i = 0; i < segments.size() - 1; ++i) {
            tentativePath.append(segments.get(i) + "/");
        }
        tentativePath.append((String)last);
        return tentativePath.toString();
    }

    public static Locatable siblingAtPath(Locatable locatable, String unresolvedPath) {
        List<String> segments = LocatableHelper.dividePathIntoSegments(unresolvedPath);
        Object last = segments.get(segments.size() - 1);
        if (((String)last).contains(AND_NAME_VALUE_TOKEN)) {
            last = ((String)last).substring(0, ((String)last).indexOf(AND_NAME_VALUE_TOKEN)) + CLOSE_BRACKET;
        }
        StringBuffer tentativePath = new StringBuffer();
        for (int i = 0; i < segments.size() - 1; ++i) {
            tentativePath.append(segments.get(i) + "/");
        }
        tentativePath.append((String)last);
        Object sibling = locatable.itemAtPath(tentativePath.toString());
        if (sibling != null) {
            return (Locatable)sibling;
        }
        return null;
    }

    public static NodeItem backtrackItemAtPath(Locatable locatable, String unresolvedPath) {
        String parentPath = LocatableHelper.parentPath(unresolvedPath);
        Object parentAtPath = locatable.itemAtPath(parentPath);
        Object childAtPath = null;
        String lastPath = unresolvedPath;
        while (parentAtPath == null && parentPath != null && parentPath.length() > 0) {
            lastPath = parentPath;
            if ((parentPath = LocatableHelper.parentPath(parentPath)) == null || parentPath.length() <= 0) break;
            childAtPath = parentAtPath;
            parentAtPath = locatable.itemAtPath(parentPath);
        }
        return new NodeItem((Locatable)parentAtPath, lastPath, "/" + LocatableHelper.identifyAttribute(lastPath));
    }

    public static Locatable getLocatableParent(Locatable locatable, String path) {
        List<String> segments = LocatableHelper.dividePathIntoSegments(path);
        for (int i = segments.size() - 1; i >= 0; --i) {
            String parentPath = "/" + String.join((CharSequence)"/", segments.subList(0, i));
            if (!(locatable.itemAtPath(parentPath) instanceof Locatable)) continue;
            return (Locatable)locatable.itemAtPath(parentPath);
        }
        return null;
    }

    public static String getLocatableParentPath(Locatable locatable, String path) {
        List<String> segments = LocatableHelper.dividePathIntoSegments(path);
        for (int i = segments.size() - 1; i >= 0; --i) {
            String parentPath = "/" + String.join((CharSequence)"/", segments.subList(0, i));
            if (!(locatable.itemAtPath(parentPath) instanceof Locatable)) continue;
            return parentPath;
        }
        return null;
    }

    private static Object matchingItemInList(List<Locatable> itemList, String path) {
        List<String> segments;
        String lastNodeid;
        if ((path.contains(COMMA_TOKEN) || path.contains(AND_NAME_VALUE_TOKEN)) && ((lastNodeid = (segments = LocatableHelper.dividePathIntoSegments(path)).get(segments.size() - 1)).contains(AND_NAME_VALUE_TOKEN) || lastNodeid.contains(COMMA_TOKEN)) && lastNodeid.contains(INDEX_PREFIX_TOKEN)) {
            String nameValueToken = LocatableHelper.trimIndexValue(LocatableHelper.extractNameValueToken(lastNodeid)).trim();
            for (Locatable locatable : itemList) {
                if (!locatable.getName().getValue().equals(nameValueToken)) continue;
                return locatable;
            }
        }
        return itemList.get(0);
    }

    public static String simplifyPath(String path) {
        StringBuffer tentativePath = new StringBuffer();
        tentativePath.append("/");
        List<String> segments = LocatableHelper.dividePathIntoSegments(path);
        for (int i = 0; i < segments.size(); ++i) {
            String segment = segments.get(i);
            if (segment.contains(AND_NAME_VALUE_TOKEN) || segment.contains(COMMA_TOKEN)) {
                String trimmedNodeId = segment.contains(AND_NAME_VALUE_TOKEN) ? segment.split(AND_NAME_VALUE_TOKEN)[0] : segment.split(COMMA_TOKEN)[0];
                tentativePath.append(trimmedNodeId.trim());
                tentativePath.append(CLOSE_BRACKET);
            } else {
                tentativePath.append(segment);
            }
            if (i >= segments.size() - 1) continue;
            tentativePath.append("/");
        }
        return tentativePath.toString();
    }

    public static boolean hasDefinedOccurence(String path) {
        List<String> segments = LocatableHelper.dividePathIntoSegments(path);
        for (int i = 0; i < segments.size(); ++i) {
            String namePart;
            String segment = segments.get(i);
            if (!segment.contains(AND_NAME_VALUE_TOKEN) && !segment.contains(COMMA_TOKEN)) continue;
            String string = namePart = segment.contains(AND_NAME_VALUE_TOKEN) ? segment.split(AND_NAME_VALUE_TOKEN)[1] : segment.split(COMMA_TOKEN)[1];
            if (!namePart.contains(INDEX_PREFIX_TOKEN)) continue;
            return true;
        }
        return false;
    }

    public static Object itemAtPath(Locatable locatable, String path) {
        return locatable.itemAtPath(path.replace(AND_NAME_VALUE_TOKEN, COMMA_TOKEN));
    }

    public static Integer retrieveIndexValue(String nodeId) {
        if (nodeId.contains(INDEX_PREFIX_TOKEN)) {
            Integer indexValue = Integer.valueOf(nodeId.split(INDEX_PREFIX_TOKEN)[1].split("']")[0]);
            return indexValue;
        }
        return null;
    }

    public static String trimIndexValue(String nodeid) {
        if (nodeid.contains(INDEX_PREFIX_TOKEN)) {
            return nodeid.substring(0, nodeid.indexOf(INDEX_PREFIX_TOKEN));
        }
        return nodeid;
    }

    public static String trimNameValue(String nodeid) {
        if (nodeid.contains(AND_NAME_VALUE_TOKEN) || nodeid.contains(COMMA_TOKEN)) {
            return (nodeid.substring(0, nodeid.indexOf(nodeid.contains(AND_NAME_VALUE_TOKEN) ? AND_NAME_VALUE_TOKEN : COMMA_TOKEN)).trim() + CLOSE_BRACKET).trim();
        }
        return nodeid.trim();
    }

    public static String extractNameValueToken(String nodeid) {
        if (nodeid.contains("'")) {
            return nodeid.substring(nodeid.indexOf("'") + 1, nodeid.lastIndexOf("'"));
        }
        return nodeid;
    }

    public Map<String, Integer> getArrayItemPathMap() {
        return this.arrayItemPathMap;
    }

    public void addItemPath(String itemPath) {
        if (!this.arrayItemPathMap.containsKey(itemPath)) {
            this.arrayItemPathMap.put(itemPath, 1);
        } else {
            this.arrayItemPathMap.put(itemPath, this.arrayItemPathMap.get(itemPath) + 1);
        }
    }

    public static List<String> dividePathIntoSegments(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (tokens.hasMoreTokens()) {
            Object next = tokens.nextToken();
            if (((String)next).matches(".+\\[.+[^\\]]$")) {
                while (!((String)(next = (String)next + "/" + tokens.nextToken())).matches(".*]$")) {
                }
            }
            segments.add((String)next);
        }
        return segments;
    }

    public static String parentPath(String path) {
        List<String> list = LocatableHelper.dividePathIntoSegments(path);
        int pathLevel = list.size();
        if (pathLevel == 0) {
            throw new IllegalArgumentException("Unable to compute parent path: " + path);
        }
        if (pathLevel == 1) {
            return "/";
        }
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < pathLevel - 1; ++j) {
            buf.append("/");
            buf.append(list.get(j));
        }
        return buf.toString();
    }

    public static class NodeItem {
        private Locatable node;
        private String childPath;
        private String insertionPath;

        public NodeItem(Locatable node, String childPath, String insertionPath) {
            this.node = node;
            this.childPath = childPath;
            this.insertionPath = insertionPath;
        }

        public Locatable getNode() {
            return this.node;
        }

        public String getChildPath() {
            return this.childPath;
        }

        public String getInsertionPath() {
            return this.insertionPath;
        }
    }
}

