/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.hardwired;

import org.ehrbase.validation.constraints.ConstraintMapper;
import org.ehrbase.validation.constraints.OptConstraintMapper;
import org.ehrbase.validation.constraints.wrappers.IntervalComparator;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.CARDINALITY;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CMULTIPLEATTRIBUTE;

public abstract class StructureConstraint {
    private final ConstraintMapper constraintMapper;

    StructureConstraint(ConstraintMapper constraintMapper) {
        this.constraintMapper = constraintMapper;
    }

    public void validate(String path, Integer eventsOccurrences) throws IllegalArgumentException {
        CCOMPLEXOBJECT ccomplexobject = ((OptConstraintMapper.OptConstraintItem)((Object)this.constraintMapper.getConstraintItem(path))).getConstraint();
        for (CATTRIBUTE cattribute : ccomplexobject.getAttributesArray()) {
            if (!(cattribute instanceof CMULTIPLEATTRIBUTE)) continue;
            CARDINALITY cardinality = ((CMULTIPLEATTRIBUTE)cattribute).getCardinality();
            if (eventsOccurrences > 1 && cardinality.getIsUnique()) {
                ValidationException.raise(path, "Only one event is allowed in history", "HIS02");
            }
            IntervalComparator.isWithinBoundaries(eventsOccurrences, cardinality.getInterval());
        }
    }
}

