/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints;

import com.nedap.archie.base.MultiplicityInterval;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ehrbase.validation.constraints.ConstraintMapper;
import org.ehrbase.validation.constraints.ConstraintOccurrences;
import org.ehrbase.validation.constraints.wrappers.IntervalComparator;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CMULTIPLEATTRIBUTE;
import org.openehr.schemas.v1.CSINGLEATTRIBUTE;
import org.openehr.schemas.v1.IntervalOfInteger;

public class OptConstraintMapper
extends ConstraintMapper {
    public void setTerminology(Map<String, Map<String, String>> termTable) {
        this.localTerminologyLookup = termTable;
    }

    public void bind(String path, CCOMPLEXOBJECT ccobj) {
        if (!this.elementConstraintMap.containsKey(path)) {
            ArrayList optConstraints = new ArrayList();
            this.elementConstraintMap.put(path, optConstraints);
        }
        ((List)this.elementConstraintMap.get(path)).add(new OptConstraintItem(path, ccobj));
    }

    void addToValidPath(String path) {
        if (path.isEmpty()) {
            return;
        }
        String setPath = path.substring(0, path.lastIndexOf("]") + 1);
        if (setPath.isEmpty()) {
            return;
        }
        this.validNodeList.add(setPath);
    }

    void addToWatchList(String path, CSINGLEATTRIBUTE csingleattribute) {
        if (path.isEmpty()) {
            return;
        }
        String setPath = path.substring(0, path.lastIndexOf("]") + 1);
        if (setPath.isEmpty()) {
            return;
        }
        ConstraintOccurrences constraintOccurrences = new ConstraintOccurrences(csingleattribute.getExistence());
        MultiplicityInterval existence = constraintOccurrences.getExistence();
        if (existence.isMandatory() || existence.isProhibited()) {
            this.watchList.put(setPath, new ConstraintMapper.OccurrenceItem(constraintOccurrences, existence));
        }
    }

    void addToCardinalityList(String path, CMULTIPLEATTRIBUTE cmultipleattribute) {
        IntervalOfInteger cardinalInterval = cmultipleattribute.getCardinality().getInterval();
        try {
            if (cardinalInterval.getLower() >= 1 || !cardinalInterval.getUpperUnbounded()) {
                ConstraintMapper.CardinalityItem cardinalityItem = new ConstraintMapper.CardinalityItem(new ConstraintOccurrences(cmultipleattribute.getExistence()), new ConstraintOccurrences(cmultipleattribute.getCardinality().getInterval()));
                this.cardinalityList.put(path, cardinalityItem);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addToExistence(String path, IntervalOfInteger occurrences) {
        this.occurrencesMap.put(path, new ConstraintOccurrences(occurrences));
    }

    public class OptConstraintItem
    extends ConstraintMapper.ConstraintItem {
        transient CCOMPLEXOBJECT ccomplexobject;

        OptConstraintItem(String path, CCOMPLEXOBJECT ccomplexobject) {
            super(path);
            this.ccomplexobject = ccomplexobject;
        }

        public CCOMPLEXOBJECT getConstraint() {
            return this.ccomplexobject;
        }

        public boolean isMandatory() {
            return !IntervalComparator.isOptional(this.ccomplexobject.getOccurrences());
        }

        String occurrencesToString() {
            return IntervalComparator.toString(this.ccomplexobject.getOccurrences());
        }
    }
}

