/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ehrbase.validation.constraints.ConstraintMapper;
import org.ehrbase.validation.constraints.OptConstraintMapper;
import org.ehrbase.validation.constraints.util.LocatableHelper;
import org.openehr.schemas.v1.ARCHETYPESLOT;
import org.openehr.schemas.v1.ARCHETYPETERM;
import org.openehr.schemas.v1.CARCHETYPEROOT;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CDOMAINTYPE;
import org.openehr.schemas.v1.CDVORDINAL;
import org.openehr.schemas.v1.CMULTIPLEATTRIBUTE;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CPRIMITIVEOBJECT;
import org.openehr.schemas.v1.CSINGLEATTRIBUTE;
import org.openehr.schemas.v1.DVORDINAL;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.StringDictionaryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptConstraint {
    protected static final String VALUE = "value";
    protected static final String ANY = "$any$";
    private Logger log = LoggerFactory.getLogger(OptConstraint.class);
    private OptConstraintMapper constrainMapper = new OptConstraintMapper();
    private Map<String, Map<String, String>> termTable = new HashMap<String, Map<String, String>>();
    private Map<String, List<DVORDINAL>> ordinalTable = new HashMap<String, List<DVORDINAL>>();

    public OptConstraintMapper map(OPERATIONALTEMPLATE opt) throws IllegalArgumentException {
        CARCHETYPEROOT def = opt.getDefinition();
        this.handleArchetypeRoot(opt, def, null, "");
        this.constrainMapper.setTerminology(this.termTable);
        return this.constrainMapper;
    }

    private void handleArchetypeRoot(OPERATIONALTEMPLATE opt, CARCHETYPEROOT def, String name, String path) throws IllegalArgumentException {
        HashMap<String, String> termDef = new HashMap<String, String>();
        for (ARCHETYPETERM term : def.getTermDefinitionsArray()) {
            String code = term.getCode();
            for (StringDictionaryItem item : term.getItemsArray()) {
                if (!"text".equals(item.getId())) continue;
                termDef.put(code, item.getStringValue());
            }
        }
        this.log.debug("CARCHETYPEROOT path={}", (Object)path);
        this.termTable.put(path, termDef);
        this.handleComplexObject(opt, (CCOMPLEXOBJECT)def, termDef, name, path);
    }

    private void handleComplexObject(OPERATIONALTEMPLATE opt, CCOMPLEXOBJECT ccobj, Map<String, String> termDef, String name, String path) throws IllegalArgumentException {
        String nodeId = ccobj.getNodeId();
        String rmTypeName = ccobj.getRmTypeName();
        this.log.debug("rmTypeName={}:nodeId={}:ccobj={}", new Object[]{rmTypeName, nodeId, ccobj});
        this.constrainMapper.addToValidPath(path);
        this.constrainMapper.addToExistence(path, ccobj.getOccurrences());
        CATTRIBUTE[] cattributes = ccobj.getAttributesArray();
        if (cattributes != null && cattributes.length > 0) {
            for (CATTRIBUTE cATTRIBUTE : cattributes) {
                String pathloop = path + "/" + cATTRIBUTE.getRmAttributeName();
                COBJECT[] children = cATTRIBUTE.getChildrenArray();
                String attrName = cATTRIBUTE.getRmAttributeName();
                if (cATTRIBUTE instanceof CSINGLEATTRIBUTE) {
                    if (children == null || children.length <= 0) continue;
                    try {
                        COBJECT cobj = children[0];
                        if (children.length > 1) {
                            this.log.debug("Multiple children in CATTRIBUTE: {}", (Object)children.length);
                        }
                        this.handleCObject(opt, cobj, termDef, attrName, pathloop);
                        this.log.debug("attrName={}", (Object)attrName);
                    }
                    catch (Exception e) {
                        this.log.error("Cannot create attribute name {} on path {}", new Object[]{attrName, pathloop, e});
                    }
                    continue;
                }
                if (!(cATTRIBUTE instanceof CMULTIPLEATTRIBUTE)) continue;
                CMULTIPLEATTRIBUTE cma = (CMULTIPLEATTRIBUTE)cATTRIBUTE;
                for (COBJECT cobj : children) {
                    try {
                        this.handleCObject(opt, cobj, termDef, attrName, pathloop);
                        this.log.debug("attrName={}", (Object)attrName);
                    }
                    catch (Exception e) {
                        this.log.error("Cannot create attribute name " + attrName + " on path " + pathloop, (Throwable)e);
                    }
                }
                this.constrainMapper.addToCardinalityList(path + "/" + cATTRIBUTE.getRmAttributeName(), cma);
            }
        }
        if ("HISTORY".equals(rmTypeName)) {
            this.constrainMapper.bind(path, ccobj);
        } else if ("ELEMENT".equals(rmTypeName)) {
            if (ccobj.getAttributesArray().length > 0) {
                CATTRIBUTE obj = ccobj.getAttributesArray()[0];
                if (ccobj.getAttributesArray().length > 1) {
                    this.log.debug("Multiple CCOBJ ELEMENT: {}", (Object)ccobj.getAttributesArray().length);
                }
                if (obj instanceof CSINGLEATTRIBUTE) {
                    CSINGLEATTRIBUTE attr = (CSINGLEATTRIBUTE)obj;
                    if (VALUE.equals(attr.getRmAttributeName())) {
                        if (attr.getChildrenArray().length > 0) {
                            ArrayList<String> children = new ArrayList<String>();
                            for (COBJECT cobj : attr.getChildrenArray()) {
                                children.add(cobj.getRmTypeName());
                            }
                            this.log.debug("ELEMENT children length: {}", (Object)attr.getChildrenArray().length);
                            if (attr.getChildrenArray().length > 1) {
                                this.log.debug("CHOICE: {}", (Object)attr.getChildrenArray().length);
                            }
                            COBJECT cOBJECT = attr.getChildrenArray()[0];
                            this.handleCObject(opt, cOBJECT, termDef, name, path);
                        } else {
                            this.log.debug("ELEMENT without child, assuming ANY type");
                        }
                    } else {
                        this.log.debug("additional attribute found for element attr.getRmAttributeName()={}", (Object)attr.getRmAttributeName());
                    }
                    this.constrainMapper.addToWatchList(path, attr);
                } else {
                    this.log.debug("Other type for obj: {}", (Object)obj);
                }
            } else {
                this.log.debug("Empty attribute list for ELEMENT, assuming ANY type: {}", (Object)ccobj);
            }
            this.constrainMapper.bind(LocatableHelper.simplifyPath(path), ccobj);
        }
    }

    private void handleCObject(OPERATIONALTEMPLATE opt, COBJECT cobj, Map<String, String> termDef, String attrName, String path) throws IllegalArgumentException {
        this.log.debug("cobj={}:{}", cobj.getClass(), (Object)cobj.getRmTypeName());
        if (cobj instanceof CARCHETYPEROOT) {
            if (!((CARCHETYPEROOT)cobj).getArchetypeId().getValue().isEmpty()) {
                path = (String)path + "[" + ((CARCHETYPEROOT)cobj).getArchetypeId().getValue() + "]";
            }
            this.log.debug("CARCHETYPEROOT path={}", path);
            this.handleArchetypeRoot(opt, (CARCHETYPEROOT)cobj, attrName, (String)path);
        } else if (cobj instanceof CDOMAINTYPE) {
            this.handleDomainTypeObject((CDOMAINTYPE)cobj, termDef, (String)path);
        } else if (cobj instanceof CCOMPLEXOBJECT) {
            if (!"/category".equalsIgnoreCase((String)path) && "/context".equalsIgnoreCase((String)path)) {
                this.handleComplexObject(opt, (CCOMPLEXOBJECT)cobj, termDef, attrName, (String)path);
            }
            if (cobj.getNodeId() != null && !cobj.getNodeId().isEmpty()) {
                path = (String)path + "[" + cobj.getNodeId() + "]";
            }
            this.log.debug("CONTEXT path={}", path);
            this.handleComplexObject(opt, (CCOMPLEXOBJECT)cobj, termDef, attrName, (String)path);
        } else if (cobj instanceof ARCHETYPESLOT) {
            if (!cobj.getNodeId().isEmpty()) {
                path = (String)path + "[" + cobj.getNodeId() + "]";
            }
            this.log.debug("ARCHETYPESLOT path={}", path);
        } else if (!(cobj instanceof CPRIMITIVEOBJECT)) {
            if (cobj.getNodeId() == null) {
                this.log.debug("NodeId is null: {}", (Object)cobj);
            }
            this.log.debug("Some value cannot process because is not CARCHETYPEROOT or CCOMPLEXOBJECT: {}", (Object)cobj);
        }
    }

    public ConstraintMapper getConstraintMapper() {
        return this.constrainMapper;
    }

    private DVORDINAL getOrdinalTermDef(String path, int index) {
        for (String keyTerm : this.ordinalTable.keySet()) {
            if (keyTerm == null || keyTerm.isEmpty() || !path.startsWith(keyTerm)) continue;
            List<DVORDINAL> ordinalList = this.ordinalTable.get(keyTerm);
            for (DVORDINAL ord : ordinalList) {
                if (ord == null || index != ord.getValue()) continue;
                return ord;
            }
        }
        return null;
    }

    private void handleDvOrdinal(CDVORDINAL cdo, Map<String, String> termDef, String path) throws IllegalArgumentException {
        List<DVORDINAL> list = Arrays.asList(cdo.getListArray());
        if (list.isEmpty()) {
            throw new IllegalArgumentException("empty list of ordinal");
        }
        this.ordinalTable.put(path, list);
    }

    private void handleDomainTypeObject(CDOMAINTYPE cpo, Map<String, String> termDef, String path) throws IllegalArgumentException {
        if (cpo instanceof CDVORDINAL && !((CDVORDINAL)cpo).isSetAssumedValue()) {
            this.handleDvOrdinal((CDVORDINAL)cpo, termDef, path);
        }
    }
}

