/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints;

import com.nedap.archie.base.Interval;
import com.nedap.archie.base.MultiplicityInterval;
import java.io.Serializable;
import org.openehr.schemas.v1.IntervalOfInteger;

public class ConstraintOccurrences
implements Serializable {
    Boolean lowerIncluded;
    Boolean upperIncluded;
    Boolean lowerUnbounded;
    Boolean upperUnbounded;
    Integer lower;
    Integer upper;

    public ConstraintOccurrences(IntervalOfInteger intervalOfInteger) {
        this.lowerIncluded = intervalOfInteger.getLowerIncluded();
        this.upperIncluded = intervalOfInteger.getUpperIncluded();
        this.lowerUnbounded = intervalOfInteger.getLowerUnbounded();
        this.upperUnbounded = intervalOfInteger.getUpperUnbounded();
        this.lower = intervalOfInteger.isSetLower() ? Integer.valueOf(intervalOfInteger.getLower()) : Integer.valueOf(Integer.MIN_VALUE);
        this.upper = intervalOfInteger.isSetUpper() ? Integer.valueOf(intervalOfInteger.getUpper()) : Integer.valueOf(Integer.MAX_VALUE);
    }

    public Boolean getLowerIncluded() {
        return this.lowerIncluded;
    }

    public Boolean getUpperIncluded() {
        return this.upperIncluded;
    }

    public Boolean getLowerUnbounded() {
        return this.lowerUnbounded;
    }

    public Boolean getUpperUnbounded() {
        return this.upperUnbounded;
    }

    public Integer getLower() {
        return this.lower;
    }

    public Integer getUpper() {
        return this.upper;
    }

    public MultiplicityInterval getExistence() {
        if (this.lowerIncluded.booleanValue() && this.upperIncluded.booleanValue() && this.lower == 0 && this.upper == 0) {
            return MultiplicityInterval.createProhibited();
        }
        if (this.lower == 0) {
            return MultiplicityInterval.createOptional();
        }
        if (this.lower > 0) {
            return MultiplicityInterval.createMandatory();
        }
        throw new IllegalArgumentException("Could not determine attribute existence from constraint (lower=" + this.lower + ", upper=" + this.upper + ")");
    }

    public Interval<Integer> asInterval() {
        return new Interval((Object)this.getLower(), (Object)this.getUpper(), this.getLowerIncluded().booleanValue(), this.getUpperIncluded().booleanValue());
    }

    public boolean isOptional() {
        return this.lower == 0;
    }
}

