/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation;

import com.nedap.archie.rm.archetyped.Locatable;
import java.util.List;
import java.util.Map;
import org.ehrbase.validation.Message;
import org.ehrbase.validation.constraints.ConstraintMapper;
import org.ehrbase.validation.constraints.ConstraintOccurrences;
import org.ehrbase.validation.constraints.NodeCounter;
import org.ehrbase.validation.constraints.util.LocatableHelper;
import org.ehrbase.validation.constraints.wrappers.IntervalComparator;
import org.ehrbase.validation.constraints.wrappers.ValidationException;

public class Cardinality {
    private ConstraintMapper constraintMapper;
    private Locatable locatable;
    private boolean lenient;

    public Cardinality(ConstraintMapper constraintMapper, Locatable locatable, Boolean lenient) {
        this.constraintMapper = constraintMapper;
        this.locatable = locatable;
        this.lenient = lenient;
    }

    public void check(Locatable structure, String path, ConstraintMapper.CardinalityItem cardinalityItem) {
        block4: {
            Object locatable = structure.itemAtPath(path);
            NodeCounter counter = new NodeCounter();
            counter.count(locatable);
            Integer childOccurrence = counter.getCount();
            try {
                IntervalComparator.isWithinBoundaries(childOccurrence, cardinalityItem.getCardinality());
            }
            catch (Exception e) {
                if (childOccurrence == 0 && !cardinalityItem.getExistence().isOptional()) {
                    if (!this.isTransitivelyOptional(path)) {
                        ValidationException.raise(path, "Cardinality not matched, expected:" + IntervalComparator.toString(cardinalityItem.getCardinality().asInterval()) + ", actual:" + childOccurrence, "CAR01");
                    }
                }
                if (childOccurrence <= 0 && cardinalityItem.getExistence().isOptional()) break block4;
                ValidationException.raise(path, "Cardinality not matched, expected:" + IntervalComparator.toString(cardinalityItem.getCardinality().asInterval()) + ", actual:" + childOccurrence, "CAR01");
            }
        }
    }

    public boolean isTransitivelyOptional(String path) {
        List<String> pathSegments = LocatableHelper.dividePathIntoSegments(path);
        for (int i = pathSegments.size() - 1; i >= 0; --i) {
            ConstraintOccurrences occurrences;
            String checkPath = "/" + String.join((CharSequence)"/", pathSegments.subList(0, i));
            if (!this.constraintMapper.getOccurrencesMap().containsKey(checkPath) || !(occurrences = this.constraintMapper.getOccurrencesMap().get(checkPath)).isOptional()) continue;
            NodeCounter counter = new NodeCounter();
            counter.count(this.locatable.itemsAtPath(checkPath));
            Integer elementCount = counter.getCount();
            return elementCount <= 0;
        }
        return true;
    }

    public String validate() {
        StringBuffer exceptions = new StringBuffer();
        if (this.lenient) {
            return "";
        }
        if (this.constraintMapper == null) {
            return "";
        }
        int valcount = 0;
        for (Map.Entry<String, ConstraintMapper.CardinalityItem> entry : this.constraintMapper.getCardinalityList().entrySet()) {
            ++valcount;
            List item = this.locatable.itemsAtPath(entry.getKey());
            Integer childOccurrence = item.size();
            try {
                IntervalComparator.isWithinBoundaries(childOccurrence, entry.getValue().getCardinality());
            }
            catch (Exception e) {
                if (this.isTransitivelyOptional(entry.getKey())) continue;
                if (childOccurrence == 0 && !entry.getValue().getExistence().isOptional()) {
                    exceptions.append(new Message().encode(entry.getKey(), "Cardinality not matched, expected:" + IntervalComparator.toString(entry.getValue().getCardinality().asInterval()) + ", actual:" + childOccurrence, "CAR01"));
                    continue;
                }
                if (childOccurrence <= 0 && entry.getValue().getExistence().isOptional()) continue;
                exceptions.append(new Message().encode(entry.getKey(), "Cardinality not matched, expected:" + IntervalComparator.toString(entry.getValue().getCardinality().asInterval()) + ", actual:" + childOccurrence, "CAR01"));
            }
        }
        return exceptions.toString();
    }
}

