/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.terminology;

import com.nedap.archie.rm.datatypes.CodePhrase;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TerminologyParam {
    static final Pattern PATTERN = Pattern.compile("(?<api>//[^/]*)/(?<type>CodeSystem|ValueSet)(?:/)?(?<op>\\$expand|\\$validate-code)?(?<param>\\?.*)?");
    private String serviceApi;
    private String operation;
    private boolean useValueSet = true;
    private boolean useCodeSystem = false;
    private String parameter;
    private CodePhrase codePhrase = null;

    public static TerminologyParam ofFhir(String url) {
        if (url == null) {
            return new TerminologyParam();
        }
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            return new TerminologyParam();
        }
        String api = matcher.group("api");
        String type = matcher.group("type");
        String op = matcher.group("op");
        String param = matcher.group("param");
        if (api == null) {
            throw new RuntimeException("Missing service-api");
        }
        TerminologyParam tp = new TerminologyParam(api);
        if ("codesystem".equalsIgnoreCase(type)) {
            tp.useCodeSystem();
        }
        if ("valueset".equalsIgnoreCase(type)) {
            tp.useValueSet();
        }
        tp.setOperation(op);
        tp.setParameter(param != null ? param.substring(1) : null);
        return tp;
    }

    public static TerminologyParam ofServiceApi(String api) {
        return new TerminologyParam(api);
    }

    private TerminologyParam() {
    }

    private TerminologyParam(String serviceApi) {
        this.serviceApi = serviceApi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminologyParam that = (TerminologyParam)o;
        return new EqualsBuilder().append((Object)this.serviceApi, (Object)that.serviceApi).append((Object)this.operation, (Object)that.operation).append(this.useValueSet, that.useValueSet).append(this.useCodeSystem, that.useCodeSystem).append((Object)this.parameter, (Object)that.parameter).append((Object)this.codePhrase, (Object)that.codePhrase).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.serviceApi).append((Object)this.operation).append(this.useValueSet).append(this.useCodeSystem).append((Object)this.parameter).append((Object)this.codePhrase).hashCode();
    }

    public void useValueSet() {
        this.useValueSet = true;
        this.useCodeSystem = false;
    }

    public void useCodeSystem() {
        this.useCodeSystem = true;
        this.useValueSet = false;
    }

    public Optional<String> getServiceApi() {
        return Optional.ofNullable(this.serviceApi);
    }

    public void setOperation(String op) {
        this.operation = op;
    }

    public Optional<String> getOperation() {
        return Optional.ofNullable(this.operation);
    }

    public Optional<CodePhrase> getCodePhrase() {
        return Optional.ofNullable(this.codePhrase);
    }

    public void setCodePhrase(CodePhrase cp) {
        this.codePhrase = cp;
    }

    public Optional<String> renderCodePhrase(Function<CodePhrase, Optional<String>> renderer) {
        return renderer.apply(this.codePhrase);
    }

    public boolean isUseValueSet() {
        return this.useValueSet;
    }

    public boolean isUseCodeSystem() {
        return this.useCodeSystem;
    }

    public void setParameter(String param) {
        this.parameter = param;
    }

    public Optional<String> getParameter() {
        return Optional.ofNullable(this.parameter);
    }

    public Optional<String> extractFromParameter(Function<String, Optional<String>> extractor) {
        return extractor.apply(this.parameter);
    }
}

