/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.walker.defaultvalues.defaultinserter;

import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.stream.Stream;
import org.ehrbase.normalizer.Normalizer;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValuePath;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.serialisation.walker.defaultvalues.defaultinserter.AbstractValueInserter;

public class ObservationValueInserter
extends AbstractValueInserter<Observation> {
    @Override
    public void insert(Observation rmObject, DefaultValues defaultValues) {
        Normalizer normalizer = new Normalizer();
        Observation normalize = (Observation)normalizer.normalize((Object)rmObject);
        if (normalize.getData() != null) {
            this.insert(rmObject.getData(), defaultValues);
            if (normalize.getData().getEvents() != null) {
                normalize.getData().getEvents().stream().forEach(e -> this.insert((Event<?>)e, defaultValues));
            }
        }
        if (normalize.getState() != null) {
            this.insert(normalize.getState(), defaultValues);
            if (normalize.getState().getEvents() != null) {
                normalize.getState().getEvents().forEach(e -> this.insert((Event<?>)e, defaultValues));
            }
        }
    }

    @Override
    private void insert(History<?> rmObject, DefaultValues defaultValues) {
        if (this.isEmpty(rmObject.getOrigin()) && (defaultValues.containsDefaultValue(DefaultValuePath.TIME) || defaultValues.containsDefaultValue(DefaultValuePath.HISTORY_ORIGIN))) {
            TemporalAccessor defaultTemporalAccessor = Stream.of(DefaultValuePath.HISTORY_ORIGIN, DefaultValuePath.TIME).map(defaultValues::getDefaultValue).filter(Objects::nonNull).findFirst().orElseThrow();
            rmObject.setOrigin(new DvDateTime(defaultTemporalAccessor));
        }
    }

    @Override
    private void insert(Event<?> rmObject, DefaultValues defaultValues) {
        if (this.isEmpty(rmObject.getTime()) && defaultValues.containsDefaultValue(DefaultValuePath.TIME)) {
            rmObject.setTime(new DvDateTime(defaultValues.getDefaultValue(DefaultValuePath.TIME)));
        }
    }

    public Class<Observation> getAssociatedClass() {
        return Observation.class;
    }
}

