/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.walker;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.serialisation.walker.ItemExtractor;
import org.ehrbase.serialisation.walker.RmBoolean;
import org.ehrbase.serialisation.walker.RmLong;
import org.ehrbase.serialisation.walker.RmString;
import org.ehrbase.serialisation.walker.Walker;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public abstract class FromCompositionWalker<T>
extends Walker<T> {
    public static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();

    @Override
    protected Object extractRMChild(RMObject currentRM, WebTemplateNode currentNode, WebTemplateNode childNode, boolean isChoice, Integer count) {
        ItemExtractor itemExtractor = new ItemExtractor(currentRM, currentNode, childNode, isChoice && count == null).invoke();
        Object child = itemExtractor.getChild();
        if (count != null && child instanceof List) {
            child = ((List)child).get(count);
            if (isChoice && !ARCHIE_RM_INFO_LOOKUP.getTypeInfo(childNode.getRmType()).getJavaClass().isAssignableFrom(child.getClass())) {
                child = null;
            }
        }
        child = this.wrap(child);
        return child;
    }

    private Object wrap(Object child) {
        if (child != null) {
            if (String.class.isAssignableFrom(child.getClass())) {
                child = new RmString((String)child);
            } else if (Long.class.isAssignableFrom(child.getClass())) {
                child = new RmLong((Long)child);
            }
            if (Boolean.class.isAssignableFrom(child.getClass())) {
                child = new RmBoolean((Boolean)child);
            }
        }
        return child;
    }

    @Override
    protected int calculateSize(Context<T> context, WebTemplateNode childNode) {
        Object child = this.extractRMChild(context.getRmObjectDeque().peek(), context.getNodeDeque().peek(), childNode, false, null, context.getSkippedNodes(childNode));
        if (child instanceof List) {
            return ((List)child).size();
        }
        return 0;
    }

    @Override
    protected ImmutablePair<T, RMObject> extractPair(Context<T> context, WebTemplateNode currentNode, Map<String, List<WebTemplateNode>> choices, WebTemplateNode childNode, Integer i) {
        RMObject currentChild = null;
        Object childObject = null;
        Deque<WebTemplateNode> skippedNodes = null;
        if (context.getFilteredNodeMap() != null) {
            skippedNodes = context.getFilteredNodeMap().get(new ImmutablePair((Object)childNode.getAqlPath(), (Object)childNode.getRmType()));
        }
        if ((currentChild = (RMObject)this.extractRMChild(context.getRmObjectDeque().peek(), currentNode, childNode, choices.containsKey(childNode.getAqlPath()), i, skippedNodes)) != null) {
            childObject = this.extract(context, childNode, choices.containsKey(childNode.getAqlPath()), i);
        }
        ImmutablePair pair = new ImmutablePair(childObject, (Object)currentChild);
        return pair;
    }
}

