/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding.std.umarshal.rmunmarshaller;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.serialisation.flatencoding.std.umarshal.rmunmarshaller.AbstractRMUnmarshaller;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValues;

public class PartyIdentifiedRMUnmarshaller
extends AbstractRMUnmarshaller<PartyIdentified> {
    public Class<PartyIdentified> getAssociatedClass() {
        return PartyIdentified.class;
    }

    @Override
    public void handle(String currentTerm, PartyIdentified rmObject, Map<String, String> currentValues, Context<Map<String, String>> context) {
        this.setValue(currentTerm, "name", currentValues, arg_0 -> ((PartyIdentified)rmObject).setName(arg_0), String.class);
        rmObject.setExternalRef(new PartyRef());
        rmObject.getExternalRef().setId((ObjectId)new GenericId());
        this.setValue(currentTerm, "id", currentValues, arg_0 -> ((ObjectId)rmObject.getExternalRef().getId()).setValue(arg_0), String.class);
        this.setValue(currentTerm, "id_scheme", currentValues, arg_0 -> ((GenericId)((GenericId)rmObject.getExternalRef().getId())).setScheme(arg_0), String.class);
        this.setValue(currentTerm, "id_namespace", currentValues, arg_0 -> ((PartyRef)rmObject.getExternalRef()).setNamespace(arg_0), String.class);
        Map<Integer, Map<String, String>> identifiers = currentValues.entrySet().stream().filter(s -> StringUtils.startsWith((CharSequence)((CharSequence)s.getKey()), (CharSequence)(currentTerm + "/_identifier"))).collect(Collectors.groupingBy(e -> {
            String s = StringUtils.substringBefore((String)StringUtils.substringAfter((String)((String)e.getKey()), (String)":"), (String)"|");
            return StringUtils.isBlank((CharSequence)s) ? 0 : Integer.parseInt(s);
        }, DefaultValues.ATTRIBUTE_COLLECTOR));
        rmObject.setIdentifiers(identifiers.values().stream().map(this::toId).collect(Collectors.toList()));
    }

    private DvIdentifier toId(Map<String, String> stringStringMap) {
        DvIdentifier identifier = new DvIdentifier();
        identifier.setId(stringStringMap.get("id"));
        if (identifier.getId() == null) {
            identifier.setId(stringStringMap.get(""));
        }
        identifier.setAssigner(stringStringMap.get("assigner"));
        identifier.setType(stringStringMap.get("type"));
        identifier.setIssuer(stringStringMap.get("issuer"));
        return identifier;
    }
}

