/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding.std.umarshal.postprocessor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.rm.RMObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.serialisation.flatencoding.std.umarshal.postprocessor.UnmarshalPostprocessor;
import org.ehrbase.serialisation.jsonencoding.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUnmarshalPostprocessor<T extends RMObject>
implements UnmarshalPostprocessor<T> {
    private static final ObjectMapper OBJECT_MAPPER = JacksonUtil.getObjectMapper();
    protected final Set<String> consumedPath = new HashSet<String>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Set<String> getConsumedPaths() {
        return this.consumedPath;
    }

    protected <S> void setValue(String term, String propertyName, Map<String, String> values, Consumer<S> consumer, Class<S> clazz) {
        Object key = propertyName != null ? term + "|" + propertyName : term;
        String jasonValue = values.get(key);
        if (StringUtils.isNotBlank((CharSequence)jasonValue)) {
            try {
                Object value = OBJECT_MAPPER.readValue(jasonValue, clazz);
                consumer.accept(value);
                this.consumedPath.add((String)key);
            }
            catch (JsonProcessingException e) {
                this.log.error(e.getMessage());
            }
        } else {
            consumer.accept(null);
            this.consumedPath.add((String)key);
        }
    }
}

