/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding.std.marshal.postprocessor;

import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ehrbase.serialisation.flatencoding.std.marshal.postprocessor.MarshalPostprocessor;

public class ObservationPostprocessor
implements MarshalPostprocessor<Observation> {
    @Override
    public void process(String term, Observation rmObject, Map<String, Object> values) {
        if (rmObject.getData() != null && rmObject.getData().getOrigin() != null && rmObject.getData().getOrigin().getValue() != null) {
            this.removeOrigin(term, (History<ItemStructure>)rmObject.getData(), values);
        }
        if (rmObject.getState() != null && rmObject.getState().getOrigin() != null && rmObject.getState().getOrigin().getValue() != null) {
            this.removeOrigin(term, (History<ItemStructure>)rmObject.getState(), values);
        }
    }

    public void removeOrigin(String term, History<ItemStructure> history, Map<String, Object> values) {
        Optional<TemporalAccessor> first = history.getEvents().stream().map(Event::getTime).filter(Objects::nonNull).map(DvDateTime::getValue).filter(Objects::nonNull).sorted().findFirst();
        first.filter(t -> t.equals(history.getOrigin().getValue())).ifPresent(t -> values.remove(term + "/origin"));
    }

    public Class<Observation> getAssociatedClass() {
        return Observation.class;
    }
}

