/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import org.ehrbase.serialisation.RMDataFormat;
import org.ehrbase.serialisation.exception.MarshalException;
import org.ehrbase.serialisation.flatencoding.FlatJasonProvider;
import org.ehrbase.serialisation.flatencoding.std.marshal.FlatJsonMarshaller;
import org.ehrbase.serialisation.flatencoding.std.umarshal.FlatJsonUnmarshaller;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.webtemplate.filter.Filter;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;

public class FlatJson
implements RMDataFormat {
    private final OPERATIONALTEMPLATE operationaltemplate;
    private final WebTemplate templateIntrospect;
    private final FlatJsonMarshaller flatJsonMarshaller;
    private final FlatJsonUnmarshaller flatJsonUnmarshaller;

    FlatJson(FlatJasonProvider flatJasonProvider, String templateId) {
        this.operationaltemplate = (OPERATIONALTEMPLATE)flatJasonProvider.getTemplateProvider().find(templateId).orElseThrow(() -> new SdkException(String.format("Template %s not found", templateId)));
        this.flatJsonUnmarshaller = new FlatJsonUnmarshaller();
        this.templateIntrospect = (WebTemplate)flatJasonProvider.getTemplateProvider().buildIntrospect(templateId).map(t -> new Filter().filter(t)).orElseThrow(() -> new SdkException(String.format("Template %s not found", templateId)));
        this.flatJsonMarshaller = new FlatJsonMarshaller();
    }

    @Override
    public String marshal(RMObject rmObject) {
        if (rmObject instanceof Composition) {
            return this.flatJsonMarshaller.toFlatJson((Composition)rmObject, this.templateIntrospect);
        }
        throw new MarshalException(String.format("Class %s not supported in flat format", rmObject.getClass().getSimpleName()));
    }

    @Override
    public <T extends RMObject> T unmarshal(String value, Class<T> clazz) {
        if (clazz.isAssignableFrom(Composition.class)) {
            return (T)this.unmarshal(value);
        }
        throw new SdkException(String.format("Class %s not supported in flat format", clazz.getSimpleName()));
    }

    public Composition unmarshal(String value) {
        return this.flatJsonUnmarshaller.unmarshal(value, this.templateIntrospect, this.operationaltemplate);
    }
}

