/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw;

import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nedap.archie.rm.datavalues.encapsulated.DvMultimedia;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.ehrbase.serialisation.dbencoding.wrappers.json.I_DvTypeAdapter;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.ArrayChildren;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.ArrayClosure;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.ArrayListAdapter;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.Children;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.ElementType;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.EmbeddedValue;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.GenericRmType;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.IterativeItemStructure;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.NameValue;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.NodeId;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.OptOut;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.RawJsonKey;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.ValueArrayList;
import org.ehrbase.serialisation.util.SnakeCase;
import org.ehrbase.webtemplate.parser.FlatPath;

public class LinkedTreeMapAdapter
extends TypeAdapter<LinkedTreeMap<String, Object>>
implements I_DvTypeAdapter {
    private String[] structuralClasses = new String[]{"ItemTree", "ItemTable", "ItemSingle", "PointEvent", "Instruction", "Evaluation", "Observation", "Action", "AdminEntry", "IntervalEvent"};
    protected I_DvTypeAdapter.AdapterType adapterType;

    public LinkedTreeMapAdapter(I_DvTypeAdapter.AdapterType adapterType) {
        this.adapterType = adapterType;
    }

    public LinkedTreeMapAdapter() {
        this.adapterType = I_DvTypeAdapter.AdapterType.DBJSON2RAWJSON;
    }

    public LinkedTreeMap read(JsonReader arg0) {
        return null;
    }

    private void writeInternal(JsonWriter writer, LinkedTreeMap<String, Object> map) throws IOException {
        map = new Children(map).removeDuplicateArchetypeNodeId();
        boolean isItemsOnly = new Children((LinkedTreeMap<String, Object>)map).isItemsOnly();
        boolean isMultiEvents = new Children((LinkedTreeMap<String, Object>)map).isEvents();
        boolean isMultiContent = new Children((LinkedTreeMap<String, Object>)map).isMultiContent();
        String parentItemsArchetypeNodeId = null;
        String parentItemsType = null;
        if (isItemsOnly || isMultiEvents) {
            if (map.containsKey((Object)"archetype_node_id")) {
                parentItemsArchetypeNodeId = (String)map.get((Object)"archetype_node_id");
                map.remove((Object)"archetype_node_id");
            }
            if (map.containsKey((Object)"_type")) {
                parentItemsType = (String)map.get((Object)"_type");
                map.remove((Object)"_type");
            }
            if (map.containsKey((Object)"/$CLASS$")) {
                if (map.get((Object)"/$CLASS$") instanceof ArrayList) {
                    parentItemsType = new SnakeCase((String)((ArrayList)map.get((Object)"/$CLASS$")).get(0)).camelToUpperSnake();
                } else if (map.get((Object)"/$CLASS$") instanceof String) {
                    parentItemsType = new SnakeCase((String)map.get((Object)"/$CLASS$")).camelToUpperSnake();
                }
                map.remove((Object)"/$CLASS$");
            }
        }
        if (isItemsOnly) {
            ArrayList items = new Children((LinkedTreeMap<String, Object>)map).items();
            if (map.containsKey((Object)"/name")) {
                if (map.get((Object)"/name") instanceof ArrayList) {
                    new ValueArrayList(writer, map.get((Object)"/name"), "/name").write();
                } else if (map.get((Object)"/name") instanceof String) {
                    new NameValue(writer, (String)map.get((Object)"/name")).write();
                } else if (map.get((Object)"/name") instanceof LinkedTreeMap) {
                    new NameValue(writer, (LinkedTreeMap)map.get((Object)"/name")).write();
                }
            }
            if (map.containsKey((Object)"/archetype_node_id")) {
                if (map.get((Object)"/archetype_node_id") instanceof ArrayList) {
                    new ValueArrayList(writer, map.get((Object)"/archetype_node_id"), "/archetype_node_id").write();
                } else {
                    writer.name("archetype_node_id").value(map.get((Object)"/archetype_node_id").toString());
                }
            }
            this.writeItemInArray("items", items, writer, parentItemsArchetypeNodeId, parentItemsType);
        } else if (isMultiEvents) {
            ArrayList events = new Children((LinkedTreeMap<String, Object>)map).events();
            this.writeItemInArray("events", events, writer, parentItemsArchetypeNodeId, parentItemsType);
        } else if (isMultiContent) {
            while (map.keySet().iterator().hasNext()) {
                String key = (String)map.keySet().iterator().next();
                if (!key.startsWith("/content")) {
                    if (map.get((Object)key) instanceof LinkedTreeMap) {
                        writer.name(key);
                        writer.beginObject();
                        this.writeNode((LinkedTreeMap<String, Object>)((LinkedTreeMap)map.get((Object)key)), writer);
                        writer.endObject();
                    } else if (map.get((Object)key) instanceof ArrayList) {
                        ArrayList arrayList = (ArrayList)map.get((Object)key);
                        writer.name(key).value(arrayList.get(0).toString());
                    } else {
                        writer.name(key).value((String)map.get((Object)key));
                    }
                    map.remove((Object)key);
                } else {
                    if (this.isNodePredicate(key)) {
                        for (Map.Entry entry : map.entrySet()) {
                            if (!(entry instanceof Map.Entry)) continue;
                            Map.Entry kv = entry;
                            for (Object valueMap : (ArrayList)kv.getValue()) {
                                if (!(valueMap instanceof LinkedTreeMap)) continue;
                                LinkedTreeMap vm = (LinkedTreeMap)valueMap;
                                vm.put((Object)"/archetype_node_id", (Object)new FlatPath((String)kv.getKey()).getLast().getAtCode());
                            }
                        }
                    }
                    Children children = new Children((LinkedTreeMap<String, Object>)map);
                    ArrayList contents = children.contents();
                    this.writeContent(contents, writer);
                    map = children.removeContents();
                }
                if (map.size() != 1) continue;
                if (map.get((Object)"/$CLASS$") != null) {
                    return;
                }
                throw new IllegalStateException("Inconsistent encoding of composition, found:" + map.keySet().toString());
            }
        } else {
            this.writeNode((LinkedTreeMap<String, Object>)map, writer);
        }
    }

    private LinkedTreeMap<String, Object> reformatMapForCanonical(LinkedTreeMap<String, Object> map) {
        map = new IterativeItemStructure(map).promoteIterations();
        map = new EmbeddedValue(map).formatForEmbeddedTag();
        return map;
    }

    public void write(JsonWriter writer, LinkedTreeMap map) throws IOException {
        if (map.isEmpty()) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        this.writeInternal(writer, (LinkedTreeMap<String, Object>)map);
        writer.endObject();
    }

    private boolean isNodePredicate(String key) {
        return key.startsWith("/") && key.contains("[") && key.contains("]");
    }

    private LinkedTreeMap<String, Object> compactTimeMap(LinkedTreeMap<String, Object> valueMap) {
        LinkedTreeMap compactMap = new LinkedTreeMap();
        for (Map.Entry item : valueMap.entrySet()) {
            String key = (String)item.getKey();
            if (key.equals("/value")) {
                String value = (String)((LinkedTreeMap)item.getValue()).get((Object)"value");
                compactMap.put((Object)"/value", (Object)value);
                continue;
            }
            compactMap.put((Object)((String)item.getKey()), item.getValue());
        }
        return compactMap;
    }

    private void writeItemInArray(String heading, ArrayList<?> value, JsonWriter writer, String parentItemsArchetypeNodeId, String parentItemsType) throws IOException {
        new ArrayClosure(writer, parentItemsArchetypeNodeId, parentItemsType).start();
        if (value.isEmpty()) {
            return;
        }
        for (int cursor = 0; cursor < value.size(); ++cursor) {
            if (cursor == 0) {
                writer.name(heading);
                writer.beginArray();
            }
            if (value.get(cursor) instanceof ArrayList) {
                new ArrayListAdapter().write(writer, (ArrayList)value.get(cursor));
                continue;
            }
            new LinkedTreeMapAdapter().write(writer, (LinkedTreeMap)value.get(cursor));
        }
        writer.endArray();
    }

    private void writeContent(ArrayList<?> value, JsonWriter writer) throws IOException {
        for (int cursor = 0; cursor < value.size(); ++cursor) {
            if (cursor == 0) {
                writer.name("content");
                writer.beginArray();
            }
            if (value.get(cursor) instanceof ArrayList) {
                new ArrayListAdapter().write(writer, (ArrayList)value.get(cursor));
                continue;
            }
            new LinkedTreeMapAdapter().write(writer, (LinkedTreeMap)value.get(cursor));
        }
        writer.endArray();
    }

    private void writeNode(LinkedTreeMap<String, Object> map, JsonWriter writer) throws IOException {
        this.reformatMapForCanonical(map);
        block10: for (Map.Entry entry : map.entrySet()) {
            Double[] key;
            Object value = entry.getValue();
            if (value == null || new OptOut((String)(key = (Double[])entry.getKey())).skipIt()) continue;
            String jsonKey = new RawJsonKey((String)key).toRawJson();
            String archetypeNodeId = new NodeId((String)key).predicate();
            if (value instanceof ArrayList && key.equals("data") && map.get((Object)"_type").equals(ArchieRMInfoLookup.getInstance().getTypeInfo(DvMultimedia.class).getRmName())) {
                Double[] dataStore = new Double[((ArrayList)value).size()];
                value = ((ArrayList)value).toArray(dataStore);
            }
            if (value instanceof ArrayList) {
                if (key.equals("/name")) {
                    new ValueArrayList(writer, value, (String)key).write();
                    continue;
                }
                if (key.equals("/$CLASS$")) {
                    writer.name("_type").value(new SnakeCase((String)((ArrayList)value).get(0)).camelToUpperSnake());
                    continue;
                }
                if (key.equals("/archetype_node_id")) {
                    new ValueArrayList(writer, value, (String)key).write();
                    continue;
                }
                if (new ArrayChildren((ArrayList)value).isNull()) continue;
                writer.name(jsonKey);
                writer.beginArray();
                if (this.isNodePredicate((String)key)) {
                    ((ArrayList)value).stream().filter(o -> Map.class.isAssignableFrom(o.getClass())).forEach(m -> ((Map)m).put("archetype_node_id", archetypeNodeId));
                }
                new ArrayListAdapter().write(writer, (ArrayList)value);
                writer.endArray();
                continue;
            }
            if (value instanceof LinkedTreeMap) {
                String type;
                LinkedTreeMap timingValueMap;
                LinkedTreeMap<String, Object> valueMap = (LinkedTreeMap<String, Object>)value;
                String elementType = new ElementType((Map)valueMap).type();
                if (elementType.equals("History")) {
                    LinkedTreeMap eventMap = (LinkedTreeMap)valueMap.get((Object)"/events");
                    valueMap.remove((Object)"/events");
                    valueMap.putAll((Map)eventMap);
                    valueMap.put((Object)"_type", (Object)new SnakeCase(elementType).camelToUpperSnake());
                } else if (archetypeNodeId.equals("/timing") && elementType.equals("DvParsable") && (timingValueMap = (LinkedTreeMap)valueMap.get((Object)"/value")) != null) {
                    valueMap.put((Object)"/value", timingValueMap.get((Object)"value"));
                    valueMap.put((Object)"/formalism", timingValueMap.get((Object)"formalism"));
                }
                if (key.equals("/value") && (type = (String)map.get((Object)"/$CLASS$")) != null && !type.isEmpty()) {
                    valueMap.put((Object)"_type", (Object)new SnakeCase(type).camelToUpperSnake());
                    if (new GenericRmType(type).isSpecialized()) {
                        valueMap = new GenericRmType(new SnakeCase(type).camelToUpperSnake()).inferSpecialization(valueMap);
                    }
                }
                if (valueMap.containsKey((Object)"/$CLASS$")) {
                    valueMap.put((Object)"_type", (Object)new SnakeCase(elementType).camelToUpperSnake());
                    valueMap.remove((Object)"/$CLASS$");
                    if (key.contains("/time")) {
                        valueMap.remove((Object)"/name");
                    }
                }
                if (this.isNodePredicate((String)key)) {
                    valueMap.put((Object)"archetype_node_id", (Object)archetypeNodeId);
                } else if (key.equals("/origin") || key.equals("/time")) {
                    valueMap = this.compactTimeMap(valueMap);
                }
                writer.name(jsonKey);
                new LinkedTreeMapAdapter().write(writer, valueMap);
                continue;
            }
            if (value instanceof String) {
                switch (key) {
                    case "/$CLASS$": {
                        if (!Arrays.asList(this.structuralClasses).contains(value)) continue block10;
                        writer.name("_type").value(new SnakeCase((String)value).camelToUpperSnake());
                        break;
                    }
                    case "/$PATH$": {
                        String archetypeNodeId2 = new FlatPath((String)value).getLast().getAtCode();
                        if (archetypeNodeId2 == null) continue block10;
                        writer.name("_type").value("ELEMENT");
                        break;
                    }
                    case "/name": {
                        new NameValue(writer, value.toString()).write();
                        break;
                    }
                    default: {
                        writer.name(jsonKey).value((String)value);
                        break;
                    }
                }
                continue;
            }
            if (value instanceof Double) {
                writer.name(new SnakeCase((String)key).camelToSnake()).value((Number)((Double)value));
                continue;
            }
            if (value instanceof Long) {
                writer.name(new SnakeCase((String)key).camelToSnake()).value((Number)((Long)value));
                continue;
            }
            if (value instanceof Number) {
                writer.name(new SnakeCase((String)key).camelToSnake()).value((Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                writer.name(new SnakeCase((String)key).camelToSnake()).value((Boolean)value);
                continue;
            }
            if (value instanceof Double[]) {
                writer.name(new SnakeCase((String)key).camelToSnake());
                writer.beginArray();
                for (Double pix : (Double[])value) {
                    writer.value((long)pix.byteValue());
                }
                writer.endArray();
                continue;
            }
            throw new IllegalArgumentException("Could not handle value type for key:" + (String)key + ", value:" + value);
        }
    }
}

