/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ehrbase.serialisation.attributes.LocatableAttributes;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.NodeId;

public class Children {
    LinkedTreeMap<String, Object> linkedTreeMap;

    public Children(LinkedTreeMap<String, Object> linkedTreeMap) {
        this.linkedTreeMap = linkedTreeMap;
    }

    public boolean isItemsOnly() {
        if (this.linkedTreeMap.keySet().stream().filter(s -> s.startsWith("/items")).collect(Collectors.toSet()).size() == 0) {
            return false;
        }
        for (String key : this.linkedTreeMap.keySet()) {
            if (key.startsWith("/items") || key.equals("archetype_node_id") || key.equals("_type") || LocatableAttributes.isLocatableAttribute(key) || key.equals("/$CLASS$")) continue;
            return false;
        }
        return true;
    }

    public int itemsCount() {
        int count = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/items")) continue;
            ++count;
        }
        return count;
    }

    public int eventsCount() {
        int count = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/events")) continue;
            ++count;
        }
        return count;
    }

    public boolean isMultiContent() {
        if (!this.containsKeyStartingWith("/content")) {
            return false;
        }
        int contents = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/content")) continue;
            ++contents;
        }
        return contents > 1;
    }

    public int contentCount() {
        int contents = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/content")) continue;
            ++contents;
        }
        return contents;
    }

    public boolean isMultiData() {
        int data = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/data")) continue;
            ++data;
        }
        return data > 1;
    }

    public boolean isEvents() {
        if (this.linkedTreeMap.keySet().stream().filter(s -> s.startsWith("/events")).collect(Collectors.toSet()).size() == 0) {
            return false;
        }
        int isEvents = 0;
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/events")) continue;
            ++isEvents;
        }
        return isEvents > 1;
    }

    public String type() {
        if (this.linkedTreeMap.containsKey((Object)"/$CLASS$")) {
            return (String)this.linkedTreeMap.get((Object)"/$CLASS$");
        }
        return "*UNDEF*";
    }

    public ArrayList items() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/items")) continue;
            String archetypeNodeId = new NodeId(key).predicate();
            Object e = this.linkedTreeMap.get((Object)key);
            if (List.class.isAssignableFrom(e.getClass())) {
                ((List)e).stream().filter(o -> Map.class.isAssignableFrom(o.getClass())).forEach(m -> ((Map)m).put("archetype_node_id", archetypeNodeId));
            } else if (Map.class.isAssignableFrom(e.getClass())) {
                ((Map)e).put("archetype_node_id", archetypeNodeId);
            }
            items.add(e);
        }
        return items;
    }

    public ArrayList events() {
        ArrayList<Object> events = new ArrayList<Object>();
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/events")) continue;
            events.add(this.linkedTreeMap.get((Object)key));
        }
        return events;
    }

    public ArrayList contents() {
        ArrayList<Object> contents = new ArrayList<Object>();
        for (String key : this.linkedTreeMap.keySet()) {
            if (!key.startsWith("/content")) continue;
            contents.add(this.linkedTreeMap.get((Object)key));
        }
        return contents;
    }

    public LinkedTreeMap removeContents() {
        LinkedTreeMap retMap = new LinkedTreeMap();
        for (String key : this.linkedTreeMap.keySet()) {
            if (key.startsWith("/content")) continue;
            retMap.put((Object)key, this.linkedTreeMap.get((Object)key));
        }
        return retMap;
    }

    public LinkedTreeMap removeDuplicateArchetypeNodeId() {
        LinkedTreeMap retMap = new LinkedTreeMap();
        retMap.putAll(this.linkedTreeMap);
        if (this.linkedTreeMap.containsKey((Object)"archetype_node_id") && this.linkedTreeMap.containsKey((Object)"/archetype_node_id")) {
            retMap.remove((Object)"/archetype_node_id");
        }
        return retMap;
    }

    private boolean containsKeyStartingWith(String key) {
        return this.linkedTreeMap.keySet().stream().filter(s -> s.startsWith(key)).collect(Collectors.toSet()).size() > 0;
    }
}

