/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding.rawjson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.ehrbase.serialisation.dbencoding.EncodeUtilArchie;
import org.ehrbase.serialisation.dbencoding.wrappers.json.I_DvTypeAdapter;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.ArchieCompositionProlog;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.CompositionRoot;

public class LightRawJsonEncoder {
    private String jsonbOrigin;

    public LightRawJsonEncoder(String jsonbOrigin) {
        this.jsonbOrigin = jsonbOrigin;
    }

    public String encodeContentAsString(String root) {
        Object fromDB = this.db2map(root != null && root.equals("value"));
        GsonBuilder gsonRaw = EncodeUtilArchie.getGsonBuilderInstance(I_DvTypeAdapter.AdapterType.DBJSON2RAWJSON);
        String raw = null;
        if (fromDB instanceof Map) {
            Object contentMap;
            raw = root != null ? ((contentMap = ((Map)fromDB).get(root)) instanceof LinkedTreeMap && ((LinkedTreeMap)contentMap).size() == 0 ? this.encodeNullContent() : gsonRaw.create().toJson(((Map)fromDB).get(root))) : gsonRaw.create().toJson(fromDB);
        }
        return raw;
    }

    private String encodeNullContent() {
        Hashtable nullContentMap = new Hashtable();
        nullContentMap.put("content", new ArrayList());
        return new GsonBuilder().create().toJson(nullContentMap);
    }

    public JsonElement encodeContentAsJson(String root) {
        GsonBuilder gsonRaw = EncodeUtilArchie.getGsonBuilderInstance(I_DvTypeAdapter.AdapterType.DBJSON2RAWJSON);
        JsonElement jsonElement = gsonRaw.create().toJsonTree(this.db2map(root != null && root.equals("value")));
        if (root != null) {
            jsonElement = jsonElement.getAsJsonObject().get(root);
        }
        return jsonElement;
    }

    public String encodeCompositionAsString() {
        String root = new CompositionRoot(this.jsonbOrigin).toString();
        String converted = this.encodeContentAsString(root);
        Map compoMap = (Map)this.db2map(false);
        String compositionName = (String)((Map)((List)compoMap.get("/name")).get(0)).get("value");
        return converted.replaceFirst(Pattern.quote("{"), new ArchieCompositionProlog(root, compositionName).toString());
    }

    public Map<String, Object> encodeOtherDetailsAsMap() {
        return (Map)this.db2map(false);
    }

    private Object db2map(boolean isValue) {
        Object contents;
        Object fromDB;
        boolean isArray = false;
        GsonBuilder gsondb = EncodeUtilArchie.getGsonBuilderInstance();
        if (this.jsonbOrigin.startsWith("[")) {
            if (isValue) {
                this.jsonbOrigin = this.jsonbOrigin.trim().substring(1, this.jsonbOrigin.length() - 1);
            } else {
                isArray = true;
            }
        }
        if ((fromDB = gsondb.create().fromJson(this.jsonbOrigin, isArray ? ArrayList.class : Map.class)) instanceof Map && ((Map)fromDB).containsKey("content") && (contents = ((Map)fromDB).get("content")) instanceof LinkedTreeMap) {
            for (Object contentItem : ((LinkedTreeMap)contents).entrySet()) {
                if (!(contentItem instanceof Map.Entry)) continue;
                ((Map)fromDB).put(((Map.Entry)contentItem).getKey().toString(), ((Map.Entry)contentItem).getValue());
            }
            ((Map)fromDB).remove("content");
        }
        return fromDB;
    }
}

