/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import java.util.Map;
import org.apache.commons.collections4.map.PredicatedMap;
import org.ehrbase.serialisation.dbencoding.NameAsDvText;
import org.ehrbase.serialisation.dbencoding.NameInMap;
import org.ehrbase.serialisation.dbencoding.RmObjectEncoding;
import org.ehrbase.serialisation.dbencoding.SimpleClassName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTree {
    Map<String, Object> map;
    Logger log = LoggerFactory.getLogger((String)this.getClass().getSimpleName());

    public SerialTree(Map<String, Object> map) {
        this.map = map;
    }

    public Map<String, Object> insert(String clazz, Object node, String key, Object addStructure) {
        if (addStructure == null) {
            return null;
        }
        if (addStructure instanceof Map && ((Map)addStructure).size() == 0 && !clazz.equalsIgnoreCase("COMPOSITION")) {
            return null;
        }
        if (key.equals("/name")) {
            if (addStructure instanceof Map) {
                return new NameInMap(this.map, (Map)addStructure).toMap();
            }
            throw new IllegalStateException("INTERNAL: addStructure is not a map, found:" + addStructure.getClass());
        }
        try {
            if (addStructure instanceof RMObject) {
                this.map.put(key, new RmObjectEncoding((RMObject)addStructure).toMap());
            } else {
                this.map.put(key, addStructure);
            }
            if (node instanceof Locatable && this.map instanceof PredicatedMap && !this.map.containsKey("/name")) {
                new NameInMap(this.map, new NameAsDvText(((Locatable)node).getName()).toMap()).toMap();
            }
        }
        catch (IllegalArgumentException e) {
            this.log.error("Ignoring duplicate key in path detected:" + key + " Exception:" + e);
        }
        if (clazz != null && !key.equals("/$PATH$") && !this.map.containsKey("/$CLASS$")) {
            this.map.put("/$CLASS$", clazz);
        } else {
            this.log.debug(this.map.containsKey("/$CLASS$") ? "duplicate TAG_CLASS" : "null clazz");
        }
        return this.map;
    }

    public Map<String, Object> insert(Object node, String key, Object addStructure) {
        String clazz = new SimpleClassName(node).toString();
        return this.insert(clazz, node, key, addStructure);
    }
}

