/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import java.io.IOException;
import java.util.Map;
import org.ehrbase.serialisation.RMDataFormat;
import org.ehrbase.serialisation.dbencoding.CompositionSerializer;
import org.ehrbase.serialisation.dbencoding.rawjson.LightRawJsonEncoder;
import org.ehrbase.serialisation.jsonencoding.JacksonUtil;

public class RawJson
implements RMDataFormat {
    private Map<String, String> ltreeMap;

    @Override
    public String marshal(RMObject rmObject) {
        try {
            CompositionSerializer compositionSerializer = new CompositionSerializer();
            String encode = compositionSerializer.dbEncode(rmObject);
            this.ltreeMap = compositionSerializer.getLtreeMap();
            return encode;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public <T extends RMObject> T unmarshal(String value, Class<T> clazz) {
        String converted = clazz.equals(Composition.class) ? new LightRawJsonEncoder(value).encodeCompositionAsString() : new LightRawJsonEncoder(value).encodeContentAsString(null);
        try {
            return (T)((RMObject)JacksonUtil.getObjectMapper().readValue(converted, clazz));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Map<String, String> getLtreeMap() {
        return this.ltreeMap;
    }
}

