/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding;

import com.nedap.archie.rm.datavalues.DataValue;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import org.ehrbase.serialisation.dbencoding.SimpleClassName;

public class CompositeClassName {
    private DataValue dataValue;

    public CompositeClassName(DataValue dataValue) {
        this.dataValue = dataValue;
    }

    public String toString() {
        String classname = new SimpleClassName(this.dataValue).toString();
        if ("DvInterval".equals(classname) && (((DvInterval)this.dataValue).getLower() != null || ((DvInterval)this.dataValue).getUpper() != null)) {
            DvInterval interval = (DvInterval)this.dataValue;
            String lowerClassName = null;
            String upperClassName = null;
            if (interval.getLower() != null) {
                lowerClassName = new SimpleClassName(interval.getLower()).toString();
            }
            if (interval.getUpper() != null) {
                upperClassName = new SimpleClassName(interval.getUpper()).toString();
            }
            if (lowerClassName != null && upperClassName != null && !lowerClassName.equals(upperClassName)) {
                throw new IllegalArgumentException("Lower and Upper classnames do not match:" + lowerClassName + " vs." + upperClassName);
            }
            return classname + "<" + (lowerClassName != null ? lowerClassName : upperClassName) + ">";
        }
        return classname;
    }
}

