/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes.datavalues.datetime.time;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import org.ehrbase.serialisation.attributes.datavalues.datetime.I_TimeAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.TemporalAttributes;

abstract class DvTimeAttributesImp
extends TemporalAttributes
implements I_TimeAttributes {
    protected final DvTime dvTime;
    protected ZoneOffset zoneOffset;

    DvTimeAttributesImp(DvTime dvTime) {
        this.dvTime = dvTime;
        if (dvTime.getValue().isSupported(ChronoField.OFFSET_SECONDS)) {
            this.zoneOffset = ZoneOffset.from(dvTime.getValue());
        }
    }

    @Override
    public Temporal getValueAsProvided() {
        return (Temporal)this.dvTime.getValue();
    }

    @Override
    public Long getMagnitude() {
        return Math.round(this.dvTime.getMagnitude());
    }

    @Override
    public Long getTimeStamp() {
        return this.getMagnitude();
    }

    public Integer supportedChronoFields(Integer chronoFieldBitmask) {
        return 0x2000000 | chronoFieldBitmask;
    }

    @Override
    public boolean isRmDvTime() {
        return (this.getSupportedChronoFields() & 0x2000000) == 0x2000000;
    }

    @Override
    public boolean isTimeHH() {
        return this.getSupportedChronoFields() == 0x2000008;
    }

    @Override
    public boolean isTimeHHMM() {
        return this.getSupportedChronoFields() == 0x200000C;
    }

    @Override
    public boolean isTimeHHMMSS() {
        return this.getSupportedChronoFields() == 0x200000E;
    }

    @Override
    public boolean isTimeHHMMSSmmm() {
        return this.getSupportedChronoFields() == 0x200000F;
    }

    @Override
    public ZoneOffset getZoneOffset() {
        return this.zoneOffset;
    }
}

