/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes.datavalues.datetime.time;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import org.ehrbase.serialisation.attributes.datavalues.datetime.I_PartialTime;
import org.ehrbase.serialisation.attributes.datavalues.datetime.I_TimeAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.TemporalAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.time.DvTimeAttributesImp;
import org.ehrbase.serialisation.attributes.datavalues.datetime.time.DvTimehhImp;
import org.ehrbase.serialisation.attributes.datavalues.datetime.time.DvTimehhmmImp;
import org.ehrbase.serialisation.attributes.datavalues.datetime.time.DvTimehhmmssImp;
import org.ehrbase.serialisation.attributes.datavalues.datetime.time.DvTimehhmmssfffImp;
import org.ehrbase.serialisation.attributes.datavalues.datetime.time.PartialTime;

public class DvTimeAttributes
extends TemporalAttributes
implements I_TimeAttributes {
    private I_TimeAttributes timeAttributes;
    private static ZoneOffset zoneOffset;

    private DvTimeAttributes(I_TimeAttributes timeAttributes) {
        this.timeAttributes = timeAttributes;
    }

    public static DvTimeAttributes instanceFromValue(TemporalAccessor timeValue) {
        if (!timeValue.isSupported(ChronoField.HOUR_OF_DAY)) {
            return null;
        }
        try {
            zoneOffset = ZoneOffset.from(timeValue);
        }
        catch (Exception e) {
            zoneOffset = null;
        }
        if (zoneOffset != null) {
            OffsetTime offsetTime = OffsetTime.of(timeValue.get(ChronoField.HOUR_OF_DAY), timeValue.get(ChronoField.MINUTE_OF_HOUR), timeValue.get(ChronoField.SECOND_OF_MINUTE), timeValue.get(ChronoField.NANO_OF_SECOND), zoneOffset);
            return DvTimeAttributes.instanceFromValue(new DvTime((TemporalAccessor)offsetTime));
        }
        LocalTime localTime = LocalTime.of(timeValue.get(ChronoField.HOUR_OF_DAY), timeValue.get(ChronoField.MINUTE_OF_HOUR), timeValue.get(ChronoField.SECOND_OF_MINUTE), timeValue.get(ChronoField.NANO_OF_SECOND));
        return DvTimeAttributes.instanceFromValue(new DvTime((TemporalAccessor)localTime));
    }

    public static DvTimeAttributes instanceFromValue(DvTime dvTime) {
        DvTimeAttributesImp timeAttributes;
        I_PartialTime partialTime = PartialTime.getInstance(dvTime);
        if (partialTime.ishhmmssfff()) {
            timeAttributes = new DvTimehhmmssfffImp(dvTime);
        } else if (partialTime.ishhmmss()) {
            timeAttributes = new DvTimehhmmssImp(dvTime);
        } else if (partialTime.ishhmm()) {
            timeAttributes = new DvTimehhmmImp(dvTime);
        } else if (partialTime.ishh()) {
            timeAttributes = new DvTimehhImp(dvTime);
        } else {
            throw new IllegalArgumentException("Invalid time:" + dvTime.getValue().toString());
        }
        return new DvTimeAttributes(timeAttributes);
    }

    @Override
    public Long getMagnitude() {
        return this.timeAttributes.getMagnitude();
    }

    @Override
    public Temporal getValueAsProvided() {
        return this.timeAttributes.getValueAsProvided();
    }

    @Override
    public Temporal getValueExtended() {
        return this.timeAttributes.getValueExtended();
    }

    @Override
    public Integer getSupportedChronoFields() {
        return this.timeAttributes.getSupportedChronoFields();
    }

    @Override
    public Long getTimeStamp() {
        return this.timeAttributes.getTimeStamp();
    }

    @Override
    public boolean isRmDvTime() {
        return this.timeAttributes.isRmDvTime();
    }

    @Override
    public boolean isTimeHH() {
        return this.timeAttributes.isTimeHH();
    }

    @Override
    public boolean isTimeHHMM() {
        return this.timeAttributes.isTimeHHMM();
    }

    @Override
    public boolean isTimeHHMMSS() {
        return this.timeAttributes.isTimeHHMMSS();
    }

    @Override
    public boolean isTimeHHMMSSmmm() {
        return this.timeAttributes.isTimeHHMMSSmmm();
    }

    @Override
    public ZoneOffset getZoneOffset() {
        return zoneOffset;
    }
}

