/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes.datavalues.datetime.date;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvDate;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import org.ehrbase.serialisation.attributes.datavalues.datetime.I_DateAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.TemporalAttributes;

public abstract class DvDateAttributesImp
extends TemporalAttributes
implements I_DateAttributes {
    protected final DvDate dvDate;

    public DvDateAttributesImp(DvDate dvDate) {
        this.dvDate = dvDate;
    }

    @Override
    public Temporal getValueAsProvided() {
        return this.dvDate.getValue();
    }

    @Override
    public Long getMagnitude() {
        return LocalDate.from(this.getValueExtended()).toEpochDay();
    }

    @Override
    public Long getTimeStamp() {
        return LocalDateTime.from(LocalDate.parse(this.getValueExtended().toString() + "T00:00:00")).toEpochSecond(ZoneOffset.UTC);
    }

    public Integer supportedChronoFields(Integer chronoFieldBitmask) {
        return 0x1000000 | chronoFieldBitmask;
    }

    @Override
    public boolean isRmDvDate() {
        return (this.getSupportedChronoFields() & 0x1000000) == 0x1000000;
    }

    @Override
    public boolean isDateYYYY() {
        return this.getSupportedChronoFields() == 0x1000400;
    }

    @Override
    public boolean isDateYYYYMM() {
        return this.getSupportedChronoFields() == 0x1000600;
    }

    @Override
    public boolean isDateYYYYMMDD() {
        return this.getSupportedChronoFields() == 0x1000700;
    }
}

