/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes;

import com.nedap.archie.rm.generic.Participation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ehrbase.serialisation.attributes.SubjectAttributes;
import org.ehrbase.serialisation.dbencoding.CompositionSerializer;
import org.ehrbase.serialisation.dbencoding.PathMap;
import org.ehrbase.serialisation.dbencoding.SimpleClassName;

public class OtherParticipationAttributes {
    private final List<Participation> participationList;
    private final CompositionSerializer compositionSerializer;

    public OtherParticipationAttributes(List<Participation> participationList, CompositionSerializer compositionSerializer) {
        this.participationList = participationList;
        this.compositionSerializer = compositionSerializer;
    }

    public List<Map<String, Object>> toMap() {
        ArrayList<Map<String, Object>> participations = new ArrayList<Map<String, Object>>();
        for (Participation participation : this.participationList) {
            Map<String, Object> valuemap = PathMap.getInstance();
            valuemap.put("/$CLASS$", new SimpleClassName(participation).toString());
            valuemap.put("function", participation.getFunction());
            valuemap.put("mode", participation.getMode());
            valuemap.put("time", participation.getTime());
            valuemap.put("performer", new SubjectAttributes(participation.getPerformer(), this.compositionSerializer).toMap());
            participations.add(valuemap);
        }
        return participations;
    }
}

