/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Entry;
import java.util.Map;
import org.ehrbase.serialisation.attributes.LocatableAttributes;
import org.ehrbase.serialisation.attributes.OtherParticipationAttributes;
import org.ehrbase.serialisation.attributes.SubjectAttributes;
import org.ehrbase.serialisation.dbencoding.CompositionSerializer;
import org.ehrbase.serialisation.dbencoding.ItemStack;
import org.ehrbase.serialisation.dbencoding.RmObjectEncoding;

public abstract class EntryAttributes
extends LocatableAttributes {
    public EntryAttributes(CompositionSerializer compositionSerializer, ItemStack itemStack, Map<String, Object> map) {
        super(compositionSerializer, itemStack, map);
    }

    protected Map<String, Object> toMap(Entry entry) {
        if (entry.getSubject() != null) {
            this.map.put("/subject", new SubjectAttributes(entry.getSubject(), this.compositionSerializer).toMap());
        }
        if (entry.getLanguage() != null) {
            this.map.put("/language", new RmObjectEncoding((RMObject)entry.getLanguage()).toMap());
        }
        if (entry.getProvider() != null) {
            this.map.put("/provider", new SubjectAttributes(entry.getProvider(), this.compositionSerializer).toMap());
        }
        if (entry.getEncoding() != null) {
            this.map.put("/encoding", new RmObjectEncoding((RMObject)entry.getEncoding()).toMap());
        }
        if (entry.getWorkflowId() != null) {
            this.map = this.toMap("/workflow_id", entry.getWorkflowId(), entry.getName());
        }
        if (entry.getOtherParticipations() != null && !entry.getOtherParticipations().isEmpty()) {
            this.map.put("/other_participations", new OtherParticipationAttributes(entry.getOtherParticipations(), this.compositionSerializer).toMap());
        }
        this.map = super.toMap((Locatable)entry);
        return this.map;
    }

    public static boolean isEntryAttribute(String key) {
        return key.equals("/subject") || key.equals("/language") || key.equals("/provider") || key.equals("/encoding") || key.equals("/workflow_id") || key.equals("/other_participations");
    }
}

