/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.classgenerator;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.ehrbase.client.classgenerator.ClassGeneratorConfig;
import org.ehrbase.serialisation.util.SnakeCase;
import org.ehrbase.util.reflection.ReflectionHelper;
import org.ehrbase.webtemplate.filter.Filter;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.parser.FlatPath;
import org.ehrbase.webtemplate.parser.config.RmIntrospectConfig;

public class FlattFilter
extends Filter {
    private static final Map<Class<?>, RmIntrospectConfig> configMap = ReflectionHelper.buildMap(RmIntrospectConfig.class);
    private ClassGeneratorConfig config;

    public FlattFilter(ClassGeneratorConfig config) {
        this.config = config;
    }

    protected boolean skip(WebTemplateNode node, WebTemplate context, Deque<WebTemplateNode> deque) {
        WebTemplateNode parent = deque.peek();
        if (this.isTrivialNode(node, parent)) {
            return true;
        }
        if (parent != null) {
            SetUtils.SetView difference;
            RMTypeInfo typeInfo = ARCHIE_RM_INFO_LOOKUP.getTypeInfo(parent.getRmType());
            Set attributeNames = Optional.ofNullable(configMap.get(typeInfo.getJavaClass())).map(RmIntrospectConfig::getNonTemplateFields).orElse(Collections.emptySet()).stream().map(s -> new SnakeCase(s).camelToSnake()).collect(Collectors.toSet());
            attributeNames.add("context");
            attributeNames.add("timing");
            attributeNames.add("expiry_time");
            attributeNames.add("lower");
            attributeNames.add("upper");
            attributeNames.add("ism_transition");
            attributeNames.add("location");
            attributeNames.add("lower_included");
            attributeNames.add("upper_included");
            attributeNames.add("sample_count");
            deque.poll();
            if (!this.isTrivialNode(parent, deque.peek()) && Locatable.class.isAssignableFrom(typeInfo.getJavaClass())) {
                attributeNames.add("feeder_audit");
            }
            deque.push(parent);
            if (this.config.isAddNullFlavor()) {
                attributeNames.add("null_flavour");
            }
            if ((difference = SetUtils.difference(typeInfo.getAttributes().keySet(), attributeNames)).contains((Object)node.getName())) {
                return true;
            }
        }
        return false;
    }

    private boolean isTrivialNode(WebTemplateNode node, WebTemplateNode parent) {
        switch (this.config.getOptimizerSetting()) {
            case ALL: {
                return !node.getChildren().isEmpty() && node.getMax() == 1 && !node.getRmType().equals("COMPOSITION") && (!this.isEvent(node) || this.isSkippableEvent(parent, node));
            }
            case SECTION: {
                return !(node.getChildren().isEmpty() || node.getMax() != 1 || node.isArchetype() && !node.getRmType().equals("SECTION") || this.isEvent(node) && !this.isSkippableEvent(parent, node));
            }
        }
        return !node.getChildren().isEmpty() && node.getMax() == 1 && !node.isArchetype() && (!this.isEvent(node) || this.isSkippableEvent(parent, node));
    }

    private boolean isSkippableEvent(WebTemplateNode parent, WebTemplateNode node) {
        if (node.getRmType().equals("EVENT") && (this.config.isGenerateChoicesForSingleEvent() || node.isMulti())) {
            return false;
        }
        return parent.getChildren().stream().filter(arg_0 -> ((FlattFilter)this).isEvent(arg_0)).count() == 1L && !node.isMulti();
    }

    protected void preHandle(WebTemplateNode node) {
        List ismTransitionList;
        if (new FlatPath(node.getAqlPath()).getLast().getName().equals("null_flavour")) {
            node.setName("null_flavour");
        }
        if (!(ismTransitionList = node.getChildren().stream().filter(n -> "ISM_TRANSITION".equals(n.getRmType())).collect(Collectors.toList())).isEmpty()) {
            node.getChildren().removeAll(ismTransitionList);
            node.getChildren().add((WebTemplateNode)ismTransitionList.get(0));
        }
        if (node.getRmType().equals("ELEMENT") && node.getChildren().size() <= 5 && node.getChildren().stream().filter(n -> !List.of("null_flavour", "feeder_audit").contains(n.getName())).map(WebTemplateNode::getRmType).collect(Collectors.toList()).containsAll(List.of("DV_TEXT", "DV_CODED_TEXT"))) {
            WebTemplateNode merged = (WebTemplateNode)node.findChildById(node.getId(false)).orElseThrow();
            node.getChildren().remove(merged);
        }
    }
}

