/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.classgenerator;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.datastructures.IntervalEvent;
import com.nedap.archie.rm.datastructures.PointEvent;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Generated;
import javax.lang.model.element.Modifier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.client.annotations.Archetype;
import org.ehrbase.client.annotations.Choice;
import org.ehrbase.client.annotations.Entity;
import org.ehrbase.client.annotations.Id;
import org.ehrbase.client.annotations.OptionFor;
import org.ehrbase.client.annotations.Path;
import org.ehrbase.client.annotations.Template;
import org.ehrbase.client.classgenerator.ClassGeneratorConfig;
import org.ehrbase.client.classgenerator.ClassGeneratorContext;
import org.ehrbase.client.classgenerator.ClassGeneratorResult;
import org.ehrbase.client.classgenerator.DefaultNamingStrategy;
import org.ehrbase.client.classgenerator.EnumValueSet;
import org.ehrbase.client.classgenerator.FlattFilter;
import org.ehrbase.client.classgenerator.NamingStrategy;
import org.ehrbase.client.classgenerator.config.RmClassGeneratorConfig;
import org.ehrbase.client.classgenerator.interfaces.CompositionEntity;
import org.ehrbase.client.classgenerator.interfaces.EntryEntity;
import org.ehrbase.client.classgenerator.interfaces.IntervalEventEntity;
import org.ehrbase.client.classgenerator.interfaces.LocatableEntity;
import org.ehrbase.client.classgenerator.interfaces.PointEventEntity;
import org.ehrbase.client.classgenerator.interfaces.RMEntity;
import org.ehrbase.client.classgenerator.shareddefinition.Category;
import org.ehrbase.client.classgenerator.shareddefinition.Language;
import org.ehrbase.client.classgenerator.shareddefinition.MathFunction;
import org.ehrbase.client.classgenerator.shareddefinition.NullFlavour;
import org.ehrbase.client.classgenerator.shareddefinition.Setting;
import org.ehrbase.client.classgenerator.shareddefinition.Territory;
import org.ehrbase.client.classgenerator.shareddefinition.Transition;
import org.ehrbase.client.openehrclient.VersionUid;
import org.ehrbase.serialisation.util.SnakeCase;
import org.ehrbase.serialisation.walker.Walker;
import org.ehrbase.terminology.client.terminology.TermDefinition;
import org.ehrbase.terminology.client.terminology.ValueSet;
import org.ehrbase.util.reflection.ReflectionHelper;
import org.ehrbase.webtemplate.filter.WebTemplateFilter;
import org.ehrbase.webtemplate.model.FilteredWebTemplate;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.parser.FlatPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassGenerator {
    private static final ArchieRMInfoLookup RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    public static final String ABBREV_MARKER = "_";
    public static final int CLASS_NAME_MAX_WIDTH = 80;
    private static final Map<Class<?>, RmClassGeneratorConfig> configMap = ReflectionHelper.buildMap(RmClassGeneratorConfig.class);
    public static final String DEFINITION_PACKAGE = ".definition";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final WebTemplateFilter filter;
    private final NamingStrategy defaultNamingStrategy;

    public ClassGenerator(WebTemplateFilter filter, NamingStrategy defaultNamingStrategy) {
        this.filter = filter;
        this.defaultNamingStrategy = defaultNamingStrategy;
    }

    public ClassGenerator(ClassGeneratorConfig config) {
        this((WebTemplateFilter)new FlattFilter(config), new DefaultNamingStrategy(config));
    }

    public ClassGeneratorResult generate(String packageName, WebTemplate webTemplate) {
        FilteredWebTemplate filteredWebTemplate;
        ClassGeneratorContext context = new ClassGeneratorContext();
        context.currentPackageName = packageName;
        context.webTemplate = filteredWebTemplate = this.filter.filter(webTemplate);
        TypeSpec.Builder builder = this.build(context, filteredWebTemplate.getTree());
        AnnotationSpec templateAnnotation = AnnotationSpec.builder(Template.class).addMember("value", "$S", new Object[]{webTemplate.getTemplateId()}).build();
        builder.addAnnotation(templateAnnotation);
        this.addVersionUid(builder);
        context.classes.put((Object)(packageName + "." + context.currentMainClass.toLowerCase()), (Object)builder.build());
        ClassGeneratorResult generatorResult = new ClassGeneratorResult();
        context.classes.entries().forEach(e -> generatorResult.addClass((String)e.getKey(), (TypeSpec)e.getValue()));
        return generatorResult;
    }

    private void addVersionUid(TypeSpec.Builder classBuilder) {
        FieldSpec versionUid = FieldSpec.builder(VersionUid.class, (String)"versionUid", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Id.class).build();
        classBuilder.addField(versionUid);
        classBuilder.addMethod(this.buildGetter(versionUid, false));
        classBuilder.addMethod(this.buildSetter(versionUid, false));
    }

    private TypeSpec.Builder build(ClassGeneratorContext context, WebTemplateNode next) {
        String className = this.defaultNamingStrategy.buildClassName(context, next, false, false);
        context.currentFieldNameMap.push(new HashMap());
        context.nodeDeque.push(next);
        context.unFilteredNodeDeque.push(next);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)className);
        if (StringUtils.isBlank((CharSequence)context.currentMainClass)) {
            context.currentMainClass = className;
        }
        classBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        classBuilder.addAnnotation(AnnotationSpec.builder(Entity.class).build());
        if (next.isArchetype()) {
            AnnotationSpec archetypeAnnotation = AnnotationSpec.builder(Archetype.class).addMember("value", "$S", new Object[]{next.getNodeId()}).build();
            classBuilder.addAnnotation(archetypeAnnotation);
        }
        AnnotationSpec generatedAnnotation = this.buildGeneratedAnnotation();
        classBuilder.addAnnotation(generatedAnnotation);
        classBuilder.addSuperinterface(this.findRMInterface(next));
        if (next.getChildren().stream().anyMatch(n -> n.getRmType().equals("EVENT"))) {
            WebTemplateNode event = next.getChildren().stream().filter(n -> n.getRmType().equals("EVENT")).findAny().orElseThrow();
            Walker.EventHelper eventHelper = new Walker.EventHelper(event).invoke();
            WebTemplateNode pointEvent = eventHelper.getPointEvent();
            WebTemplateNode intervalEvent = eventHelper.getIntervalEvent();
            next.getChildren().add(intervalEvent);
            next.getChildren().add(pointEvent);
            next.getChildren().remove(event);
        }
        Map choices = next.getChoicesInChildren();
        List children = next.getChildren().stream().filter(c -> choices.values().stream().flatMap(Collection::stream).noneMatch(l -> l.equals(c))).collect(Collectors.toList());
        for (WebTemplateNode child : children) {
            Deque<WebTemplateNode> filtersNodes = this.pushToUnfiltered(context, child);
            String relativPath = context.nodeDeque.peek().buildRelativPath(child);
            if (child.getChildren().isEmpty() && !choices.containsKey(child.getAqlPath())) {
                this.addSimpleField(context, classBuilder, relativPath, child);
            } else if (!choices.containsKey(child.getAqlPath())) {
                this.addComplexField(context, classBuilder, relativPath, child);
            }
            if (CollectionUtils.isEmpty(filtersNodes)) continue;
            filtersNodes.forEach(n -> context.unFilteredNodeDeque.poll());
        }
        for (List choice : choices.values()) {
            ClassName interfaceClassName;
            TypeSpec interfaceSpec;
            WebTemplateNode node = (WebTemplateNode)choice.get(0);
            WebTemplateNode relativeNode = this.buildRelativeNode(context, node);
            Deque<WebTemplateNode> filtersNodes = this.pushToUnfiltered(context, node);
            if (context.currentTypeSpec.containsKey(relativeNode)) {
                interfaceSpec = context.currentTypeSpec.get(relativeNode);
                String interfacePackage = context.currentPackageName + "." + context.currentMainClass.toLowerCase() + DEFINITION_PACKAGE;
                context.classes.put((Object)interfacePackage, (Object)interfaceSpec);
                interfaceClassName = ClassName.get((String)interfacePackage, (String)interfaceSpec.name, (String[])new String[0]);
            } else {
                ArrayList<ImmutablePair> builders = new ArrayList<ImmutablePair>();
                for (WebTemplateNode child : choice) {
                    TypeSpec.Builder build = this.build(context, child);
                    builders.add(new ImmutablePair((Object)build, (Object)child));
                }
                TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)this.defaultNamingStrategy.buildClassName(context, (WebTemplateNode)choice.get(0), true, false)).addModifiers(new Modifier[]{Modifier.PUBLIC});
                interfaceBuilder.addAnnotation(this.buildGeneratedAnnotation());
                Set cowmenField = null;
                for (Set fields : builders.stream().map(Pair::getLeft).map(s -> s.fieldSpecs).map(HashSet::new).collect(Collectors.toList())) {
                    if (cowmenField == null) {
                        cowmenField = fields;
                        continue;
                    }
                    cowmenField = SetUtils.intersection((Set)cowmenField, (Set)fields);
                }
                if (cowmenField == null) {
                    cowmenField = Collections.emptySet();
                }
                cowmenField.forEach(f -> {
                    interfaceBuilder.addMethod(this.buildGetter((FieldSpec)f, true));
                    interfaceBuilder.addMethod(this.buildSetter((FieldSpec)f, true));
                });
                interfaceSpec = interfaceBuilder.build();
                context.currentTypeSpec.put(relativeNode, interfaceSpec);
                String interfacePackage = context.currentPackageName + "." + context.currentMainClass.toLowerCase() + DEFINITION_PACKAGE;
                context.classes.put((Object)interfacePackage, (Object)interfaceSpec);
                ClassName finalInterfaceClassName = interfaceClassName = ClassName.get((String)interfacePackage, (String)interfaceSpec.name, (String[])new String[0]);
                builders.forEach(arg_0 -> ClassGenerator.lambda$build$8((TypeName)finalInterfaceClassName, context, interfacePackage, arg_0));
            }
            if (choice.stream().anyMatch(WebTemplateNode::isMulti)) {
                interfaceClassName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{interfaceClassName});
            }
            String relativPath = FlatPath.removeStart((FlatPath)new FlatPath(node.getAqlPath()), (FlatPath)new FlatPath(next.getAqlPath())).toString();
            this.addField(context, classBuilder, relativPath, node, (TypeName)interfaceClassName, new ValueSet("local", "local", Collections.emptySet()), true);
            if (CollectionUtils.isEmpty(filtersNodes)) continue;
            filtersNodes.forEach(n -> context.unFilteredNodeDeque.poll());
        }
        if (next.isArchetype()) {
            context.currentArchetypeName.poll();
        }
        if (children.isEmpty() && choices.isEmpty()) {
            this.addSimpleField(context, classBuilder, "", next);
        }
        context.currentFieldNameMap.poll();
        context.nodeDeque.poll();
        context.unFilteredNodeDeque.poll();
        return classBuilder;
    }

    private AnnotationSpec buildGeneratedAnnotation() {
        return AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{this.getClass().getName()}).addMember("date", "$S", new Object[]{OffsetDateTime.now().toString()}).addMember("comments", "$S", new Object[]{"https://github.com/ehrbase/openEHR_SDK Version: " + this.getClass().getPackage().getImplementationVersion()}).build();
    }

    private Type findRMInterface(WebTemplateNode next) {
        Class classToBeCreated = RM_INFO_LOOKUP.getClassToBeCreated(next.getRmType());
        if (Composition.class.isAssignableFrom(classToBeCreated)) {
            return CompositionEntity.class;
        }
        if (Entry.class.isAssignableFrom(classToBeCreated)) {
            return EntryEntity.class;
        }
        if (IntervalEvent.class.isAssignableFrom(classToBeCreated)) {
            return IntervalEventEntity.class;
        }
        if (PointEvent.class.isAssignableFrom(classToBeCreated)) {
            return PointEventEntity.class;
        }
        if (Locatable.class.isAssignableFrom(classToBeCreated)) {
            return LocatableEntity.class;
        }
        return RMEntity.class;
    }

    private Deque<WebTemplateNode> pushToUnfiltered(ClassGeneratorContext context, WebTemplateNode node) {
        Deque filtersNodes = context.webTemplate.findFiltersNodes(node);
        if (!CollectionUtils.isEmpty((Collection)filtersNodes)) {
            filtersNodes.descendingIterator().forEachRemaining(context.unFilteredNodeDeque::push);
        }
        return filtersNodes;
    }

    private void addComplexField(ClassGeneratorContext context, TypeSpec.Builder classBuilder, String path, WebTemplateNode node) {
        TypeSpec subSpec;
        WebTemplateNode relativeNode = this.buildRelativeNode(context, node);
        if (context.currentTypeSpec.containsKey(relativeNode)) {
            subSpec = context.currentTypeSpec.get(relativeNode);
        } else {
            subSpec = this.build(context, node).build();
            context.currentTypeSpec.put(relativeNode, subSpec);
        }
        String subSpecPackage = context.currentPackageName + "." + context.currentMainClass.toLowerCase() + DEFINITION_PACKAGE;
        context.classes.put((Object)subSpecPackage, (Object)subSpec);
        ClassName className = ClassName.get((String)subSpecPackage, (String)subSpec.name, (String[])new String[0]);
        if (node.isMulti()) {
            className = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{className});
        }
        this.addField(context, classBuilder, path, node, (TypeName)className, new ValueSet("local", "local", Collections.emptySet()), false);
    }

    private WebTemplateNode buildRelativeNode(ClassGeneratorContext context, WebTemplateNode node) {
        WebTemplateNode relativeNode = new WebTemplateNode(node);
        List matching = relativeNode.findMatching(n -> true);
        matching.add(relativeNode);
        matching.forEach(n -> n.setAqlPath(context.nodeDeque.peek().buildRelativPath(n)));
        return relativeNode;
    }

    private void addSimpleField(ClassGeneratorContext context, TypeSpec.Builder classBuilder, String path, WebTemplateNode endNode) {
        boolean expand;
        Class<?> clazz = this.extractClass(endNode);
        if (clazz == null) {
            this.logger.warn("No class for path {} ", (Object)path);
            return;
        }
        ValueSet valueSet = this.buildValueSet(endNode);
        RmClassGeneratorConfig classGeneratorConfig = configMap.get(clazz);
        if (classGeneratorConfig == null && !clazz.getName().contains("java.lang")) {
            this.logger.debug("No ClassGenerator for {}", clazz);
        }
        boolean bl = expand = classGeneratorConfig != null && classGeneratorConfig.isExpandField();
        if (endNode.getRmType().equals("DV_CODED_TEXT") && !List.of("transition", "language", "setting", "category", "territory", "math_function", "null_flavour").contains(endNode.getId(false))) {
            boolean bl2 = expand = expand && endNode.getInputs().stream().filter(i -> i.getType().equals("CODED_TEXT")).map(WebTemplateInput::getList).flatMap(Collection::stream).findAny().isPresent();
        }
        if (!expand) {
            TypeName className = (TypeName)Optional.ofNullable(clazz).map(ClassName::get).orElse(ClassName.get(Object.class));
            if (endNode.isMulti() && !context.nodeDeque.peek().getRmType().equals("ELEMENT")) {
                className = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{className});
            }
            this.addField(context, classBuilder, path, endNode, className, valueSet, false);
        } else {
            Map<String, Field> fieldMap = Arrays.stream(FieldUtils.getAllFields(clazz)).filter(f -> !f.isSynthetic()).collect(Collectors.toMap(Field::getName, f -> f));
            Set expandFields = classGeneratorConfig.getExpandFields();
            expandFields.forEach(fieldName -> this.addField(context, classBuilder, path + "|" + new SnakeCase(fieldName).camelToSnake(), endNode, (TypeName)ClassName.get(((Field)fieldMap.get(fieldName)).getType()), valueSet, false));
        }
    }

    private Class<?> extractClass(WebTemplateNode endNode) {
        switch (endNode.getRmType()) {
            case "STRING": {
                return String.class;
            }
            case "BOOLEAN": {
                return Boolean.class;
            }
            case "INTEGER": {
                return Integer.class;
            }
            case "LONG": {
                return Long.class;
            }
        }
        return RM_INFO_LOOKUP.getClass(endNode.getRmType());
    }

    private ValueSet buildValueSet(WebTemplateNode endNode) {
        Optional<WebTemplateInput> input = endNode.getInputs().stream().filter(i -> i.getType().equals("CODED_TEXT")).findAny();
        if (input.isPresent()) {
            return new ValueSet(input.get().getTerminology(), "local", input.get().getList().stream().map(this::toTerm).collect(Collectors.toSet()));
        }
        return ValueSet.EMPTY_VALUE_SET;
    }

    private TermDefinition toTerm(WebTemplateInputValue t) {
        return new TermDefinition(t.getValue(), t.getLabel(), t.getLocalizedDescriptions().values().stream().findAny().orElse(t.getLabel()));
    }

    private void addField(ClassGeneratorContext context, TypeSpec.Builder classBuilder, String path, WebTemplateNode node, TypeName className, ValueSet valueSet, boolean addChoiceAnnotation) {
        if (CodePhrase.class.getName().equals(className.toString())) {
            switch (node.getName()) {
                case "language": {
                    className = ClassName.get(Language.class);
                    break;
                }
                case "setting": {
                    className = ClassName.get(Setting.class);
                    break;
                }
                case "category": {
                    className = ClassName.get(Category.class);
                    break;
                }
                case "territory": {
                    className = ClassName.get(Territory.class);
                    break;
                }
                case "math_function": {
                    className = ClassName.get(MathFunction.class);
                    break;
                }
                case "transition": {
                    className = ClassName.get(Transition.class);
                    break;
                }
                case "null_flavour": {
                    className = ClassName.get(NullFlavour.class);
                    break;
                }
                default: {
                    if (!CollectionUtils.isNotEmpty((Collection)valueSet.getTherms())) break;
                    TypeSpec enumValueSet = context.currentEnums.computeIfAbsent(valueSet, vs -> this.buildEnumValueSet(context, node, (ValueSet)vs));
                    String enumPackage = context.currentPackageName + "." + context.currentMainClass.toLowerCase() + DEFINITION_PACKAGE;
                    context.classes.put((Object)enumPackage, (Object)enumValueSet);
                    className = ClassName.get((String)enumPackage, (String)enumValueSet.name, (String[])new String[0]);
                }
            }
        }
        String fieldName = this.defaultNamingStrategy.buildFieldName(context, path, node);
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)className, (String)fieldName, (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(Path.class).addMember("value", "$S", new Object[]{path}).build()).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(this.defaultNamingStrategy.buildFieldJavadoc(context, node), new Object[0]);
        if (addChoiceAnnotation) {
            builder.addAnnotation(Choice.class);
        }
        FieldSpec fieldSpec = builder.build();
        classBuilder.addField(fieldSpec);
        classBuilder.addMethod(this.buildSetter(fieldSpec, false));
        classBuilder.addMethod(this.buildGetter(fieldSpec, false));
    }

    private TypeSpec buildEnumValueSet(ClassGeneratorContext context, WebTemplateNode node, ValueSet valueSet) {
        TypeSpec.Builder enumBuilder = TypeSpec.enumBuilder((String)this.defaultNamingStrategy.buildClassName(context, node, false, true)).addSuperinterface(EnumValueSet.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        FieldSpec fieldSpec1 = FieldSpec.builder((TypeName)ClassName.get(String.class), (String)"value", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        enumBuilder.addField(fieldSpec1);
        FieldSpec fieldSpec2 = FieldSpec.builder((TypeName)ClassName.get(String.class), (String)"description", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        enumBuilder.addField(fieldSpec2);
        FieldSpec fieldSpec3 = FieldSpec.builder((TypeName)ClassName.get(String.class), (String)"terminologyId", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        enumBuilder.addField(fieldSpec3);
        FieldSpec fieldSpec4 = FieldSpec.builder((TypeName)ClassName.get(String.class), (String)"code", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        enumBuilder.addField(fieldSpec4);
        MethodSpec constructor = this.buildConstructor(fieldSpec1, fieldSpec2, fieldSpec3, fieldSpec4);
        enumBuilder.addMethod(constructor);
        valueSet.getTherms().forEach(t -> enumBuilder.addEnumConstant(this.defaultNamingStrategy.buildEnumConstantName(context, node, t.getValue()), TypeSpec.anonymousClassBuilder((String)"$S, $S, $S, $S", (Object[])new Object[]{t.getValue(), t.getDescription(), valueSet.getTerminologyId(), t.getCode()}).build()));
        enumBuilder.addMethod(this.buildGetter(fieldSpec1, false));
        enumBuilder.addMethod(this.buildGetter(fieldSpec2, false));
        enumBuilder.addMethod(this.buildGetter(fieldSpec3, false));
        enumBuilder.addMethod(this.buildGetter(fieldSpec4, false));
        return enumBuilder.build();
    }

    private MethodSpec buildConstructor(FieldSpec ... fieldSpecs) {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        for (FieldSpec fieldSpec : fieldSpecs) {
            builder.addParameter(fieldSpec.type, fieldSpec.name, new Modifier[0]).addStatement("this.$N = $N", new Object[]{fieldSpec.name, fieldSpec.name});
        }
        return builder.build();
    }

    private MethodSpec buildSetter(FieldSpec fieldSpec, boolean isAbstract) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("set" + StringUtils.capitalize((String)fieldSpec.name)));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (isAbstract) {
            builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        } else {
            builder.addStatement(" this.$N = $N", new Object[]{fieldSpec.name, fieldSpec.name});
        }
        builder.addParameter(fieldSpec.type, fieldSpec.name, new Modifier[0]).build();
        return builder.build();
    }

    private MethodSpec buildGetter(FieldSpec fieldSpec, boolean isAbbstract) {
        String prefix = Boolean.class.getTypeName().equals(fieldSpec.type.toString()) ? "is" : "get";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(prefix + StringUtils.capitalize((String)fieldSpec.name)));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (isAbbstract) {
            builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        } else {
            builder.addStatement(" return this.$N ", new Object[]{fieldSpec.name});
        }
        builder.returns(fieldSpec.type);
        return builder.build();
    }

    private static /* synthetic */ void lambda$build$8(TypeName finalInterfaceClassName, ClassGeneratorContext context, String interfacePackage, Pair pair) {
        TypeSpec.Builder builder = ((TypeSpec.Builder)pair.getKey()).addSuperinterface(finalInterfaceClassName).addAnnotation(AnnotationSpec.builder(OptionFor.class).addMember("value", "$S", new Object[]{((WebTemplateNode)pair.getRight()).getRmType()}).build());
        context.classes.put((Object)interfacePackage, (Object)builder.build());
    }
}

