/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.flattener;

import com.nedap.archie.creation.RMObjectCreator;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ehrbase.client.annotations.Entity;
import org.ehrbase.client.annotations.OptionFor;
import org.ehrbase.client.annotations.Path;
import org.ehrbase.client.classgenerator.EnumValueSet;
import org.ehrbase.client.exception.ClientException;
import org.ehrbase.client.flattener.PathMatcher;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.serialisation.walker.ToCompositionWalker;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.parser.FlatPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoToCompositionWalker
extends ToCompositionWalker<Map<String, Object>> {
    public static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private static final RMObjectCreator RM_OBJECT_CREATOR = new RMObjectCreator((ModelInfoLookup)ARCHIE_RM_INFO_LOOKUP);
    private static final PathMatcher PATH_MATCHER = new PathMatcher();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected Map<String, Object> extract(Context<Map<String, Object>> context, WebTemplateNode child, boolean isChoice, Integer i) {
        Map<String, Object> subValues = this.filterValues(context, child);
        if (subValues.isEmpty()) {
            return null;
        }
        if (subValues.size() > 1) {
            if (isChoice && child.getRmType().equals("INTERVAL_EVENT")) {
                this.logger.warn("Path {} is choice but missing OptionFor", (Object)child.getAqlPath());
                return null;
            }
            return subValues;
        }
        Object value = subValues.values().stream().findAny().orElseThrow();
        if (value instanceof List && i != null) {
            Object object = value = ((List)value).size() > i ? (Object)((List)value).get(i) : null;
        }
        if (isChoice && value != null) {
            Optional<String> optionFor = Optional.of(value).map(Object::getClass).map(c -> c.getAnnotation(OptionFor.class)).map(OptionFor::value);
            if (optionFor.isEmpty()) {
                if (child.getRmType().equals("INTERVAL_EVENT")) {
                    value = null;
                } else if (!child.getRmType().equals("POINT_EVENT") && !child.getRmType().equals("DV_TEXT")) {
                    if (child.getRmType().equals("DV_CODED_TEXT")) {
                        value = null;
                    } else {
                        this.logger.warn("Path {} is choice but {} is missing OptionFor", (Object)child.getAqlPath(), (Object)value.getClass().getSimpleName());
                    }
                }
            } else if (optionFor.filter(s -> s.equals(child.getRmType())).isEmpty()) {
                value = null;
            }
        }
        if (value == null) {
            return null;
        }
        String path = (String)subValues.keySet().stream().findAny().orElseThrow();
        if (value.getClass().isAnnotationPresent(Entity.class) && new FlatPath(path).getPath().equals("")) {
            Map<String, Object> newValues = DtoToCompositionWalker.findEntity(value).entrySet().stream().collect(Collectors.toMap(e -> path + (String)e.getKey(), Map.Entry::getValue));
            return !newValues.isEmpty() ? newValues : null;
        }
        return Map.of(path, value);
    }

    private Map<String, Object> filterValues(Context<Map<String, Object>> context, WebTemplateNode child) {
        return ((Map)context.getObjectDeque().peek()).entrySet().stream().map(e -> new ImmutablePair((Object)PATH_MATCHER.matchesPath(context, child, (Map.Entry<String, ?>)e), e.getValue())).filter(p -> p.getLeft() != null).collect(Collectors.toMap(ImmutablePair::getLeft, ImmutablePair::getRight));
    }

    protected void preHandle(Context<Map<String, Object>> context) {
        Map values = (Map)context.getObjectDeque().peek();
        for (Map.Entry objectEntry : values.entrySet()) {
            FlatPath flatPath = new FlatPath((String)objectEntry.getKey());
            if (!StringUtils.isBlank((CharSequence)flatPath.getPath()) || "uuid".equals(flatPath.getAttributeName())) continue;
            if (StringUtils.isNotBlank((CharSequence)flatPath.getAttributeName())) {
                this.handleSingleValue(objectEntry.getValue(), flatPath.getAttributeName(), null, context.getRmObjectDeque().peek());
                continue;
            }
            RMObject child = (RMObject)context.getRmObjectDeque().poll();
            this.handleSingleValue(objectEntry.getValue(), new FlatPath(((WebTemplateNode)context.getNodeDeque().peek()).getAqlPath()).getLast().getName(), child, context.getRmObjectDeque().peek());
            context.getRmObjectDeque().push(child);
        }
    }

    protected void postHandle(Context<Map<String, Object>> context) {
    }

    protected int calculateSize(Context<Map<String, Object>> context, WebTemplateNode childNode) {
        Map<String, Object> values = this.filterValues(context, childNode);
        if (values.size() == 1) {
            Object value = values.values().stream().findAny().orElseThrow();
            if (value instanceof List) {
                return ((List)value).size();
            }
            return 1;
        }
        return 0;
    }

    static Map<String, Object> findEntity(Object dto) {
        return Arrays.stream(dto.getClass().getDeclaredFields()).filter(m -> m.isAnnotationPresent(Path.class)).filter(m -> DtoToCompositionWalker.readField(m, dto) != null).collect(Collectors.toMap(m -> m.getAnnotation(Path.class).value(), m -> DtoToCompositionWalker.readField(m, dto)));
    }

    private static Object readField(Field field, Object dto) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), dto.getClass());
            return propertyDescriptor.getReadMethod().invoke(dto, new Object[0]);
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    private void handleSingleValue(Object value, String childName, Object child, Object parent) {
        if (value != null) {
            if (EnumValueSet.class.isAssignableFrom(value.getClass()) && DvCodedText.class.isAssignableFrom(parent.getClass())) {
                EnumValueSet valueSet = (EnumValueSet)value;
                DvCodedText dvCodedText = (DvCodedText)parent;
                dvCodedText.setValue(valueSet.getValue());
                dvCodedText.setDefiningCode(new CodePhrase(new TerminologyId(valueSet.getTerminologyId()), valueSet.getCode()));
            } else if (EnumValueSet.class.isAssignableFrom(value.getClass()) && DvCodedText.class.isAssignableFrom(ARCHIE_RM_INFO_LOOKUP.getAttributeInfo(parent.getClass(), childName).getType())) {
                EnumValueSet valueSet = (EnumValueSet)value;
                DvCodedText dvCodedText = new DvCodedText();
                dvCodedText.setValue(valueSet.getValue());
                dvCodedText.setDefiningCode(new CodePhrase(new TerminologyId(valueSet.getTerminologyId()), valueSet.getCode()));
                RM_OBJECT_CREATOR.set(parent, childName, Collections.singletonList(dvCodedText));
            } else if (EnumValueSet.class.isAssignableFrom(value.getClass())) {
                EnumValueSet valueSet = (EnumValueSet)value;
                CodePhrase codePhrase = new CodePhrase(new TerminologyId(valueSet.getTerminologyId()), valueSet.getCode());
                RM_OBJECT_CREATOR.set(parent, childName, Collections.singletonList(codePhrase));
            } else if (ARCHIE_RM_INFO_LOOKUP.getAttributeInfo(parent.getClass(), childName).getTypeInCollection().isAssignableFrom(value.getClass())) {
                RMAttributeInfo attributeInfo = ARCHIE_RM_INFO_LOOKUP.getAttributeInfo(parent.getClass(), childName);
                if (attributeInfo.isMultipleValued()) {
                    try {
                        Object invoke = attributeInfo.getGetMethod().invoke(parent, new Object[0]);
                        if (Collection.class.isAssignableFrom(invoke.getClass()) && child != null) {
                            ((Collection)invoke).remove(child);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        this.logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
                RM_OBJECT_CREATOR.addElementToListOrSetSingleValues(parent, childName, Collections.singletonList(value));
            } else {
                this.logger.warn("Unhandled child {} in {}", (Object)childName, parent);
            }
        }
    }
}

